/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.config.ADFConfigImpl;
import oracle.adf.share.config.FallbackConfigImpl;
import oracle.adf.share.logging.ADFLogger;

public class ADFConfigFactory {
    private static Map applications = new WeakHashMap(4);
    private static final String CLASSNAME = "oracle.adf.share.config.ADFConfigFactory";
    private static final String resourceBundle = "oracle.adf.share.config.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.config.resources.Messages");
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.config.ADFConfigFactory", (String)"oracle.adf.share.config.resources.Messages");

    public static ADFConfig findOrCreateADFConfig() {
        return ADFConfigFactory.findOrCreateADFConfig("META-INF/adf-config.xml");
    }

    public static ADFConfig findOrCreateADFConfig(boolean reparse) {
        return ADFConfigFactory.findOrCreateADFConfig("META-INF/adf-config.xml", reparse);
    }

    public static ADFConfig findOrCreateADFConfig(String resourceName) {
        return ADFConfigFactory.findOrCreateADFConfig(resourceName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ADFConfig findOrCreateADFConfig(String resourceName, boolean reparse) {
        String method = "findOrCreateADFConfig";
        Map map = applications;
        synchronized (map) {
            ClassLoader cl = ClassUtils.getClassLoader();
            ADFConfigImpl app = (ADFConfigImpl)applications.get(cl);
            if (app == null) {
                ClassLoader targetCL = cl;
                ClassLoader parentCl = cl.getParent();
                if (parentCl != null) {
                    URL fromContextClassLoader = cl.getResource(resourceName);
                    URL fromParentClassLoader = parentCl.getResource(resourceName);
                    if (fromContextClassLoader != null && fromParentClassLoader != null && fromContextClassLoader.getPath().equals(fromParentClassLoader.getPath())) {
                        app = (ADFConfigImpl)applications.get(parentCl);
                        targetCL = parentCl;
                    }
                }
                if (app == null) {
                    InputStream is = targetCL.getResourceAsStream(resourceName);
                    if (is != null) {
                        URL url = targetCL.getResource(resourceName);
                        mLogger.fine(CLASSNAME, "findOrCreateADFConfig", resBundle.getString("READING_URL"), (Object)url.getPath());
                        app = new ADFConfigImpl(is, resourceName);
                    } else {
                        mLogger.fine(CLASSNAME, "findOrCreateADFConfig", resBundle.getString("RESOURCE_NOT_FOUND"), (Object)resourceName);
                        app = new FallbackConfigImpl();
                    }
                    if (targetCL != cl) {
                        applications.put(targetCL, app);
                    }
                } else {
                    app.registerCallbackListeners();
                }
                applications.put(cl, app);
                try {
                    Enumeration<URL> urlList = cl.getResources(resourceName);
                    int count = 0;
                    String mesg = resBundle.getString("PRINT_URLS");
                    mLogger.fine(CLASSNAME, "findOrCreateADFConfig", mesg, (Object)resourceName);
                    while (urlList.hasMoreElements()) {
                        URL url = urlList.nextElement();
                        mLogger.fine(count++ + ": " + url.getPath());
                    }
                    mLogger.fine("\n");
                    if (count > 1) {
                        mLogger.warning(CLASSNAME, "findOrCreateADFConfig", resBundle.getString("MULTIPLE_RESOURCES_FOUND"), (Object)resourceName);
                    }
                }
                catch (IOException ignore) {}
            } else if (app instanceof ADFConfigImpl) {
                boolean resourceRead = app.isResourceVisited(resourceName);
                if (reparse || !resourceRead) {
                    InputStream is = cl.getResourceAsStream(resourceName);
                    if (is != null) {
                        app.readConfig(is, resourceName, reparse);
                    } else {
                        app.setResourceVisited(resourceName);
                    }
                }
            }
            ADFConfigImpl aDFConfigImpl = app;
            return aDFConfigImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADFConfig findADFConfig(String namedConfig) {
        Map map = applications;
        synchronized (map) {
            ADFConfig aDFConfig = (ADFConfig)applications.get(namedConfig);
            return aDFConfig;
        }
    }

    public static ADFConfig findOrCreateADFConfig(String name, URL url) {
        return ADFConfigFactory.findOrCreateADFConfig(name, url, ADFConfigImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ADFConfig findOrCreateADFConfig(String name, URL url, Class configClass) {
        Map map = applications;
        synchronized (map) {
            ADFConfig app = (ADFConfig)applications.get(name);
            if (app == null) {
                Object[] parameters = new Object[]{name, url};
                Class[] parameterTypes = new Class[]{String.class, URL.class};
                try {
                    Constructor constructor = configClass.getConstructor(parameterTypes);
                    app = (ADFConfig)constructor.newInstance(parameters);
                }
                catch (Exception e) {
                    app = null;
                }
                if (app != null) {
                    applications.put(name, app);
                }
            }
            ADFConfig aDFConfig = app;
            return aDFConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterNamedConfig(String namedConfig) {
        Map map = applications;
        synchronized (map) {
            applications.remove(namedConfig);
        }
    }
}

