/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.ADFContext;
import oracle.adf.share.ADFShareException;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.MetadataRegistry;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.config.ConfigHelper;
import oracle.adf.share.config.FallbackConfigImpl;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFConfigImpl
implements ADFConfig {
    public static final String CALLBACK_FILE = "META-INF/services/adf-config.properties";
    public static final String ADF_CONFIG_CHILD = "adf-config-child";
    protected Hashtable _storedResults;
    protected Hashtable _storeParsedElements;
    protected List _resourceReadList;
    protected Map _callbackMap;
    protected String _applicationName;
    private static int _appCounter = 0;
    private boolean _isNamedConfig;
    protected String _namedConfig;
    protected URL _url;
    private static final String resourceBundle = "oracle.adf.share.config.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.config.resources.Messages");
    private static final String CLASSNAME = ADFConfigImpl.class.getName();
    private static final ADFLogger _logger = ADFLogger.createADFLogger((String)CLASSNAME);
    private static MetadataRegistry rcutils = null;

    private void $init$() {
        this._storedResults = new Hashtable(10);
        this._storeParsedElements = new Hashtable(10);
        this._resourceReadList = new Vector(2);
        this._callbackMap = new HashMap(20);
        this._isNamedConfig = false;
        this._namedConfig = null;
        this._url = null;
    }

    ADFConfigImpl() {
        this.$init$();
        this.init();
    }

    ADFConfigImpl(InputStream is, String resource) {
        this.$init$();
        this.init();
        this.readConfig(is, resource);
    }

    public ADFConfigImpl(String namedConfig, URL url) {
        this.$init$();
        this.init();
        this._isNamedConfig = true;
        this._namedConfig = namedConfig;
        this._url = url;
        this.readConfig(this._namedConfig, url);
    }

    public String getApplicationName() {
        return this._applicationName;
    }

    public Object getId() {
        return this;
    }

    protected void reset() {
        this._storedResults.clear();
        this._storeParsedElements.clear();
        this._callbackMap.clear();
        this._resourceReadList.clear();
        this.init();
        this.readConfig(this._namedConfig, this._url);
    }

    protected void init() {
        this.generateApplicationName();
        this.registerCallbackListeners();
    }

    void registerCallbackListeners() {
        this._callbackMap = ConfigHelper.registerCallbackListeners(CALLBACK_FILE);
    }

    private static MetadataRegistry getRCUtils() {
        if (rcutils == null) {
            rcutils = MetadataRegistry.newInstance();
        }
        return rcutils;
    }

    protected void readConfig(String namedConfig, URL url) {
        _logger.fine(CLASSNAME, resBundle.getString("READING_NAMED_ADFCFG"), url.getPath());
        try {
            Document doc = ADFConfigImpl.getRCUtils().getDomDocument(url);
            this.readConfig(namedConfig, doc, url);
        }
        catch (IOException e) {
            _logger.severe(CLASSNAME, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (XMLParseException pe) {
            _logger.severe(CLASSNAME, (Throwable)pe);
            _logger.severe(CLASSNAME, "readConfig", resBundle.getString("XML_PARSE_EX"), new Object[]{pe.getColumnNumber(), pe.getLineNumber()});
            throw new RuntimeException(pe);
        }
        catch (Exception e) {
            _logger.severe(CLASSNAME, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void readConfig(String namedConfig, Document doc, URL url) {
        _logger.fine(CLASSNAME + resBundle.getString("READING_NAMED_ADFCFG"), (Object)url.getPath());
        try {
            Element root = doc.getDocumentElement();
            if (root != null) {
                NodeList nl = root.getChildNodes();
                Object ctx = null;
                int i = 0;
                while (nl != null && i < nl.getLength()) {
                    Node app = nl.item(i);
                    String ns = app.getNamespaceURI();
                    if (ns != null) {
                        ADFIntialParseResult apr = new ADFIntialParseResult(ctx, namedConfig, app, url.getPath());
                        Object val = this._storeParsedElements.get(ns);
                        if (val == null) {
                            ArrayList<ADFIntialParseResult> list = new ArrayList<ADFIntialParseResult>(2);
                            list.add(apr);
                            this._storeParsedElements.put(ns, list);
                        } else {
                            ((ArrayList)val).add(apr);
                            this._storeParsedElements.put(ns, val);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            _logger.severe(CLASSNAME, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    void readConfig(InputStream is, String resource) {
        this.readConfig(is, resource, false);
    }

    void readConfig(InputStream is, String resource, boolean reparse) {
        if (reparse) {
            this._storeParsedElements.clear();
        }
        this.parseConfigFirstPass(is, resource);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseConfigFirstPass(InputStream is, String resource) {
        try {
            try {
                block27: {
                    int i;
                    Object ctx;
                    NodeList nl;
                    block26: {
                        if (is == null) {
                            throw new IllegalArgumentException();
                        }
                        DOMParser dp = new DOMParser();
                        dp.setPreserveWhitespace(false);
                        dp.parse(is);
                        this.setResourceVisited(resource);
                        XMLElement root = (XMLElement)dp.getDocument().getDocumentElement();
                        if (root == null) return;
                        Set namespaceSet = this._callbackMap.keySet();
                        if (namespaceSet == null) return;
                        if (namespaceSet.isEmpty()) {
                            return;
                        }
                        nl = root.getChildNodes();
                        ctx = null;
                        try {
                            ctx = ADFContext.getCurrent().getEnvironment().getContext();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        i = 0;
                        if (!true) break block26;
                        if (nl == null) return;
                        if (i >= nl.getLength()) break block27;
                    }
                    do {
                        Node app;
                        String ns;
                        if ((ns = (app = nl.item(i)).getNamespaceURI()) != null) {
                            ADFIntialParseResult apr = new ADFIntialParseResult(ctx, resource, app, resource);
                            Object val = this._storeParsedElements.get(ns);
                            if (val == null) {
                                ArrayList<ADFIntialParseResult> list = new ArrayList<ADFIntialParseResult>(2);
                                list.add(apr);
                                this._storeParsedElements.put(ns, list);
                            } else {
                                ((ArrayList)val).add(apr);
                                this._storeParsedElements.put(ns, val);
                            }
                        }
                        ++i;
                        if (nl == null) return;
                    } while (i < nl.getLength());
                }
                return;
            }
            finally {
                try {
                    is.close();
                    return;
                }
                catch (Exception exception) {
                    String mesg = exception.getMessage();
                    if (mesg == null) {
                        mesg = "";
                    }
                    _logger.internal(this.getClass().getName() + "  " + mesg, (Throwable)exception);
                    throw new ADFShareException(resBundle.getString("CLOSE_CFG_STREAM"), exception);
                }
            }
        }
        catch (ADFShareException e) {
            throw e;
        }
        catch (XMLParseException pe) {
            _logger.internal(this.getClass().getName() + ":" + pe.getMessage() + "\n" + resBundle.getString("XML_PARSE_EX"), new Object[]{pe.getColumnNumber(), pe.getColumnNumber()});
            throw new ADFShareException(resBundle.getString("XML_SYNTAX_ERROR"), pe);
        }
        catch (Exception e) {
            String mesg = e.getMessage();
            if (mesg == null) {
                mesg = "";
            }
            _logger.internal(this.getClass().getName() + "  " + mesg, (Throwable)e);
            throw new ADFShareException(resBundle.getString("XML_PARSING_ERROR"), e);
        }
    }

    private Map getResultFromComponent(Node el, Map storedResult, Object ctx, String resource, String filePath, boolean forceReparse) {
        String cbClassName = (String)this._callbackMap.get(el.getNamespaceURI());
        Map map = null;
        try {
            Class cls = ClassUtils.forName((String)cbClassName);
            Object handler = cls.newInstance();
            Method method = cls.getMethod("parseADFConfiguration", Element.class, Map.class, ADFConfigParsingContext.class);
            ADFConfigParsingContext adfParsingCtx = new ADFConfigParsingContext(this._applicationName, ctx, resource, filePath, forceReparse);
            map = (Map)method.invoke(handler, el, storedResult, adfParsingCtx);
        }
        catch (ADFShareException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            _logger.internal(this.getClass().getName() + "  " + e.getMessage(), e.getCause());
            throw new ADFShareException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null && (t = e.getCause()) instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException(t);
        }
        catch (Exception e) {
            _logger.internal(this.getClass().getName() + "  " + e.getMessage(), e.getCause());
            throw new ADFShareException(e);
        }
        return map;
    }

    public Map getConfigObject(String namespace) {
        return this.getConfigObject(namespace, false);
    }

    public Map getConfigObject(String namespace, boolean forceReparse) {
        List res;
        if ((forceReparse || this._storedResults.get(namespace) == null) && (res = (List)this._storeParsedElements.get(namespace)) != null) {
            int i = 0;
            while (i < res.size()) {
                ADFIntialParseResult ps = (ADFIntialParseResult)res.get(i);
                Map mapResult = this.getResultFromComponent(ps.app, (Map)this._storedResults.get(namespace), ps.ctx, ps.resource, ps.filePath, forceReparse);
                if (mapResult != null) {
                    this._storedResults.put(namespace, mapResult);
                }
                ++i;
            }
        }
        return (Map)this._storedResults.get(namespace);
    }

    boolean isResourceVisited(String resourceName) {
        return this._resourceReadList.contains(resourceName);
    }

    void setResourceVisited(String resourceName) {
        if (!this._resourceReadList.contains(resourceName)) {
            this._resourceReadList.add(resourceName);
        }
    }

    public Object getMDSInstance() {
        Object mdsInstance;
        HashMap<String, Object> mMDSContext = this.getConfigObject("http://xmlns.oracle.com/adf/mds/config");
        if (mMDSContext == null && !this._isNamedConfig && (mdsInstance = FallbackConfigImpl.getDefaultMDSInstance()) != null) {
            mMDSContext = new HashMap<String, Object>(2);
            mMDSContext.put("MDSInstance", mdsInstance);
            this._storedResults.put("http://xmlns.oracle.com/adf/mds/config", mMDSContext);
        }
        if (mMDSContext == null) {
            return null;
        }
        return mMDSContext.get("MDSInstance");
    }

    public Context getConnectionsContext() throws NamingException {
        Hashtable mContextEnv = (Hashtable)this.getConfigObject("http://xmlns.oracle.com/adf/jndi/config");
        if (mContextEnv == null && !this._isNamedConfig) {
            return FallbackConfigImpl.getDefaultConnectionsContext();
        }
        if (mContextEnv == null) {
            return null;
        }
        if (this._isNamedConfig) {
            mContextEnv.put("named.adf.context", this._namedConfig);
        }
        return new AdfInitialContext(mContextEnv);
    }

    private synchronized void generateApplicationName() {
        this._applicationName = "ADFApplication" + ++_appCounter;
    }

    public Context getSecurityContext() throws NamingException {
        Hashtable mSecurityContextEnv = (Hashtable)this.getConfigObject("http://xmlns.oracle.com/adf/security/config");
        if (mSecurityContextEnv == null && !this._isNamedConfig) {
            return FallbackConfigImpl.getDefaultSecurityContext();
        }
        if (mSecurityContextEnv == null) {
            return null;
        }
        if (this._namedConfig != null) {
            mSecurityContextEnv.put("named.adf.context", this._namedConfig);
        }
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        return factory.getInitialContext(mSecurityContextEnv);
    }

    class ADFIntialParseResult {
        Object ctx;
        String resource;
        Node app;
        String filePath;

        private void $init$() {
            this.ctx = null;
            this.resource = "";
            this.app = null;
            this.filePath = null;
        }

        ADFIntialParseResult(Object context, String resourceRead, Node resNode, String path) {
            this.$init$();
            this.ctx = context;
            this.resource = resourceRead;
            this.app = resNode;
            this.filePath = path;
        }
    }
}

