/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import oracle.adf.share.ADFSettings;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.config.ADFSettingsImpl;
import oracle.adf.share.logging.ADFLogger;

public class ConfigContainerFactory {
    private static Map adfConfigMap = new WeakHashMap(4);
    private static Map adfSettingsMap = new WeakHashMap(4);
    private static final String CLASSNAME = "oracle.adf.share.ConfigContainerFactory";
    private static final String resourceBundle = "oracle.adf.share.config.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.config.resources.Messages");
    public static final String ADF_CONFIG = "oracle.adf.share.ADFConfig";
    public static final String ADF_SETTIINGS = "oracle.adf.share.ADFSettings";
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.ConfigContainerFactory", (String)"oracle.adf.share.config.resources.Messages");

    public static ADFSettings findOrCreateConfig(String configType) {
        if (configType.equals(ADF_CONFIG)) {
            return ADFConfigFactory.findOrCreateADFConfig(false);
        }
        if (configType.equals(ADF_SETTIINGS)) {
            return ConfigContainerFactory.findOrCreateADFSettings();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ADFSettings findOrCreateADFSettings() {
        String method = "findOrCreateADFSettings";
        String resourceName = "META-INF/adf-settings.xml";
        ADFSettings app = null;
        Map map = adfSettingsMap;
        synchronized (map) {
            ClassLoader cl = ClassUtils.getClassLoader();
            app = (ADFSettings)adfSettingsMap.get(cl);
            if (app == null) {
                app = new ADFSettingsImpl();
                adfSettingsMap.put(cl, app);
            }
            ADFSettings aDFSettings = app;
            return aDFSettings;
        }
    }
}

