/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.adf.share.ADFShareException;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.common.rc.util.MetadataRegistry;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.logging.ADFLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigHelper {
    private static final String resourceBundle = "oracle.adf.share.config.resources.Messages";
    private static final ResourceBundle resBundle = ResourceBundle.getBundle("oracle.adf.share.config.resources.Messages");
    private static final String CLASSNAME = "oracle.adf.share.config.ConfigHelper";
    private static final ADFLogger mLogger = ADFLogger.createADFLogger((String)"oracle.adf.share.config.ConfigHelper");
    private static MetadataRegistry rcutils = null;

    static Map<String, String> registerCallbackListeners(String callbackFile) {
        HashMap<String, String> callbackMap;
        block14: {
            callbackMap = new HashMap<String, String>();
            try {
                ClassLoader cl = ClassUtils.getClassLoader();
                Enumeration<URL> listeners = cl.getResources(callbackFile);
                if (listeners == null) break block14;
                mLogger.finest(CLASSNAME, (Object)("Registering callback listeners for " + callbackFile));
                while (listeners.hasMoreElements()) {
                    URL url = listeners.nextElement();
                    InputStream urlIn = null;
                    try {
                        try {
                            urlIn = url.openStream();
                            Properties mapping = new Properties();
                            mapping.load(urlIn);
                            callbackMap.putAll(mapping);
                            mLogger.finest(CLASSNAME, "registerCallbackListeners", url.getPath() + "\n Mapping " + mapping);
                        }
                        catch (IOException ioe) {
                            if (urlIn == null) continue;
                            try {
                                urlIn.close();
                            }
                            catch (Exception exception) {
                                exception.toString();
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (urlIn != null) {
                            try {
                                urlIn.close();
                            }
                            catch (Exception exception) {
                                exception.toString();
                            }
                        }
                        throw throwable;
                    }
                    if (urlIn == null) continue;
                    try {
                        urlIn.close();
                    }
                    catch (Exception ignore) {
                        ignore.toString();
                    }
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return callbackMap;
    }

    static MetadataRegistry getRCUtils() {
        if (rcutils == null) {
            rcutils = MetadataRegistry.newInstance();
        }
        return rcutils;
    }

    static Map getResultFromComponent(String callbackMethodName, Map callbackMap, Node el, Map storedResult, Object ctx, String resource, String filePath) {
        String cbClassName = (String)callbackMap.get(el.getNamespaceURI());
        Map map = null;
        try {
            Class cls = ClassUtils.forName((String)cbClassName);
            Object handler = cls.newInstance();
            Method method = cls.getMethod(callbackMethodName, Element.class, Map.class, ADFConfigParsingContext.class);
            ADFConfigParsingContext adfParsingCtx = new ADFConfigParsingContext("", ctx, resource, filePath);
            map = (Map)method.invoke(handler, el, storedResult, adfParsingCtx);
        }
        catch (ADFShareException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            mLogger.severe(CLASSNAME, (Throwable)e);
            throw new ADFShareException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null && (t = e.getCause()) instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException(resBundle.getString("CALLBACK_PARSING_ERROR"), t);
        }
        catch (Exception e) {
            mLogger.severe(CLASSNAME, (Throwable)e);
            throw new ADFShareException(resBundle.getString("CALLBACK_PARSING_ERROR"), e);
        }
        return map;
    }

    static void getParsedElements(URL url, Set namespaceSet, Map storeParsedElements) {
        try {
            MetadataRegistry rcUtils = ConfigHelper.getRCUtils();
            Document document = rcUtils.getDomDocument(url);
            if (document != null) {
                NodeList nl = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (nl != null && i < nl.getLength()) {
                    Node node = nl.item(i);
                    String ns = node.getNamespaceURI();
                    if (namespaceSet.contains(ns)) {
                        ADFIntialParseResult apr = new ADFIntialParseResult(null, "META-INF/adf-settings.xml", node, url.getPath());
                        Object val = storeParsedElements.get(ns);
                        if (val == null) {
                            ArrayList<ADFIntialParseResult> list = new ArrayList<ADFIntialParseResult>();
                            list.add(apr);
                            storeParsedElements.put(ns, list);
                        } else {
                            ((ArrayList)val).add(apr);
                            storeParsedElements.put(ns, val);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (ADFShareException e) {
            throw e;
        }
        catch (Exception e) {
            String mesg = e.getMessage();
            if (mesg == null) {
                mesg = "";
            }
            mLogger.severe(CLASSNAME, (Throwable)e);
            throw new ADFShareException(resBundle.getString("CALLBACK_PARSING_ERROR"), e);
        }
    }

    static class ADFIntialParseResult {
        Object ctx;
        String resource;
        Node app;
        String filePath;

        private void $init$() {
            this.ctx = null;
            this.resource = "";
            this.app = null;
            this.filePath = null;
        }

        ADFIntialParseResult(Object context, String resourceRead, Node resNode, String path) {
            this.$init$();
            this.ctx = context;
            this.resource = resourceRead;
            this.app = resNode;
            this.filePath = path;
        }
    }
}

