/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.adf.share.ADFShareException;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.config.ADFConfigImpl;
import oracle.adf.share.jndi.AdfInitialContext;
import oracle.adf.share.security.JAASInitialContextFactory;
import oracle.adf.share.security.SecurityEnv;

public class FallbackConfigImpl
extends ADFConfigImpl {
    private Object mdsInstanceFactory;
    private static String INITIAL_CONTEXT_IMPL = "oracle.adf.share.jndi.InitialContextFactoryImpl";
    private static String RESOURCE_BACKING_STORE = "oracle.adf.share.jndi.ResourceBackingStore";

    private void $init$() {
        this.mdsInstanceFactory = null;
    }

    FallbackConfigImpl() {
        this.$init$();
    }

    public Object getMDSInstance() {
        try {
            Map mdsMap = this.getConfigObject("http://xmlns.oracle.com/adf/mds/config");
            if (mdsMap != null) {
                this.mdsInstanceFactory = mdsMap.get("MDSInstance");
            }
            if (this.mdsInstanceFactory == null) {
                Class cls = ClassUtils.forName((String)"oracle.adf.share.config.ADFMDSConfig");
                Object obj = cls.newInstance();
                Method m = obj.getClass().getDeclaredMethod("getDefaultMDSInstance", String.class);
                this.mdsInstanceFactory = m.invoke(obj, this._applicationName);
            }
            Object object = this.mdsInstanceFactory;
            return object;
        }
        catch (ADFShareException ex) {
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable t = e;
            if (e.getCause() != null) {
                t = e.getCause();
            }
            if (t instanceof ADFShareException) {
                throw (ADFShareException)t;
            }
            throw new ADFShareException("getMDSInstance error", t);
        }
        catch (Exception ex) {
            throw new ADFShareException("getMDSInstance error", ex);
        }
    }

    static Object getDefaultMDSInstance() {
        return new FallbackConfigImpl().getMDSInstance();
    }

    public Context getConnectionsContext() throws NamingException {
        Map connMap = this.getConfigObject("http://xmlns.oracle.com/adf/jndi/config");
        if (connMap == null) {
            return (AdfInitialContext)FallbackConfigImpl.getDefaultConnectionsContext();
        }
        return new AdfInitialContext(new Hashtable(connMap));
    }

    static Context getDefaultConnectionsContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(3);
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_IMPL);
        env.put("java.naming.provider.url", "META-INF/connections.xml");
        env.put("oracle.adf.share.jndi.documentstore", RESOURCE_BACKING_STORE);
        env.put("_cache_application_scope_", "true");
        return new AdfInitialContext((Hashtable)env);
    }

    public Context getSecurityContext() throws NamingException {
        Map secMap = this.getConfigObject("http://xmlns.oracle.com/adf/security/config");
        if (secMap == null) {
            return FallbackConfigImpl.getDefaultSecurityContext();
        }
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        return factory.getInitialContext(new Hashtable(secMap));
    }

    static Context getDefaultSecurityContext() throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(4);
        env.put("java.naming.factory.initial", "oracle.adf.share.security.JAASInitialContextFactory");
        String auth = System.getProperty("oracle.adf.security.authorization.enforce");
        env.put("oracle.adf.security.authorization.enforce", auth == null || auth.length() == 0 ? SecurityEnv.AUTHORIZATION_ENFORCE_DEFAULT : auth);
        String jaznConfig = System.getProperty("oracle.security.jazn.config");
        if (jaznConfig != null && jaznConfig.length() > 0) {
            env.put("oracle.security.jazn.config", jaznConfig);
        }
        env.put("oracle.adf.security.credentialstore", SecurityEnv.CREDENTIAL_STORE_PROVIDER_DEFAULT);
        JAASInitialContextFactory factory = new JAASInitialContextFactory();
        return factory.getInitialContext((Hashtable)env);
    }
}

