/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.el;

import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import oracle.adf.share.ADFContext;
import oracle.adf.share.el.ADFExpressionEvaluator;
import oracle.jsp.el.OracleExpression;
import oracle.jsp.el.OracleExpressionEvaluator;

public class OracleExpressionEvaluatorImpl
implements ADFExpressionEvaluator {
    private OracleExpressionEvaluator mEvaluator;

    public Object evaluate(String expression) {
        return this.evaluate(expression, this.getVariableResolver());
    }

    public Object evaluate(String expression, VariableResolver variableResolver) {
        return this.evaluateInternal(expression, variableResolver);
    }

    public void setValue(String expression, Object value) {
        this.setValue(expression, value, this.getVariableResolver());
    }

    public void setValue(String expression, Object value, VariableResolver variableResolver) {
        throw new UnsupportedOperationException();
    }

    public VariableResolver getVariableResolver() {
        return ADFContext.getCurrent().getVariableResolver();
    }

    private Object evaluateInternal(String expression, VariableResolver variableResolver) {
        if (this.mEvaluator == null) {
            this.init();
        }
        try {
            OracleExpression expr = (OracleExpression)this.mEvaluator.parseExpression(expression, Object.class, null);
            Object object = expr.evaluate(variableResolver);
            return object;
        }
        catch (ELException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void init() {
        if (this.mEvaluator == null) {
            this.mEvaluator = new OracleExpressionEvaluator();
        }
    }
}

