/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.event.NamingListener;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.adf.share.jndi.ConnectionEventContext;
import oracle.adf.share.jndi.ContextImpl;
import oracle.adf.share.jndi.ContextSaveListener;
import oracle.adf.share.jndi.NameParserImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdfInitialContext
extends InitialContext
implements AdfJndiContext,
ConnectionEventContext {
    private AdfJndiContext mAdfCtx;

    public AdfInitialContext(Hashtable env) throws NamingException {
        super(env);
        this.$init$();
        if (this.defaultInitCtx instanceof AdfJndiContext) {
            this.mAdfCtx = (AdfJndiContext)this.defaultInitCtx;
        }
    }

    @Override
    public void close() throws NamingException {
        super.close();
        this.mAdfCtx = null;
    }

    @Override
    public void reload() throws NamingException {
        this.checkSupported();
        this.mAdfCtx.reload();
    }

    @Override
    public void saveAs(String url) throws NamingException {
        this.checkSupported();
        this.mAdfCtx.saveAs(url);
    }

    @Override
    public void save() throws NamingException {
        this.checkSupported();
        this.mAdfCtx.save();
    }

    @Override
    public Map<String, Reference> getReferenceMap() throws NamingException {
        this.checkSupported();
        return this.mAdfCtx.getReferenceMap();
    }

    public boolean isAdfJndiContext() {
        return this.mAdfCtx != null;
    }

    private void checkSupported() throws OperationNotSupportedException {
        if (this.mAdfCtx == null) {
            throw new OperationNotSupportedException("Context not an instance of AdfJndiContext");
        }
    }

    private void $init$() {
        this.mAdfCtx = null;
    }

    private boolean isContextImpl() {
        return this.mAdfCtx instanceof ContextImpl;
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        if (!this.isContextImpl()) {
            throw new OperationNotSupportedException("Context not an instance of ContextImpl");
        }
        ((ContextImpl)this.mAdfCtx).addNamingListener(target, scope, l);
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        this.addNamingListener(NameParserImpl.getInstance().parse(target), scope, l);
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        if (!this.isContextImpl()) {
            throw new OperationNotSupportedException("Context not an instance of ContextImpl");
        }
        ((ContextImpl)this.mAdfCtx).removeNamingListener(l);
    }

    @Override
    public void addContextSaveListener(ContextSaveListener l) throws NamingException {
        this.addNamingListener("", 0, (NamingListener)l);
    }

    @Override
    public void removeContextSaveListener(ContextSaveListener l) throws NamingException {
        this.removeNamingListener(l);
    }

    @Override
    public boolean targetMustExist() {
        return true;
    }
}

