/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Hashtable;
import java.util.Map;
import oracle.adf.share.config.ADFConfigCallback;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.logging.ADFLogger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AdfJndiConfig
implements ADFConfigCallback {
    public static final String namespaceURI = "http://xmlns.oracle.com/adf/jndi/config";
    private ADFLogger logger;

    private void $init$() {
        this.logger = null;
    }

    public AdfJndiConfig() {
        this.$init$();
    }

    private ADFLogger getLogger() {
        if (this.logger == null) {
            this.logger = ADFLogger.createADFLogger(this.getClass());
        }
        return this.logger;
    }

    public Map parseADFConfiguration(Element el, Map storedResult, ADFConfigParsingContext currentCtx) {
        if (storedResult != null) {
            return storedResult;
        }
        NodeList nl = el.getElementsByTagNameNS(namespaceURI, "ConnectionsJndiContext");
        if (nl.getLength() <= 0) {
            this.getLogger().warning("Jndi Context information not correct" + el);
            return null;
        }
        Hashtable<String, String> mContextEnv = new Hashtable<String, String>(4);
        Element elem = (Element)nl.item(0);
        String facClass = elem.getAttribute("initialContextFactoryClass");
        String backingStoreClass = elem.getAttribute("backingStoreClass");
        String backingStoreURL = elem.getAttribute("backingStoreURL");
        NodeList nl1 = elem.getElementsByTagNameNS(namespaceURI, "contextEnv");
        if (nl1.getLength() > 0) {
            Element elem1 = (Element)nl1.item(0);
            mContextEnv.put(elem1.getAttribute("name"), elem1.getAttribute("value"));
        }
        mContextEnv.put("java.naming.factory.initial", facClass);
        mContextEnv.put("oracle.adf.share.jndi.documentstore", backingStoreClass);
        mContextEnv.put("java.naming.provider.url", backingStoreURL);
        this.getLogger().finest("AdfJndiConfig Created the Jndi Config information ");
        return mContextEnv;
    }
}

