/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.event.NamingListener;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.adf.share.jndi.BindingsEnumerator;
import oracle.adf.share.jndi.ConnectionEventContext;
import oracle.adf.share.jndi.ConnectionReference;
import oracle.adf.share.jndi.ContextSaveListener;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.adf.share.jndi.EventContextHelper;
import oracle.adf.share.jndi.FileSystemBackingStore;
import oracle.adf.share.jndi.NameClassEnumerator;
import oracle.adf.share.jndi.NameParserImpl;
import oracle.adf.share.jndi.ProviderProperties;
import oracle.adf.share.jndi.ReferenceStoreHelper;
import oracle.adf.share.jndi.xml.v2.ObjectFactory;
import oracle.adf.share.jndi.xml.v2.ReferenceListType;
import oracle.adf.share.logging.ADFLogger;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextImpl
implements AdfJndiContext,
ProviderProperties,
ConnectionEventContext {
    private Hashtable mEnv;
    private transient DocumentBackingStore mStore;
    private transient JAXBContext mJaxbContext;
    private static transient Marshaller mMarshaller;
    private transient Unmarshaller mUnmarshaller;
    private transient Hashtable mBindings;
    private transient ObjectFactory objectFactory;
    private transient Object mRefStoreLock;
    private transient ReferenceStoreHelper mRefStore;
    private static final String JAR_CONNECTIONS_XML = "META-INF/jar-connections.xml";
    private ADFLogger mLogger;
    private EventContextHelper eventCtxHelper;
    public static final String APPLICATION_LEVEL_CACHE_KEY = "_cache_application_scope_";
    private transient Map referencesMap;
    private static final String resourceBundle = "oracle.adf.share.jndi.resources.Messages";
    private static final ResourceBundle resBundle;

    private void $init$() {
        this.mEnv = null;
        this.mStore = null;
        this.mJaxbContext = null;
        this.objectFactory = null;
        this.mRefStoreLock = new Object();
        this.mRefStore = new ReferenceStoreHelper();
        this.mLogger = null;
        this.eventCtxHelper = null;
        this.referencesMap = null;
    }

    ContextImpl(Hashtable env) throws NamingException {
        this.$init$();
        this.mEnv = env;
        this.init();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.findObject(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (this.exists(name)) {
            throw new NameAlreadyBoundException(name.toString());
        }
        this.bindObject(name, obj);
        Binding binding = new Binding(this.getMyComponents(name), obj.getClass().getName(), obj, true);
        this.eventCtxHelper.fireObjectAddedEvent(binding);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(NameParserImpl.getInstance().parse(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        String simpleName = this.getMyComponents(name);
        Object oldObj = null;
        Binding oldBinding = new Binding(simpleName, (Object)null);
        if (this.exists(name)) {
            try {
                oldObj = this.lookup(name);
            }
            catch (PartialResultException pre) {
                oldObj = pre.getResolvedObj();
            }
            oldBinding = new Binding(simpleName, oldObj.getClass().getName(), oldObj, true);
        }
        this.removeObject(name);
        this.bindObject(name, obj);
        Binding newBinding = new Binding(simpleName, obj.getClass().getName(), obj, true);
        this.eventCtxHelper.fireObjectChangedEvent(newBinding, oldBinding);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(NameParserImpl.getInstance().parse(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        Object oldObj = null;
        Binding binding = new Binding(this.getMyComponents(name), (Object)null);
        if (this.exists(name)) {
            try {
                oldObj = this.lookup(name);
            }
            catch (PartialResultException pre) {
                oldObj = pre.getResolvedObj();
            }
            binding = new Binding(this.getMyComponents(name), oldObj.getClass().getName(), oldObj, true);
        }
        this.removeObject(name);
        this.eventCtxHelper.fireObjectRemovedEvent(binding);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(NameParserImpl.getInstance().parse(oldName), NameParserImpl.getInstance().parse(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new OperationNotSupportedException();
        }
        return new NameClassEnumerator(this);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(NameParserImpl.getInstance().parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new OperationNotSupportedException();
        }
        return new BindingsEnumerator(this);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return NameParserImpl.getInstance();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(NameParserImpl.getInstance().parse(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return null;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(NameParserImpl.getInstance().parse(name), NameParserImpl.getInstance().parse(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.mEnv.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.mEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.mEnv.clone();
    }

    @Override
    public void close() throws NamingException {
        this.saveDocument(this.getDocumentUrl());
        this.eventCtxHelper.clearAllNamingListeners();
        this.eventCtxHelper = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    private JAXBContext getJaxbContext() throws NamingException {
        block3: {
            if (this.mJaxbContext != null) {
                return this.mJaxbContext;
            }
            try {
                this.mJaxbContext = JAXBContext.newInstance((String)"oracle.adf.share.jndi.xml.v2");
            }
            catch (JAXBException e) {
                String msg = e.getMessage();
                if (msg == null || !msg.contains("jaxb.properties")) break block3;
                NamingException ne = new NamingException(resBundle.getString("SUN_JAXB_ERROR"));
                ne.setRootCause(e);
                throw ne;
            }
        }
        return this.mJaxbContext;
    }

    private void init() throws NamingException {
        Map map;
        if (this.cacheEnabled()) {
            this.mBindings = new Hashtable(12);
        }
        if (this.mEnv.get(APPLICATION_LEVEL_CACHE_KEY) != null && (map = ADFContext.getCurrent().getApplicationScope()).containsKey(APPLICATION_LEVEL_CACHE_KEY)) {
            this.referencesMap = (Map)map.get(APPLICATION_LEVEL_CACHE_KEY);
            this.mRefStore.init(null, this, this.mEnv);
            this.eventCtxHelper = new EventContextHelper(this);
            return;
        }
        try {
            this.initDocStoreAndEventContext();
            this.getJaxbContext();
            this.load();
        }
        catch (Exception ex) {
            this.throwNamingException(ex);
        }
    }

    private void initDocStoreAndEventContext() throws NamingException {
        String url = this.getDocumentUrl();
        this.mStore = this.createDocumentBackingStore();
        try {
            this.mStore.initialize(this.mEnv, url);
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        this.eventCtxHelper = new EventContextHelper(this);
    }

    protected DocumentBackingStore createDocumentBackingStore() throws NamingException {
        String storeClassName = (String)this.mEnv.get("oracle.adf.share.jndi.documentstore");
        if (storeClassName != null && storeClassName.length() > 0) {
            try {
                Class cls = ClassUtils.forName((String)storeClassName);
                if (!DocumentBackingStore.class.isAssignableFrom(cls)) {
                    throw new NamingException(MessageFormat.format(resBundle.getString("NOT_ASSIGNABLE_DOC"), storeClassName, DocumentBackingStore.class.getName()));
                }
                DocumentBackingStore documentBackingStore = (DocumentBackingStore)cls.newInstance();
                return documentBackingStore;
            }
            catch (InstantiationException ex) {
                this.throwNamingException(ex);
            }
            catch (IllegalAccessException ex) {
                this.throwNamingException(ex);
            }
            catch (ClassNotFoundException ex) {
                this.throwNamingException(ex);
            }
        }
        return new FileSystemBackingStore();
    }

    public ADFLogger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = ADFLogger.createADFLogger(this.getClass());
        }
        return this.mLogger;
    }

    @Override
    public Map<String, Reference> getReferenceMap() throws NamingException {
        if (this.referencesMap != null) {
            return this.referencesMap;
        }
        this.referencesMap = this.mRefStore.getReferencesMap();
        return this.referencesMap;
    }

    private void throwNamingException(Exception ex) throws NamingException {
        NamingException nex;
        if (ex instanceof NamingException) {
            nex = (NamingException)ex;
        } else {
            nex = new NamingException();
            nex.setRootCause(ex);
        }
        throw nex;
    }

    private String getDocumentUrl() throws NamingException {
        String url = (String)this.mEnv.get("java.naming.provider.url");
        if (url == null) {
            throw new NamingException(resBundle.getString("MISSING_URL"));
        }
        this.getLogger().finest(resBundle.getString("PROVIDER_URL"), (Object)url);
        return url;
    }

    private String getMyComponents(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(MessageFormat.format(resBundle.getString("EXTRA_NAME_COMPONENTS"), name.toString()));
            }
            return name.get(0);
        }
        return name.toString();
    }

    private Marshaller getMarshaller() throws NamingException {
        if (mMarshaller == null) {
            try {
                mMarshaller = this.getJaxbContext().createMarshaller();
                mMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (JAXBException ex) {
                this.throwNamingException((Exception)((Object)ex));
            }
        }
        return mMarshaller;
    }

    private Unmarshaller getUnmarshaller() throws NamingException {
        if (this.mUnmarshaller == null) {
            try {
                this.mUnmarshaller = this.getJaxbContext().createUnmarshaller();
            }
            catch (JAXBException ex) {
                this.throwNamingException((Exception)((Object)ex));
            }
        }
        return this.mUnmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object findObject(Name name) throws NamingException {
        String id = this.getMyComponents(name);
        Object bound = null;
        if (this.cacheEnabled() && (bound = (Object)this.mBindings.get(id)) != null) {
            return bound;
        }
        Reference ref = null;
        if (this.referencesMap != null) {
            Object refObj = this.referencesMap.get(id);
            if (refObj instanceof Throwable) {
                NamingException ne = new NamingException();
                ne.setRootCause((Throwable)refObj);
                throw ne;
            }
            ref = (Reference)refObj;
        }
        Object object = this.mRefStoreLock;
        synchronized (object) {
            try {
                bound = this.mRefStore.getObjectForReference(id, ref, true);
            }
            catch (Exception e) {
                this.throwNamingException(e);
            }
        }
        if (bound == null) {
            NameNotFoundException nnfe = new NameNotFoundException();
            nnfe.setRemainingName(name);
            throw nnfe;
        }
        if (bound instanceof ConnectionReference && ((ConnectionReference)bound).isPartial()) {
            PartialResultException pre = new PartialResultException(resBundle.getString("INCOMPLETE_RESULTS"));
            pre.setResolvedObj(bound);
            throw pre;
        }
        if (this.cacheEnabled()) {
            this.mBindings.put(id, bound);
        }
        return bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindObject(Name name, Object obj) throws NamingException {
        if (this.mStore == null || this.mStore.isReadOnly()) {
            throw new NamingException(resBundle.getString("READ_ONLY_STORE"));
        }
        Reference reference = this.getObjectReference(obj);
        String id = this.getMyComponents(name);
        this.mRefStore.addReference(id, reference);
        Map map = this.referencesMap;
        synchronized (map) {
            this.referencesMap.put(id, reference);
        }
    }

    private Reference getObjectReference(Object obj) throws OperationNotSupportedException, NamingException {
        Reference reference = null;
        if (obj instanceof Reference) {
            reference = (Reference)obj;
        } else if (obj instanceof Referenceable) {
            reference = ((Referenceable)obj).getReference();
        } else {
            throw new OperationNotSupportedException(resBundle.getString("INVALID_OBJECT_TYPE"));
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObject(Name name) throws NamingException {
        if (this.mStore == null || this.mStore.isReadOnly()) {
            throw new NamingException("READ_ONLY_STORE");
        }
        String id = this.getMyComponents(name);
        if (this.cacheEnabled()) {
            this.mBindings.remove(id);
        }
        Object object = this.mRefStoreLock;
        synchronized (object) {
            this.mRefStore.removeReference(id);
        }
        Map map = this.referencesMap;
        synchronized (map) {
            this.referencesMap.remove(id);
        }
    }

    private boolean exists(Name name) throws NamingException {
        Object bound;
        String id = this.getMyComponents(name);
        if (this.cacheEnabled() && (bound = this.mBindings.get(id)) != null) {
            return true;
        }
        if (this.referencesMap != null) {
            return this.referencesMap.containsKey(id);
        }
        return this.mRefStore.exists(id);
    }

    private void initReferences(String url) throws Exception {
        Document doc = this.mStore.readDocument(url);
        Element element = doc.getDocumentElement();
        ReferenceListType references = this.unmarshallElement(element);
        this.mRefStore.init(references, this, this.mEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws NamingException {
        block7: {
            try {
                Map applicationScope;
                if (this.mStore.documentExists(this.getDocumentUrl())) {
                    this.initReferences(this.getDocumentUrl());
                } else {
                    this.mRefStore.init(null, this, this.mEnv);
                }
                this.readJarDocuments();
                this.referencesMap = this.mRefStore.getReferencesMapEx(true);
                if (this.mEnv.get(APPLICATION_LEVEL_CACHE_KEY) == null) break block7;
                Map map = applicationScope = ADFContext.getCurrent().getApplicationScope();
                synchronized (map) {
                    applicationScope.put(APPLICATION_LEVEL_CACHE_KEY, this.referencesMap);
                }
            }
            catch (Exception ex) {
                this.throwNamingException(ex);
            }
        }
    }

    private ReferenceListType unmarshallElement(Element element) throws Exception {
        JAXBElement jaxb = (JAXBElement)this.getUnmarshaller().unmarshal((Node)element);
        return (ReferenceListType)jaxb.getValue();
    }

    private void readJarDocuments() throws Exception {
        DOMParser parser = null;
        BufferedInputStream in = null;
        try {
            ArrayList<ReferenceListType> refList = new ArrayList<ReferenceListType>(10);
            parser = new DOMParser();
            ArrayList urlList = new ArrayList();
            Enumeration<URL> urls = ClassUtils.getClassLoader().getResources(JAR_CONNECTIONS_XML);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                in = new BufferedInputStream(url.openStream());
                if (in == null) {
                    throw new Exception(MessageFormat.format(resBundle.getString("RESOURCE_NOT_FOUND"), url));
                }
                parser.parse((InputStream)in);
                XMLDocument doc = parser.getDocument();
                Element element = doc.getDocumentElement();
                ReferenceListType references = this.unmarshallElement(element);
                this.getLogger().finest(resBundle.getString("READING_JAR_CONN"), new Object[]{url.getPath()});
                refList.add(references);
            }
            this.mRefStore.addJarReferences(refList);
        }
        finally {
            if (in != null) {
                in.close();
            }
            in = null;
        }
    }

    private ObjectFactory getObjectFactory() {
        if (this.objectFactory == null) {
            this.objectFactory = new ObjectFactory();
        }
        return this.objectFactory;
    }

    private void saveDocument(String url) throws NamingException {
        ReferenceListType saveableReferences;
        if (!this.mStore.isReadOnly() && (saveableReferences = this.mRefStore.getSaveableReferences()) != null) {
            try {
                try {
                    this.mRefStore.saveCredentials();
                    Document doc = this.mStore.createDocument(url);
                    JAXBElement<ReferenceListType> ele = this.getObjectFactory().createReferences(saveableReferences);
                    this.getMarshaller().marshal(ele, (Node)doc);
                    this.mStore.writeDocument(doc, url);
                    this.mStore.closeDocument(url);
                    this.eventCtxHelper.fireContextSavedEvent();
                }
                catch (Exception ex) {
                    this.throwNamingException(ex);
                }
            }
            finally {
                Object var2_2 = null;
            }
        }
    }

    @Override
    public void reload() throws NamingException {
        this.load();
    }

    @Override
    public void save() throws NamingException {
        this.saveDocument(this.getDocumentUrl());
    }

    @Override
    public void saveAs(String url) throws NamingException {
        this.saveDocument(url);
    }

    ReferenceStoreHelper getReferenceStoreHelper() {
        return this.mRefStore;
    }

    private boolean cacheEnabled() {
        return false;
    }

    @Override
    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        this.eventCtxHelper.addNamingListener(target, scope, l);
    }

    @Override
    public void addNamingListener(String target, int scope, NamingListener l) throws NamingException {
        this.addNamingListener(NameParserImpl.getInstance().parse(target), scope, l);
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        this.eventCtxHelper.removeNamingListener(l);
    }

    @Override
    public void addContextSaveListener(ContextSaveListener l) throws NamingException {
        this.addNamingListener("", 0, (NamingListener)l);
    }

    @Override
    public void removeContextSaveListener(ContextSaveListener l) throws NamingException {
        this.removeNamingListener(l);
    }

    @Override
    public boolean targetMustExist() {
        return true;
    }

    static {
        resBundle = ResourceBundle.getBundle(resourceBundle);
    }
}

