/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import oracle.adf.share.jndi.ContextImpl;
import oracle.adf.share.jndi.ContextSaveEvent;
import oracle.adf.share.jndi.ContextSaveListener;
import oracle.adf.share.jndi.ReferenceStoreHelper;

class EventContextHelper {
    private Map<String, List<NamingListener>> listeners;
    private final Object lock;
    ContextImpl context;

    private void $init$() {
        this.listeners = new HashMap<String, List<NamingListener>>();
        this.lock = new Object();
        this.context = null;
    }

    private EventContextHelper() {
        this.$init$();
    }

    public EventContextHelper(ContextImpl ctx) {
        this.$init$();
        this.context = ctx;
    }

    public void addNamingListener(Name target, int scope, NamingListener l) throws NamingException {
        if (target == null) {
            throw new NamingException("Null target passed.");
        }
        String name = this.getMyComponents(target);
        if (l instanceof ObjectChangeListener) {
            this.addListenerToList(name, l);
        } else if (l instanceof NamespaceChangeListener) {
            ReferenceStoreHelper refStoreHelper = this.context.getReferenceStoreHelper();
            if (name != null && name.length() != 0 && !refStoreHelper.exists(name)) {
                throw new NamingException("Listeners for non-existent targets are not supported");
            }
            this.addListenerToList(name, l);
        } else if (l instanceof ContextSaveListener) {
            this.addListenerToList(name, l);
        } else {
            throw new NamingException("Unsupported listener type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListenerToList(String name, NamingListener l) throws NamingException {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners.containsKey(name)) {
                List<NamingListener> list = this.listeners.get(name);
                if (list.contains(l)) {
                    throw new NamingException("Listener already added.");
                }
                list.add(l);
            } else {
                ArrayList<NamingListener> nList = new ArrayList<NamingListener>();
                nList.add(l);
                this.listeners.put(name, nList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamingListener(NamingListener l) throws NamingException {
        Object object = this.lock;
        synchronized (object) {
            if (l != null) {
                for (List<NamingListener> list : this.listeners.values()) {
                    if (!list.contains(l)) continue;
                    list.remove(l);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllNamingListeners() {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    private String getMyComponents(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(name.toString() + " has more components than namespace can handle");
            }
            return name.get(0);
        }
        return name.toString();
    }

    final void fireObjectAddedEvent(Binding binding) throws NamingException {
        NamingEvent event = new NamingEvent(this.context, 0, binding, null, null);
        this.dispatchToListeners(binding.getName(), event);
    }

    final void fireObjectRemovedEvent(Binding binding) throws NamingException {
        NamingEvent event = new NamingEvent(this.context, 1, null, binding, null);
        this.dispatchToListeners(binding.getName(), event);
    }

    final void fireObjectRenamedEvent(Binding newBinding, Binding oldBinding) throws NamingException {
        NamingEvent event = new NamingEvent(this.context, 2, newBinding, oldBinding, null);
        this.dispatchToListeners(oldBinding.getName(), event);
    }

    final void fireObjectChangedEvent(Binding newBinding, Binding oldBinding) throws NamingException {
        NamingEvent event = new NamingEvent(this.context, 3, newBinding, oldBinding, null);
        this.dispatchToListeners(oldBinding.getName(), event);
    }

    final void fireContextSavedEvent() throws NamingException {
        ContextSaveEvent event = new ContextSaveEvent(this.context);
        this.dispatchToListeners("", event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchToListeners(String target, EventObject event) throws NamingException {
        ArrayList<NamingListener> itrList = null;
        Object object = this.lock;
        synchronized (object) {
            List<NamingListener> list = this.listeners.get(target);
            if (list != null) {
                itrList = new ArrayList<NamingListener>(list);
            }
        }
        if (itrList != null) {
            for (NamingListener nl : itrList) {
                this.dispatchEvent(nl, event);
            }
        }
        if ("".equals(target)) {
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            List<NamingListener> list = this.listeners.get("");
            if (list == null) {
                return;
            }
            itrList = new ArrayList<NamingListener>(list);
        }
        for (NamingListener nl : itrList) {
            this.dispatchEvent(nl, event);
        }
    }

    private void dispatchEvent(NamingListener nl, EventObject event) throws NamingException {
        block9: {
            block8: {
                if (!(event instanceof NamingEvent)) break block8;
                NamingEvent namingEvent = (NamingEvent)event;
                int type = namingEvent.getType();
                switch (type) {
                    case 3: {
                        if (nl instanceof ObjectChangeListener) {
                            namingEvent.dispatch(nl);
                        }
                        break block9;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        if (nl instanceof NamespaceChangeListener) {
                            namingEvent.dispatch(nl);
                        }
                        break block9;
                    }
                    default: {
                        throw new NamingException("Not a supported event type");
                    }
                }
            }
            if (event instanceof ContextSaveEvent) {
                ContextSaveEvent saveEvent = (ContextSaveEvent)event;
                if (nl instanceof ContextSaveListener) {
                    ContextSaveListener ctxSaveListener = (ContextSaveListener)nl;
                    ctxSaveListener.contextSaved(saveEvent);
                }
            }
        }
    }
}

