/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.File;
import java.net.URI;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.adf.share.common.rc.util.MetadataRegistry;
import oracle.adf.share.jndi.DocumentBackingStore;
import org.w3c.dom.Document;

public class FileSystemBackingStore
extends DocumentBackingStore {
    private boolean readOnlyStore;

    private void $init$() {
        this.readOnlyStore = false;
    }

    public void initialize(Hashtable contextEnv, String url) throws Exception {
        super.initialize(contextEnv, url);
        Object isReadOnly = contextEnv.get("oracle.adf.share.jndi.FileSystemBackingStore.readonly");
        if (isReadOnly != null && ((String)isReadOnly).equalsIgnoreCase("true")) {
            this.readOnlyStore = true;
        }
    }

    public Document readDocument(String url) throws Exception {
        File file = this.getFile(url);
        return MetadataRegistry.newInstance().getDomDocument(file.toURL());
    }

    public void writeDocument(Document doc, String url) throws Exception {
        File file = this.getFile(url);
        MetadataRegistry.newInstance().saveDocumentTo(doc, file.toURL());
    }

    public boolean isReadOnly() {
        return this.readOnlyStore;
    }

    public Document createDocument(String url) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder().newDocument();
    }

    public boolean documentExists(String url) throws Exception {
        return this.getFile(url).exists();
    }

    private File getFile(String url) throws Exception {
        if (url.startsWith("file:")) {
            return new File(new URI(url));
        }
        return new File(url);
    }

    public FileSystemBackingStore() {
        this.$init$();
    }
}

