/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import oracle.adf.share.jndi.ConnectionException;
import oracle.adf.share.jndi.ContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NameClassEnumerator
implements NamingEnumeration {
    protected Iterator mRefIterator;
    protected ContextImpl mCtx;

    NameClassEnumerator(ContextImpl ctx) {
        this.mCtx = ctx;
    }

    @Override
    public boolean hasMoreElements() {
        try {
            boolean bl = this.hasMore();
            return bl;
        }
        catch (NamingException ex) {
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean hasMore() throws NamingException {
        this.ensureIterator();
        return this.mRefIterator.hasNext();
    }

    public Object next() throws NamingException {
        Map.Entry<String, Reference> refEntry = this.nextReference();
        if (refEntry != null) {
            Reference ref = refEntry.getValue();
            if (ref != null && ref instanceof Reference) {
                Reference refer = ref;
                return new NameClassPair(refEntry.getKey(), refer.getClassName());
            }
            if (ref instanceof ConnectionException) {
                ConnectionException cex = (ConnectionException)((Object)ref);
                return new NameClassPair(refEntry.getKey(), cex.getClassName());
            }
        }
        return null;
    }

    @Override
    public Object nextElement() {
        try {
            Object object = this.next();
            return object;
        }
        catch (NamingException e) {
            throw new NoSuchElementException(e.toString());
        }
    }

    @Override
    public void close() {
        this.mRefIterator = null;
    }

    void ensureIterator() throws NamingException {
        if (this.mRefIterator == null) {
            HashMap<String, Reference> references = new HashMap<String, Reference>(this.mCtx.getReferenceMap());
            this.mRefIterator = references.entrySet().iterator();
        }
    }

    Map.Entry<String, Reference> nextReference() throws NamingException {
        this.ensureIterator();
        return (Map.Entry)this.mRefIterator.next();
    }

    ContextImpl getOwningContext() {
        return this.mCtx;
    }
}

