/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class ResourceBackingStore
extends DocumentBackingStore {
    private String mResourcePath;

    public ResourceBackingStore() {
    }

    public void initialize(Hashtable contextEnv, String url) throws Exception {
        super.initialize(contextEnv, url);
        Object o = contextEnv.get("java.naming.provider.url");
        if (o instanceof String) {
            this.mResourcePath = (String)o;
        }
    }

    public ResourceBackingStore(String resourcePath) {
        this.mResourcePath = resourcePath;
    }

    public Document readDocument(String url) throws Exception {
        InputStream is = this.getDocumentStream();
        if (is == null) {
            throw new Exception("Unable to find resource " + this.mResourcePath);
        }
        try {
            DOMParser parser = new DOMParser();
            parser.parse(is);
            XMLDocument xMLDocument = parser.getDocument();
            return xMLDocument;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            is.close();
        }
    }

    public boolean documentExists(String url) throws Exception {
        ClassLoader cl = ClassUtils.getClassLoader();
        URL urlPath = cl.getResource(this.mResourcePath);
        if (urlPath == null && this.mResourcePath.startsWith("/")) {
            urlPath = cl.getResource(this.mResourcePath.substring(1));
        }
        return urlPath != null;
    }

    public Document createDocument(String url) throws Exception {
        throw new UnsupportedOperationException("ReadOnly");
    }

    public void writeDocument(Document doc, String url) throws Exception {
        throw new UnsupportedOperationException("ReadOnly");
    }

    public boolean isReadOnly() {
        return true;
    }

    private InputStream getDocumentStream() {
        ClassLoader cl = ClassUtils.getClassLoader();
        InputStream is = cl.getResourceAsStream(this.mResourcePath);
        if (is == null && this.mResourcePath.startsWith("/")) {
            is = cl.getResourceAsStream(this.mResourcePath.substring(1));
        }
        return is;
    }
}

