/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.util.Hashtable;
import java.util.Map;
import oracle.adf.share.config.ADFConfigCallback;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.security.SecurityEnv;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ADFSecurityConfig
implements ADFConfigCallback {
    public static final String namespaceURI = "http://xmlns.oracle.com/adf/security/config";
    public static final String JAAS_SECURITY_CONTEXT = "JaasSecurityContext";
    public static final String CREDENTIALSTORE_CONTEXT = "CredentialStoreContext";
    public static final String SECURITY_METADATA = "SecurityMetadata";
    public static final String MULTI_LEVEL_AUTH = "MultiLevelAuth";

    public Map parseADFConfiguration(Element el, Map storedResult, ADFConfigParsingContext currentCtx) {
        if (storedResult != null) {
            return storedResult;
        }
        Hashtable securityContextEnv = new Hashtable(12);
        Element elem = null;
        NodeList nl = el.getElementsByTagName(JAAS_SECURITY_CONTEXT);
        if (nl.getLength() > 0) {
            elem = (Element)nl.item(0);
            int i = 0;
            while (i < SecurityEnv.SECURITY_CONFIG.length) {
                this.setConfigAttribute(securityContextEnv, elem, SecurityEnv.SECURITY_CONFIG[i][0], SecurityEnv.SECURITY_CONFIG[i][1]);
                ++i;
            }
        }
        NodeList nl1 = el.getElementsByTagName(MULTI_LEVEL_AUTH);
        int i = 0;
        while (i < nl1.getLength()) {
            Node node = nl1.item(i);
            if (node.hasAttributes()) {
                NamedNodeMap nodeMap = node.getAttributes();
                this.retrieveMultiLevelAuthAttributes(securityContextEnv, nodeMap);
            }
            ++i;
        }
        nl1 = el.getElementsByTagName(SECURITY_METADATA);
        int i2 = 0;
        while (i2 < nl1.getLength()) {
            Node node = nl1.item(i2);
            if (node.hasAttributes()) {
                NamedNodeMap nodeMap = node.getAttributes();
                this.retrieveSecurityMetadataAttributes(securityContextEnv, nodeMap);
            }
            ++i2;
        }
        nl = el.getElementsByTagName(CREDENTIALSTORE_CONTEXT);
        if (nl.getLength() <= 0) {
            return securityContextEnv;
        }
        elem = (Element)nl.item(0);
        int i3 = 0;
        while (i3 < SecurityEnv.CREDENTIALSTORE_CONFIG.length) {
            this.setConfigAttribute(securityContextEnv, elem, SecurityEnv.CREDENTIALSTORE_CONFIG[i3][0], SecurityEnv.CREDENTIALSTORE_CONFIG[i3][1]);
            ++i3;
        }
        return securityContextEnv;
    }

    void setConfigAttribute(Map securityContextEnv, Element elem, String attr, String prop) {
        String value = elem.getAttribute(attr);
        if (value != null & value.length() > 0) {
            securityContextEnv.put(prop, value);
        }
    }

    void retrieveMultiLevelAuthAttributes(Map securityContextEnv, NamedNodeMap nodeMap) {
        Hashtable<String, String> env = new Hashtable<String, String>(3);
        String key = null;
        int i = 0;
        while (i < nodeMap.getLength()) {
            Node node = nodeMap.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            if (name != null && name.equals("authLevel") && value != null) {
                key = name.concat(value);
            }
            env.put(name, value);
            ++i;
        }
        if (key != null) {
            securityContextEnv.put(key, env);
        }
    }

    void retrieveSecurityMetadataAttributes(Map securityContextEnv, NamedNodeMap nodeMap) {
        int i = 0;
        while (i < nodeMap.getLength()) {
            Node node = nodeMap.item(i);
            String name = node.getNodeName();
            String value = node.getNodeValue();
            if (name != null && value != null) {
                securityContextEnv.put(name, value);
            }
            ++i;
        }
    }
}

