/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.security.Permission;
import java.util.Hashtable;
import java.util.logging.Level;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityContextMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionEvaluator
extends SecurityContextMap {
    protected static ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();
    private SecurityContext mSecurityContext;
    private Hashtable<String, String> properties;
    public static final String TASKFLOW_PERMISSION_CLASS = "oracle.adf.controller.security.TaskFlowPermission";
    public static final String REGION_PERMISSION_CLASS = "oracle.adf.share.security.authorization.RegionPermission";
    public static final String JAAS_PERMISSION_ACTION = "action";
    private static final String DEFAULT_PRIVILEGE = "view";
    private static final String DELIMITER = "[;,]";
    private static final String EQUALS = "=";

    private void $init$() {
        this.properties = new Hashtable();
    }

    public PermissionEvaluator(SecurityContext secCtx) {
        this.$init$();
        this.mSecurityContext = secCtx;
    }

    public PermissionEvaluator(SecurityContext secCtx, String permissionClass) {
        this(secCtx);
        this.properties.put("permissionClass", permissionClass);
        this.properties.put("privilege", DEFAULT_PRIVILEGE);
    }

    @Override
    protected Object internalGet(String key) {
        int equalPos = key.indexOf(EQUALS);
        if (equalPos >= 0) {
            this.properties.put("permissionClass", TASKFLOW_PERMISSION_CLASS);
            PermissionEvaluator.tokenize(key, this.properties);
            String privilege = this.properties.get(JAAS_PERMISSION_ACTION);
            if (privilege != null) {
                this.properties.put("privilege", DEFAULT_PRIVILEGE);
            }
        } else {
            this.properties.put("target", key);
        }
        Permission permission = this.mSecurityContext.createPermissionInstance(this.properties);
        return new Boolean(this.mSecurityContext.hasPermission(permission));
    }

    static void tokenize(String key, Hashtable<String, String> props) {
        String[] pairs;
        String[] stringArray = pairs = key.split(DELIMITER);
        int n = 0;
        while (n < stringArray.length) {
            String p = stringArray[n];
            String[] tokens = p.split(EQUALS);
            if (tokens.length == 2) {
                String name = tokens[0];
                String value = tokens[1];
                if (name != null) {
                    name = name.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                _adfSecLogger.log(Level.FINEST, ": token pair [name, value] = [" + name + ", " + value + "]");
                if (name != null && name.length() != 0 && value != null && value.length() != 0) {
                    props.put(name, value);
                }
            }
            ++n;
        }
    }
}

