/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import oracle.adf.share.ADFContext;
import oracle.adf.share.Environment;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.PermissionEvaluator;
import oracle.adf.share.security.PermissionState;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityContextMap;
import oracle.adf.share.security.UserRoleEvaluator;
import oracle.adf.share.security.identitymanagement.UserProfile;

public class SecurityContextImpl
extends SecurityContextMap
implements SecurityContext {
    protected static ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();
    private static final int ENV_SIZE = 10;
    protected Hashtable mEnv;
    protected Hashtable mNames;
    protected String mNamedContext;
    protected PermissionState mPermissionState;
    protected boolean _isHttp;
    private long _timeMillis;
    private static final String SECURITYCONTEXT_PRINCIPAL = "__securitycontext_principal__";
    private static final String SECURITYCONTEXT_AUTH_TIMESTAMP = "__securitycontext_auth_timestamp__";
    private static final Object __LOCK__ = new Object();
    private static final String USER_IN_ROLE = "userInRole";
    private static final String USER_IN_ALL_ROLES = "userInAllRoles";
    private static final String USER_NAME = "userName";
    private static final String USER_GRANTED_PERMISSION = "userGrantedPermission";
    private static final String TASKFLOW_VIEWABLE = "taskflowViewable";
    private static final String REGION_VIEWABLE = "regionViewable";

    private void $init$() {
        this.mEnv = new Hashtable(10);
        this.mNames = new Hashtable();
        this.mNamedContext = null;
        this.mPermissionState = null;
        this._timeMillis = 0L;
    }

    public SecurityContextImpl() {
        this(null);
    }

    public SecurityContextImpl(Hashtable env) {
        this.$init$();
        if (env != null) {
            this.mEnv = (Hashtable)env.clone();
            this.mNamedContext = (String)this.mEnv.get("named.adf.context");
            try {
                this._isHttp = this.mNamedContext == null ? ADFContext.getCurrent().isHttpContext() : ADFContext.get(this.mNamedContext).isHttpContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mEnv.put("oracle.adf.security.authentication.j2se", Boolean.valueOf(this._isHttp ^ true).toString());
        }
    }

    public Principal getUserPrincipal() {
        return (Principal)this.mEnv.get("java.naming.security.principal");
    }

    public UserProfile getUserProfile() {
        if (this.getUserName() == null) {
            throw new ADFSecurityRuntimeException("EXC_NO_AUTHENTICATED_USER");
        }
        return new UserProfile(this.getUserName());
    }

    public String getUserName() {
        Principal p = this.getUserPrincipal();
        return p != null ? p.getName() : null;
    }

    public boolean isAuthorizationEnabled() {
        Object value = this.mEnv.get("oracle.adf.security.authorization.enforce");
        return value != null ? !value.equals(Boolean.FALSE.toString()) : false;
    }

    public boolean hasPermission(Permission permission) {
        Subject subject = this.getSubject();
        if (subject == null) {
            return false;
        }
        return this.doCheckPermission(permission, subject);
    }

    private boolean doCheckPermission(Permission permission, Subject subject) {
        boolean bOk = false;
        try {
            Subject.doAsPrivileged(subject, new 1(this, permission), null);
            bOk = true;
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return bOk;
    }

    public PermissionState getPermissionState() {
        _adfSecLogger.log(Level.FINEST, "-- getPermissionState ADFContext " + ADFContext.getCurrent().getClass().getName());
        return this.mPermissionState;
    }

    public void setPermissionState(PermissionState permissionState) {
        _adfSecLogger.log(Level.FINEST, "-- setPermissionState ADFContext " + ADFContext.getCurrent().getClass().getName());
        this.mPermissionState = permissionState;
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        if (name.equals("")) {
            return new NameList(this.mNames.keySet().iterator(), true);
        }
        return new NameList(name, true);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        if (name.equals("")) {
            return new NameList(this.mNames.keySet().iterator(), false);
        }
        return new NameList(name, false);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (oldName == null || oldName.equals("") || newName == null || newName.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        Object obj = null;
        Object v = this.mNames.get(oldName);
        obj = v;
        if (v == null) {
            throw new NameNotFoundException(oldName + " not bound.");
        }
        if (this.mNames.get(newName) != null) {
            throw new NameAlreadyBoundException(newName + " already bound.");
        }
        this.mNames.remove(oldName);
        this.mNames.put(newName, obj);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (oldName == null || newName == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.rename(oldName.toString(), newName.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        if (name == null || name.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (this.mNames.get(name) != null) {
            throw new NameAlreadyBoundException(name + " already bound.");
        }
        this.mNames.put(name, obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (name == null || name.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        this.mNames.put(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.rebind(name.toString(), obj);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.unbind(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.destroySubcontext(name.toString());
    }

    public void unbind(String name) throws NamingException {
        if (name == null || name.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        this.mNames.remove(name);
    }

    public void unbind(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.unbind(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Subcontext not supported.");
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.createSubcontext(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        return this.mNames.get(name);
    }

    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.lookup(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException("getNameParser not supported.");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.getNameParser(name.toString());
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (propName == null || propName.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (propName == "java.naming.security.principal") {
            this.setPrincipal(propVal);
            return propVal;
        }
        return propVal != null ? this.mEnv.put(propName, propVal) : null;
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (propName == null || propName.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (this.mEnv == null) {
            return null;
        }
        return this.mEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.mEnv == null) {
            throw new NamingException("Null Environment");
        }
        return this.mEnv;
    }

    public void close() throws NamingException {
        this.mEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPrincipal(Object principal) {
        if (principal != null && !Principal.class.isAssignableFrom(principal.getClass())) {
            return;
        }
        Object object = __LOCK__;
        synchronized (object) {
            RuntimePermission p = new RuntimePermission("setPrincipal");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(p);
            }
            if (principal == null) {
                this.mEnv.remove("java.naming.security.principal");
            } else {
                this.mEnv.put("java.naming.security.principal", principal);
            }
            if (this.isAuthorizationEnabled() || ADFSecurityUtil.isAuthenticationRequired()) {
                if (this._isHttp) {
                    Map scopeMap = ADFContext.getCurrent().getSessionScope();
                    if (scopeMap != null) {
                        Object obj = scopeMap.get(SECURITYCONTEXT_PRINCIPAL);
                        if (obj == principal || obj != null && principal != null && ((Principal)obj).getName().equals(((Principal)principal).getName())) {
                            return;
                        }
                        if (principal != null) {
                            scopeMap.put(SECURITYCONTEXT_PRINCIPAL, principal);
                        } else {
                            scopeMap.remove(SECURITYCONTEXT_PRINCIPAL);
                        }
                        this._timeMillis = System.currentTimeMillis();
                        scopeMap.put(SECURITYCONTEXT_AUTH_TIMESTAMP, new Long(this._timeMillis));
                    }
                } else {
                    this._timeMillis = System.currentTimeMillis();
                }
            }
        }
    }

    public boolean isAuthenticated() {
        Principal p = (Principal)this.mEnv.get("java.naming.security.principal");
        return p != null && (p == null || !p.getName().equals("anonymous"));
    }

    public boolean isUserInRole(String roleName) {
        boolean userInRole = false;
        if (this._isHttp) {
            try {
                Environment env = this.mNamedContext == null ? ADFContext.getCurrent().getEnvironment() : ADFContext.get(this.mNamedContext).getEnvironment();
                Object req = env.getRequest();
                if (req != null) {
                    userInRole = ((HttpServletRequest)req).isUserInRole(roleName);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (userInRole) {
            return true;
        }
        Subject s = this.getSubject();
        if (s != null) {
            for (Principal p : s.getPrincipals()) {
                String principalName = p.getName();
                int ix = principalName.indexOf("/");
                if ((ix <= 0 || !roleName.regionMatches(0, principalName, ix + 1, roleName.length())) && !roleName.equals(principalName)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getUserRoles() {
        ArrayList<String> list = new ArrayList<String>();
        String userName = this.getUserName();
        Subject s = this.getSubject();
        if (s != null) {
            for (Principal p : s.getPrincipals()) {
                String principalName = p.getName();
                int ix = principalName.indexOf("/");
                if (ix > 0 && userName.regionMatches(0, principalName, ix + 1, userName.length()) || userName.equals(principalName)) continue;
                list.add(principalName);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public Subject getSubject() {
        Subject s = null;
        Object value = this.mEnv.get("oracle.adf.security.authenticated");
        if (value != null && value.equals(Boolean.TRUE.toString()) || !this._isHttp) {
            s = (Subject)this.mEnv.get("jaas.subject");
        }
        if (s == null) {
            s = Subject.getSubject(AccessController.getContext());
        }
        return s;
    }

    public boolean isAnyoneEnabled() {
        Object value = this.mEnv.get("oracle.adf.security.anyone.enable");
        return value != null ? value.equals("true") : false;
    }

    public Permission createPermissionInstance(Hashtable values) {
        Permission p = null;
        String permClassName = (String)values.get("permissionClass");
        String target = (String)values.get("target");
        String actions = (String)values.get("privilege");
        if (permClassName != null && target != null) {
            try {
                Class cls = ClassUtils.forName((String)permClassName);
                Class strClass = ClassUtils.forName((String)"java.lang.String");
                Class[] params = null;
                if (actions == null) {
                    params = new Class[]{strClass};
                    Constructor ctr = cls.getConstructor(params);
                    p = (Permission)ctr.newInstance(target);
                } else {
                    params = new Class[]{strClass, strClass};
                    Constructor ctr = cls.getConstructor(params);
                    p = (Permission)ctr.newInstance(target, actions);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new IllegalStateException(e.getMessage());
            }
        }
        return p;
    }

    public boolean isXSMode() {
        return false;
    }

    public boolean attachToLightweightSession(Connection conn) {
        return false;
    }

    public boolean detachFromLightweightSession() {
        return false;
    }

    public Object getAttachedLightweightSession() {
        return null;
    }

    public boolean isReAuthenticated(long time) {
        Long _time;
        Map scopeMap;
        if (this._timeMillis == 0L && (scopeMap = ADFContext.getCurrent().getSessionScope()) != null && (_time = (Long)scopeMap.get(SECURITYCONTEXT_AUTH_TIMESTAMP)) != null) {
            this._timeMillis = _time;
        }
        return this._timeMillis > time;
    }

    protected void showPrincipals() {
        Subject subject = this.getSubject();
        if (subject != null && subject.getPrincipals() != null) {
            _adfSecLogger.log(Level.FINEST, "---- principals ");
            for (Principal p : subject.getPrincipals()) {
                _adfSecLogger.log(Level.FINEST, "\t---- name: " + p.getName() + ", class: " + p.getClass().getName());
            }
        } else {
            _adfSecLogger.log(Level.FINEST, "---- no subject, principals ");
        }
    }

    protected Object internalGet(String key) {
        if (USER_NAME == (key = key.intern())) {
            return this.getUserName();
        }
        if (USER_IN_ROLE == key) {
            return new UserRoleEvaluator(this, false);
        }
        if (USER_IN_ALL_ROLES == key) {
            return new UserRoleEvaluator(this, true);
        }
        if (USER_GRANTED_PERMISSION == key) {
            return new PermissionEvaluator(this);
        }
        if (TASKFLOW_VIEWABLE == key) {
            return new PermissionEvaluator(this, "oracle.adf.controller.security.TaskFlowPermission");
        }
        if (REGION_VIEWABLE == key) {
            return new PermissionEvaluator(this, "oracle.adf.share.security.authorization.RegionPermission");
        }
        return null;
    }

    final class 1
    implements PrivilegedAction {
        private final /* synthetic */ Permission v$permission;
        final /* synthetic */ SecurityContextImpl this$0;

        public Object run() {
            AccessController.checkPermission(this.v$permission);
            return null;
        }

        public 1(SecurityContextImpl securityContextImpl, Permission permission) {
            this.v$permission = permission;
            this.this$0 = securityContextImpl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NameList
    implements NamingEnumeration {
        Iterator names;
        boolean isNameClassPair;

        NameList(String name, boolean ncpair) {
            ArrayList<String> vec = new ArrayList<String>(1);
            if (SecurityContextImpl.this.mNames.get(name) != null) {
                vec.add(name);
            }
            this.names = vec.iterator();
            this.isNameClassPair = ncpair;
        }

        NameList(Iterator namesEnum, boolean ncpair) {
            this.names = namesEnum;
            this.isNameClassPair = ncpair;
        }

        @Override
        public boolean hasMoreElements() {
            return this.names.hasNext();
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public Object nextElement() {
            String name = (String)this.names.next();
            if (this.isNameClassPair) {
                return new NameClassPair(name, SecurityContextImpl.this.mNames.get(name).getClass().getName());
            }
            return new Binding(name, SecurityContextImpl.this.mNames.get(name));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        @Override
        public void close() throws NamingException {
            this.names = null;
        }
    }
}

