/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.util.ArrayList;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityContextMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserRoleEvaluator
extends SecurityContextMap {
    private SecurityContext mSecurityContext;
    private boolean checkAllRoles;
    private static final String DELIMITER = "[;,]";

    private void $init$() {
        this.checkAllRoles = false;
    }

    public UserRoleEvaluator(SecurityContext secCtx, boolean inAllRoles) {
        this.$init$();
        this.mSecurityContext = secCtx;
        this.checkAllRoles = inAllRoles;
    }

    @Override
    protected Object internalGet(String key) {
        ArrayList<String> roles = new ArrayList<String>(1);
        UserRoleEvaluator.tokenize(key, roles);
        boolean isInRole = false;
        int i = 0;
        while (i < roles.size()) {
            isInRole = this.mSecurityContext.isUserInRole(roles.get(i));
            if (!isInRole && this.checkAllRoles) {
                return Boolean.FALSE;
            }
            if (isInRole && !this.checkAllRoles) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return new Boolean(isInRole);
    }

    static void tokenize(String key, ArrayList<String> roles) {
        String[] tokens = key.split(DELIMITER);
        int i = 0;
        while (i < tokens.length) {
            String value = tokens[i];
            if (value != null) {
                value = value.trim();
            }
            if (value != null && value.length() != 0) {
                roles.add(value);
            }
            ++i;
        }
    }
}

