/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore;

import java.io.Serializable;
import java.security.Principal;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.CredentialStoreContext;
import oracle.adf.share.security.credentialstore.spi.CredentialProvisioning;

public class CredentialProvisioner {
    CredentialStoreContext _credentialStoreCtx;
    CredentialProvisioning _provisioning;
    static final ADFLogger sLogger = ADFSecurityUtil.getADFLogger();
    static final String CLASS_NAME = CredentialProvisioner.class.getName();

    private void $init$() {
        this._credentialStoreCtx = CredentialStoreContext.getInstance();
        this._provisioning = null;
    }

    public CredentialProvisioner() {
        this.$init$();
        this._provisioning = this._credentialStoreCtx.getDefaultCredentialProvisioner();
    }

    public CredentialProvisioner(String contextName) {
        this.$init$();
        this._provisioning = this._credentialStoreCtx.getCredentialProvisioner(contextName);
    }

    public void storeCredential(Credential cred, String credKey, Principal principal) {
        String METHOD_NAME = "storeCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeCredential", "Credential", cred);
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeCredential", "Credential Key", credKey);
        CredentialStoreContext.checkSerializable(CLASS_NAME, "storeCredential", cred, credKey);
        this._provisioning.storeCredential(cred, credKey, principal);
    }

    public void storeSerializableCredential(Serializable cred, String credKey, Principal principal) {
        String METHOD_NAME = "storeSerializableCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSerializableCredential", "Credential", cred);
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSerializableCredential", "Credential Key", credKey);
        this._provisioning.storeSerializableCredential(cred, credKey, principal);
    }

    public void removeCredential(String credKey, Principal principal) throws CredentialNotFoundException {
        String METHOD_NAME = "removeCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "removeCredential", "Credential Key", credKey);
        this._provisioning.removeCredential(credKey, principal);
    }
}

