/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore;

import java.io.Serializable;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.CredentialStoreContext;
import oracle.adf.share.security.credentialstore.spi.CredentialStorage;

public class CredentialStore {
    CredentialStoreContext _credentialStoreCtx;
    CredentialStorage _storage;
    static final String CLASS_NAME = CredentialStore.class.getName();
    static final ADFLogger sLogger = ADFSecurityUtil.getADFLogger();

    private void $init$() {
        this._credentialStoreCtx = CredentialStoreContext.getInstance();
        this._storage = null;
    }

    public CredentialStore() {
        this.$init$();
        this._storage = this._credentialStoreCtx.getDefaultCredentialStoreProvider();
    }

    public CredentialStore(String contextName) {
        this.$init$();
        this._storage = this._credentialStoreCtx.getCredentialStorage(contextName);
    }

    public void storeCredential(Credential cred, String credKey) {
        String METHOD_NAME = "storeCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeCredential", "Credential", cred);
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeCredential", "Credential Key", credKey);
        CredentialStoreContext.checkSerializable(CLASS_NAME, "storeCredential", cred, credKey);
        this._storage.storeCredential(cred, credKey);
    }

    public void storeSessionCredential(Credential cred, String credKey) {
        String METHOD_NAME = "storeSessionCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSessionCredential", "Credential", cred);
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "storeSessionCredential", "Credential Key", credKey);
        CredentialStoreContext.storeSessionCredential(cred, credKey);
    }

    public Credential fetchSessionCredential(String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "fetchSessionCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "fetchSessionCredential", "Credential Key", credKey);
        return CredentialStoreContext.fetchSessionCredential(credKey);
    }

    public Credential fetchCredential(String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "fetchCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "fetchCredential", "Credential Key", credKey);
        return this._storage.fetchCredential(credKey);
    }

    public Serializable fetchSerializableCredential(String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "fetchSerializableCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "fetchSerializableCredential", "Credential Key", credKey);
        return this._storage.fetchSerializableCredential(credKey);
    }

    public Serializable fetchSerializableCredentialForCurrentUser(String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "fetchSerializableCredentialForCurrentUser";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "fetchSerializableCredentialForCurrentUser", "Credential Key", credKey);
        return this._storage.fetchSerializableCredentialForCurrentUser(credKey);
    }

    public void removeCredential(String credKey) throws CredentialNotFoundException {
        String METHOD_NAME = "removeCredential";
        ADFSecurityUtil.checkNotNull(CLASS_NAME, "removeCredential", "Credential Key", credKey);
        this._storage.removeCredential(credKey);
    }
}

