/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore;

import java.beans.Beans;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityEnv;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.spi.CredentialProvisioning;
import oracle.adf.share.security.credentialstore.spi.CredentialStorage;

public class CredentialStoreContext {
    private static CredentialStoreContext _singleton;
    private static final Object __LOCK__;
    private static Hashtable _sessionCredentials;
    private Hashtable mEnv;
    static final ADFLogger sLogger;

    private void $init$() {
        this.mEnv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialStoreContext getInstance() {
        Object object = __LOCK__;
        synchronized (object) {
            if (_singleton == null) {
                CredentialStoreContext credentialStoreContext = _singleton = new CredentialStoreContext(null);
                return credentialStoreContext;
            }
        }
        return _singleton;
    }

    public CredentialStoreContext(Hashtable env) {
        this.$init$();
        this.mEnv = env;
    }

    public void initialize(Properties props) {
    }

    public CredentialStorage getDefaultCredentialStoreProvider() {
        return this.getCredentialStorage(null);
    }

    public CredentialProvisioning getDefaultCredentialProvisioner() {
        return (CredentialProvisioning)((Object)this.getDefaultCredentialStoreProvider());
    }

    public CredentialProvisioning getCredentialProvisioner(String providerClassName) {
        return (CredentialProvisioning)((Object)this.getCredentialStorage(providerClassName));
    }

    public CredentialStorage getCredentialStoreProvider(String providerClassName) {
        return this.getCredentialStorage(providerClassName);
    }

    public CredentialStorage getCredentialStorage(String contextName) {
        CredentialStorage instance = null;
        String providerClassName = null;
        if (contextName != null && contextName.length() > 0) {
            try {
                ADFConfig cfg = ADFContext.get(contextName).getADFConfig();
                this.mEnv = (Hashtable)cfg.getConfigObject("http://xmlns.oracle.com/adf/security/config");
            }
            catch (Exception e) {
                throw new ADFSecurityRuntimeException("EXC_CREDENTIAL_STORE_INIT", e);
            }
        }
        contextName = "default";
        try {
            this.mEnv = ADFContext.getCurrent().getSecurityContext().getEnvironment();
        }
        catch (Exception e) {
            // empty catch block
        }
        String string = providerClassName = this.mEnv != null ? (String)this.mEnv.get("oracle.adf.security.credentialstore") : null;
        if (providerClassName == null || providerClassName.length() == 0) {
            providerClassName = SecurityEnv.CREDENTIAL_STORE_PROVIDER_DEFAULT;
        }
        String CRED_STORE_PROVIDER_RT = "oracle.adf.share.security.providers.jps.CSFCredentialStore";
        String CRED_STORE_PROVIDER_DT = "oracle.adf.share.dt.security.providers.jps.CSFDTCredentialStore";
        if (providerClassName.equals("oracle.adf.share.security.providers.jps.CSFCredentialStore") && Beans.isDesignTime()) {
            providerClassName = "oracle.adf.share.dt.security.providers.jps.CSFDTCredentialStore";
        }
        try {
            Class cls = ClassUtils.forName((String)providerClassName);
            Constructor ctor = cls.getConstructor(String.class);
            instance = (CredentialStorage)ctor.newInstance(contextName);
        }
        catch (Exception ex) {
            throw new ADFSecurityRuntimeException("EXC_CREDENTIAL_STORE_INIT", ex);
        }
        return instance;
    }

    public static void storeSessionCredential(Credential cred, String credKey) {
        _sessionCredentials.put(credKey, cred);
    }

    public static Credential fetchSessionCredential(String credKey) throws CredentialNotFoundException {
        Credential cred = (Credential)_sessionCredentials.get(credKey);
        if (cred == null) {
            throw new CredentialNotFoundException(credKey, "session store");
        }
        return cred;
    }

    String getDefaultCredentialStoreClassName() {
        SecurityContext secCtx = ADFContext.getCurrent().getSecurityContext();
        String credStore = null;
        try {
            credStore = (String)secCtx.getEnvironment().get("oracle.adf.security.credentialstore");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (credStore == null) {
            credStore = SecurityEnv.CREDENTIAL_STORE_PROVIDER_DEFAULT;
        }
        return credStore;
    }

    public static void checkSerializable(String className, String methodName, Credential cred, String credKey) {
        if (!ADFSecurityUtil.checkSerializable(cred.getProperties())) {
            ADFSecurityRuntimeException sre = new ADFSecurityRuntimeException("EXC_STORE_CREDENTIAL_NOT_SERIALIZABLE", new String[]{credKey});
            sLogger.throwing(Level.WARNING, className, methodName, (Throwable)sre);
            throw sre;
        }
    }

    static {
        __LOCK__ = new Object();
        _sessionCredentials = new Hashtable();
        sLogger = ADFSecurityUtil.getADFLogger();
    }
}

