/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.statemanager;

import java.io.Serializable;
import java.security.SecureRandom;

public class UUID
implements Serializable {
    static final long serialVersionUID = 9008807960891297392L;
    private static volatile SecureRandom mGenerator = null;
    private final long mMSB;
    private final long mLSB;
    private transient String mStringValue;

    private UUID() {
        if (mGenerator == null) {
            mGenerator = new SecureRandom();
        }
        byte[] randomBytes = new byte[16];
        mGenerator.nextBytes(randomBytes);
        randomBytes[8] = (byte)(randomBytes[8] & 0xBF);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        long msb = 0L;
        int i = 0;
        while (i < 8) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
            ++i;
        }
        long lsb = 0L;
        int i2 = 8;
        while (i2 < 16) {
            lsb = lsb << 8 | (long)(randomBytes[i2] & 0xFF);
            ++i2;
        }
        this.mMSB = msb;
        this.mLSB = lsb;
    }

    private UUID(long msb, long lsb) {
        this.mMSB = msb;
        this.mLSB = lsb;
    }

    public String toString() {
        if (this.mStringValue == null) {
            StringBuffer sb = new StringBuffer(132);
            sb.append(UUID.digits(this.mMSB >> 32, 8));
            sb.append('-');
            sb.append(UUID.digits(this.mMSB >> 16, 4));
            sb.append('-');
            sb.append(UUID.digits(this.mMSB, 4));
            sb.append('-');
            sb.append(UUID.digits(this.mLSB >> 48, 4));
            sb.append('-');
            sb.append(UUID.digits(this.mLSB, 12));
            this.mStringValue = sb.toString();
        }
        return this.mStringValue;
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public boolean equals(Object uuid) {
        return uuid instanceof UUID && ((UUID)uuid).mMSB == this.mMSB && ((UUID)uuid).mLSB == this.mLSB;
    }

    public int hashCode() {
        return (int)this.mLSB >> 32;
    }

    public static Object generateUUID() {
        return new UUID();
    }

    public static Object generateUUID(String uuidString) {
        long msb = 0L;
        msb = Long.parseLong(uuidString.substring(0, 8), 16) << 32;
        msb |= Long.parseLong(uuidString.substring(9, 13), 16) << 16;
        long lsb = 0L;
        lsb = Long.parseLong(uuidString.substring(19, 23), 16) << 48;
        return new UUID(msb |= Long.parseLong(uuidString.substring(14, 18), 16), lsb |= Long.parseLong(uuidString.substring(24, 36), 16));
    }
}

