/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.formatting.boot;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeStarter;
import oracle.ide.Version;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.FormatBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingStarter
extends IdeStarter {
    protected static final FormatBundle bundle = new FormatBundle(FormattingStarter.class);
    ArrayList<Workspace> workspaces;
    ArrayList<Project> projects;

    private void $init$() {
        this.workspaces = new ArrayList();
        this.projects = new ArrayList();
    }

    public FormattingStarter() {
        this.$init$();
    }

    public void startIde(String command, String[] arguments, IdeCore core) {
        System.setProperty("display.logger.mode", "headless");
        IdeArgs ideArgs = core.getIdeArgs();
        ideArgs.setCreateUI(false);
        core.useInvokeLaterForAddinsLoadedEvenThoughHeadless();
        Ide.startup((IdeCore)core);
        if (arguments.length == 0 || arguments.length == 1 && "-help".equals(arguments[0])) {
            this.printUsage();
            System.exit(0);
        }
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i].endsWith(".jws")) {
                try {
                    File file = new File(arguments[i]);
                    if (file.exists()) {
                        this.workspaces.add((Workspace)NodeFactory.findOrCreate(Workspace.class, (URL)URLFactory.newFileURL((String)file.getCanonicalPath())));
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(1);
                }
            } else if (arguments[i].endsWith(".jpr")) {
                try {
                    File file = new File(arguments[i]);
                    if (file.exists()) {
                        this.projects.add((Project)NodeFactory.findOrCreate(Project.class, (URL)URLFactory.newFileURL((String)arguments[i])));
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            ++i;
        }
    }

    public ArrayList<Workspace> getWorkspaces() {
        return this.workspaces;
    }

    public ArrayList<Project> getProjects() {
        return this.projects;
    }

    private void printUsage() {
        this.printCopyright();
        System.out.println(bundle.get("reformat.usage.message"));
        System.out.println();
    }

    private void printCopyright() {
        System.out.println(bundle.get("reformat.copyright.message", new Object[]{Version.NAME_SHORT, Version.VER, Version.BUILD_NUM}));
        System.out.println();
    }
}

