/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.EnvironOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.layout.IdeLayout;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.DontStartNoMessageError;
import oracle.ide.runner.LogOutputThread;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.RunnableItem;
import oracle.ide.runner.Runner;
import oracle.ide.runner.Starter;
import oracle.ide.runner.StarterCookieList;
import oracle.ide.runner.StarterFactory;
import oracle.ide.runner.StarterFactoryChoiceDialog;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.ModelUtil;

public abstract class RunProcess
implements Element,
Helpable {
    public static String RUN_PROCESS_USE_NODE_FROM_CONTEXT = "RUN_PROCESS_USE_NODE_FROM_CONTEXT";
    public static String RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT = "RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT";
    protected long timeCreated;
    protected Context context;
    protected boolean logStartDirectory;
    protected boolean logCommandString;
    protected boolean logOutput;
    private List duplicateOutput;
    protected boolean allowInput;
    protected boolean logError;
    private List duplicateError;
    protected boolean logExit;
    protected boolean showStartStatus;
    protected boolean addToProcessesFolder;
    protected boolean addToTerminateMenu;
    protected boolean useLogPage;
    protected LogPage logPageOverride;
    protected RunProcessListener runProcessListener;
    protected boolean userCanceled;
    protected List errors;
    protected boolean determineTargetAndStarterAlready;
    protected String labelOverride;
    protected String labelPrefixOverride;
    protected Icon iconOverride;
    protected Node target;
    protected Starter starter;
    protected boolean isPreparingLabel;
    private LogOutputThread logSystemOutThread;
    private LogOutputThread logSystemErrThread;
    private boolean processNodeAdded;
    private boolean terminateMenuAdded;
    private boolean finished;
    private Attributes attributes;
    private static int systemOutColor;
    private static SimpleAttributeSet systemOutAttributeSet;
    private static int systemErrColor;
    private static SimpleAttributeSet systemErrAttributeSet;
    private LogPage logPage;

    private void $init$() {
        this.determineTargetAndStarterAlready = false;
        this.isPreparingLabel = false;
        this.attributes = new ElementAttributes(ElementAttributes.NONE);
    }

    public RunProcess(Context context) {
        this.$init$();
        this.timeCreated = System.currentTimeMillis();
        this.context = context;
        this.logStartDirectory = true;
        this.logCommandString = true;
        this.logOutput = true;
        this.allowInput = false;
        this.logError = true;
        this.logExit = false;
        this.showStartStatus = true;
        this.addToProcessesFolder = true;
        this.addToTerminateMenu = true;
        this.useLogPage = true;
        this.logPageOverride = null;
        this.labelPrefixOverride = null;
        this.iconOverride = null;
        this.errors = new ArrayList();
    }

    protected Object copyTo(Object o) {
        if (o == null) {
            throw new IllegalStateException();
        }
        RunProcess other = (RunProcess)o;
        other.context = this.context;
        other.useLogPage = this.useLogPage;
        other.logPageOverride = this.logPageOverride;
        other.allowInput = this.allowInput;
        other.logStartDirectory = this.logStartDirectory;
        other.logCommandString = this.logCommandString;
        other.showStartStatus = this.showStartStatus;
        other.addToProcessesFolder = this.addToProcessesFolder;
        other.addToTerminateMenu = this.addToTerminateMenu;
        other.runProcessListener = this.runProcessListener;
        other.logError = this.logError;
        other.logOutput = this.logOutput;
        other.labelPrefixOverride = this.labelPrefixOverride;
        other.iconOverride = this.iconOverride;
        return other;
    }

    public final void setLogOutput(boolean logOutput) {
        this.logOutput = logOutput;
    }

    public final void setLogError(boolean logError) {
        this.logError = logError;
    }

    public PipedInputStream duplicateOutputStream() {
        PipedInputStream pis = new PipedInputStream();
        if (this.duplicateOutput == null) {
            this.duplicateOutput = new ArrayList();
        }
        this.duplicateOutput.add(pis);
        return pis;
    }

    public PipedInputStream duplicateErrorStream() {
        PipedInputStream pis = new PipedInputStream();
        if (this.duplicateError == null) {
            this.duplicateError = new ArrayList();
        }
        this.duplicateError.add(pis);
        return pis;
    }

    protected Class getStarterFactorySubClass() {
        return StarterFactory.class;
    }

    protected void determineTargetAndStarter() {
        if (this.determineTargetAndStarterAlready || this.target != null) {
            return;
        }
        this.determineTargetAndStarter(this.getStarterFactorySubClass());
        this.determineTargetAndStarterAlready = true;
    }

    public static Node getContextNodeForRun(Context context) {
        int length;
        if (context != null && context.containsProperty(RUN_PROCESS_USE_NODE_FROM_CONTEXT) && context.getNode() != null) {
            return context.getNode();
        }
        Element[] selection = context.getSelection();
        if (selection != null && (length = selection.length) > 0 && selection[0] instanceof Node) {
            if (length == 1) {
                return (Node)selection[0];
            }
            Node runnable = null;
            Runner runner = Runner.getRunner();
            int i = 0;
            while (i < length) {
                Element element = selection[i];
                if (element instanceof Node && runner.couldNodeBeRunnable((Node)element)) {
                    if (runnable == null) {
                        runnable = (Node)element;
                    } else {
                        return null;
                    }
                }
                ++i;
            }
            return runnable;
        }
        return context.getNode();
    }

    protected void determineTargetAndStarter(Class starterFactorySubClass) {
        boolean needToAddError = true;
        Node contextNode = RunProcess.getContextNodeForRun(this.context);
        if (contextNode != null && !(contextNode instanceof Project)) {
            Node node = contextNode;
            boolean addExtraError = true;
            boolean couldNodeBeRunnable = Runner.getRunner().couldNodeBeRunnable(node, starterFactorySubClass);
            if (couldNodeBeRunnable) {
                int errorCountBeforeGetStarter = this.errors.size();
                Starter s = null;
                try {
                    s = this.getStarterForTarget(node, starterFactorySubClass);
                }
                catch (DontStartNoMessageError dsnme) {
                    couldNodeBeRunnable = true;
                    addExtraError = false;
                }
                if (s != null) {
                    this.target = node;
                    this.starter = s;
                    return;
                }
                boolean bl = needToAddError = this.errors.size() == errorCountBeforeGetStarter;
            }
            if (needToAddError && addExtraError) {
                String error = RunMgrArb.format((int)2, (Object)contextNode.getShortLabel());
                this.errors.add(error);
            }
        } else if (needToAddError && this.context.getProject() == null) {
            String error = RunMgrArb.getString((int)6);
            this.errors.add(error);
        }
    }

    protected Starter getStarterForTarget(Node node, Class starterFactorySubClass) {
        block18: {
            if (this.userCanceled) {
                return null;
            }
            if (node != null) {
                URL url = node.getURL();
                if (url == null) {
                    throw new IllegalArgumentException("Null node URL for " + node.getShortLabel() + " of type " + node.getClass().getName());
                }
                if (!url.getProtocol().equalsIgnoreCase("file") || URLFileSystem.exists((URL)url)) {
                    Class targetClass = node.getClass();
                    AbstractStarterFactory[] starterFactories = Runner.getRunner().getStarterFactoriesForTarget(targetClass, starterFactorySubClass);
                    int length = starterFactories.length;
                    ArrayList<AbstractStarterFactory> goodStarterFactories = new ArrayList<AbstractStarterFactory>();
                    ArrayList<Object> cookies = new ArrayList<Object>();
                    int i = 0;
                    while (i < length) {
                        AbstractStarterFactory abstractStarterFactory = starterFactories[i];
                        Object cookie = abstractStarterFactory.canStart(this, this.context, node, this.errors);
                        if (cookie != null) {
                            if (cookie instanceof StarterCookieList) {
                                StarterCookieList starterCookieList = (StarterCookieList)cookie;
                                int size = starterCookieList.size();
                                int ii = 0;
                                while (ii < size) {
                                    Object o = starterCookieList.get(ii);
                                    goodStarterFactories.add(abstractStarterFactory);
                                    cookies.add(o);
                                    ++ii;
                                }
                            } else {
                                goodStarterFactories.add(abstractStarterFactory);
                                cookies.add(cookie);
                            }
                        }
                        ++i;
                    }
                    if (!goodStarterFactories.isEmpty()) {
                        int index = 0;
                        int size = goodStarterFactories.size();
                        if (size > 1) {
                            Displayable[] displayables = new Displayable[size];
                            int i2 = 0;
                            while (i2 < size) {
                                AbstractStarterFactory abstractStarterFactory = (AbstractStarterFactory)goodStarterFactories.get(i2);
                                Object cookie = cookies.get(i2);
                                displayables[i2] = abstractStarterFactory.getDisplayable(this, this.context, node, cookie);
                                ++i2;
                            }
                            index = StarterFactoryChoiceDialog.showStarterFactoryChoiceDialog(node, displayables);
                            if (index == -1) {
                                this.userCanceled = true;
                                return null;
                            }
                        }
                        try {
                            AbstractStarterFactory abstractStarterFactory = (AbstractStarterFactory)goodStarterFactories.get(index);
                            Object cookie = cookies.get(index);
                            Starter starter = abstractStarterFactory.createStarter(this, this.context, node, cookie);
                            if (this.checkStarter(starter, this.errors)) {
                                Starter starter2 = starter;
                                return starter2;
                            }
                        }
                        catch (RuntimeException e) {
                            String msg = e.getMessage();
                            if (msg != null && msg.indexOf("user canceled") >= 0) {
                                this.userCanceled = true;
                                break block18;
                            }
                            Logger.getLogger("oracle.ide.runner").log(Level.SEVERE, "Unable to initialize starter for run/debug:", e);
                        }
                    }
                } else {
                    String error = RunMgrArb.format((int)16, (Object)node.getShortLabel());
                    this.errors.add(error);
                }
            }
        }
        return null;
    }

    public RunnableItem[] getRunnableItems() {
        Class starterFactorySubClass = this.getStarterFactorySubClass();
        Node contextNode = RunProcess.getContextNodeForRun(this.context);
        if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
            Node node = contextNode;
            if (Runner.getRunner().couldNodeBeRunnable(node, starterFactorySubClass)) {
                int errorCountBeforeGetStarter = this.errors.size();
                return this.getRunnableItemsForTarget(node, starterFactorySubClass);
            }
        }
        return null;
    }

    protected RunnableItem[] getRunnableItemsForTarget(Node node, Class starterFactorySubClass) {
        if (node != null) {
            URL url = node.getURL();
            if (url == null) {
                throw new IllegalArgumentException("Null node URL for " + node.getShortLabel() + " of type " + node.getClass().getName());
            }
            if (!url.getProtocol().equalsIgnoreCase("file") || URLFileSystem.exists((URL)url)) {
                Class targetClass = node.getClass();
                AbstractStarterFactory[] starterFactories = Runner.getRunner().getStarterFactoriesForTarget(targetClass, starterFactorySubClass);
                int length = starterFactories.length;
                ArrayList<AbstractStarterFactory> goodStarterFactories = new ArrayList<AbstractStarterFactory>();
                ArrayList<Object> cookies = new ArrayList<Object>();
                int i = 0;
                while (i < length) {
                    AbstractStarterFactory abstractStarterFactory = starterFactories[i];
                    Object cookie = abstractStarterFactory.canStart(this, this.context, node, this.errors);
                    if (cookie != null) {
                        if (cookie instanceof StarterCookieList) {
                            StarterCookieList starterCookieList = (StarterCookieList)cookie;
                            int size = starterCookieList.size();
                            int ii = 0;
                            while (ii < size) {
                                Object o = starterCookieList.get(ii);
                                goodStarterFactories.add(abstractStarterFactory);
                                cookies.add(o);
                                ++ii;
                            }
                        } else {
                            goodStarterFactories.add(abstractStarterFactory);
                            cookies.add(cookie);
                        }
                    }
                    ++i;
                }
                if (!goodStarterFactories.isEmpty()) {
                    int size = goodStarterFactories.size();
                    RunnableItem[] runnableItems = new RunnableItem[size];
                    int i2 = 0;
                    while (i2 < size) {
                        AbstractStarterFactory abstractStarterFactory = (AbstractStarterFactory)goodStarterFactories.get(i2);
                        Object cookie = cookies.get(i2);
                        runnableItems[i2] = new RunnableItem(this, this.context, node, abstractStarterFactory, cookie);
                        ++i2;
                    }
                    return runnableItems;
                }
            }
        }
        return null;
    }

    public String canGetStarterForTarget(Node node, Class starterFactorySubClass, List errors) {
        if (node != null) {
            Class targetClass = node.getClass();
            int errorCountBefore = errors.size();
            AbstractStarterFactory[] starterFactories = Runner.getRunner().getStarterFactoriesForTarget(targetClass, starterFactorySubClass);
            int length = starterFactories.length;
            int i = 0;
            while (i < length) {
                AbstractStarterFactory abstractStarterFactory = starterFactories[i];
                Object cookie = abstractStarterFactory.canStart(this, this.context, node, errors);
                if (cookie != null) {
                    return abstractStarterFactory.getName();
                }
                ++i;
            }
            if (errors.size() == errorCountBefore) {
                String error = RunMgrArb.format((int)2, (Object)node.getShortLabel());
                errors.add(error);
            }
        }
        return null;
    }

    protected boolean checkStarter(Starter starter, List errors) {
        return starter.canStart(errors);
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public Context getContext() {
        return this.context;
    }

    public Workspace getWorkspace() {
        Workspace workspace = this.context.getWorkspace();
        if (workspace == null) {
            workspace = Ide.getDefaultWorkspace();
        }
        return workspace;
    }

    public Project getProject() {
        return RunProcess.getProject(this.context);
    }

    public static Project getProject(Context context) {
        Project project = context.getProject();
        if (project == null) {
            project = Ide.getDefaultProject();
        }
        return project;
    }

    public boolean canRun(String runType, Object cookie, Node node, List errors) {
        return false;
    }

    public Object getValue(String runType, Object cookie, String key) {
        return null;
    }

    public final Node getTarget() {
        return this.getTarget(true);
    }

    public final Node getTarget(boolean determineTargetAndStarter) {
        if (determineTargetAndStarter) {
            this.determineTargetAndStarter();
        }
        return this.target;
    }

    public final Starter getStarter() {
        return this.getStarter(true);
    }

    public final Starter getStarter(boolean determineTargetAndStarter) {
        if (determineTargetAndStarter) {
            this.determineTargetAndStarter();
        }
        return this.starter;
    }

    public boolean canStart() {
        this.determineTargetAndStarter();
        return this.starter != null;
    }

    public void start(Node node, AbstractStarterFactory abstractStarterFactory, Object cookie) {
        this.determineTargetAndStarterAlready = true;
        this.target = node;
        this.starter = abstractStarterFactory.createStarter(this, this.context, node, cookie);
        if (this.checkStarter(this.starter, this.errors)) {
            this.start();
        } else {
            this.logStartErrors();
        }
    }

    public void start() {
        this.determineTargetAndStarter();
        if (this.mustPrepareToStart()) {
            1 prepareThread = new 1("RunProcess-PrepareToStart");
            prepareThread.start();
        } else {
            this.startTarget();
        }
    }

    protected boolean mustPrepareToStart() {
        this.determineTargetAndStarter();
        if (this.starter != null) {
            return this.starter.mustPrepareToStart();
        }
        return false;
    }

    protected boolean prepareToStart() {
        this.determineTargetAndStarter();
        if (this.starter != null) {
            return this.starter.prepareToStart();
        }
        return true;
    }

    protected boolean startTarget() {
        this.determineTargetAndStarter();
        if (this.starter != null) {
            this.errors.clear();
            if (this.starter.start()) {
                this.started();
                return true;
            }
        }
        if (this.userCanceled) {
            this.errors.clear();
        } else {
            this.logStartErrors();
        }
        this.notifyRunProcessListener(Integer.MIN_VALUE);
        return false;
    }

    protected void logStartErrors() {
        LogPage logPage;
        if (!this.errors.isEmpty() && (logPage = this.getLogPage()) != null) {
            for (String s : this.errors) {
                logPage.log((Object)(s + "\n"));
            }
            this.errors.clear();
        }
    }

    public void started() {
        if (this.addToProcessesFolder || this.addToTerminateMenu || this.getUseLogPage() && (this.logPageOverride == null || this.logPageOverride instanceof RunLogPage)) {
            this.doUI(new 2());
        }
    }

    public void redirectOutput(InputStream systemOutStream, InputStream systemErrStream) {
        LogPage logPage = this.getLogPage();
        String label = this.getShortLabel();
        String name = label + " System.out";
        this.logSystemOutThread = new LogOutputThread(name, this, (LogPage)(this.logOutput ? logPage : null), RunProcess.getSystemOutAttributeSet(), systemOutStream, this.duplicateOutput);
        this.logSystemOutThread.start();
        name = label + " System.err";
        this.logSystemErrThread = new LogOutputThread(name, this, (LogPage)(this.logError ? logPage : null), RunProcess.getSystemErrAttributeSet(), systemErrStream, this.duplicateError);
        this.logSystemErrThread.start();
    }

    public static synchronized SimpleAttributeSet getSystemOutAttributeSet() {
        if (systemOutAttributeSet == null) {
            systemOutAttributeSet = new SimpleAttributeSet();
        }
        EnvironOptions environOptions = Ide.getEnvironOptions();
        if (systemOutColor == 0 || systemOutColor != environOptions.getLogSystemOutColor()) {
            systemOutColor = environOptions.getLogSystemOutColor();
            StyleConstants.setForeground(systemOutAttributeSet, new Color(systemOutColor));
        }
        return systemOutAttributeSet;
    }

    public static synchronized SimpleAttributeSet getSystemErrAttributeSet() {
        if (systemErrAttributeSet == null) {
            systemErrAttributeSet = new SimpleAttributeSet();
        }
        EnvironOptions environOptions = Ide.getEnvironOptions();
        if (systemErrColor == 0 || systemErrColor != environOptions.getLogSystemErrColor()) {
            systemErrColor = environOptions.getLogSystemErrColor();
            StyleConstants.setForeground(systemErrAttributeSet, new Color(systemErrColor));
        }
        return systemErrAttributeSet;
    }

    public void redirectInput(OutputStream input) {
        LogPage lp;
        if (this.allowInput && (lp = this.getLogPage()) != null && lp instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            runLogPage.allowInput(this, input);
        }
    }

    public void waitForRedirectOutput() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (this.logSystemOutThread != null) {
            LogOutputThread.waitForOutput(this.logSystemOutThread);
        }
        if (this.logSystemErrThread != null) {
            LogOutputThread.waitForOutput(this.logSystemErrThread);
        }
    }

    void finishRedirectOutput() {
        this.waitForRedirectOutput();
        if (this.logSystemOutThread != null) {
            try {
                this.logSystemOutThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.logSystemErrThread != null) {
            try {
                this.logSystemErrThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String[] getStartEnvironmentParams() {
        return null;
    }

    public File getStartDirectory() {
        return null;
    }

    public void logStartDirectory() {
        LogPage logPage;
        File startDirectory;
        if (this.logStartDirectory && (startDirectory = this.starter.getStartDirectory()) != null && (logPage = this.getLogPage()) != null) {
            logPage.log((Object)(startDirectory + ">\n"));
        }
    }

    public String[] getStartCommand() {
        return null;
    }

    public void logCommandString(String[] command) {
        LogPage logPage = this.getLogPage();
        if (logPage != null) {
            if (this.logCommandString) {
                String logCommand = this.fixCommandStringForLog(command);
                logPage.log((Object)(logCommand + "\n"));
            } else {
                logPage.log((Object)"");
            }
        }
    }

    protected String fixCommandStringForLog(String[] command) {
        StringBuffer commandBuffer = new StringBuffer();
        int i = 0;
        while (i < command.length) {
            if (commandBuffer.length() > 0) {
                commandBuffer.append(' ');
            }
            if (!(!command[i].equals("") && command[i].indexOf(32) < 0 && command[i].indexOf(9) < 0 || command[i].startsWith("\"") && command[i].endsWith("\""))) {
                commandBuffer.append('\"');
                commandBuffer.append(command[i]);
                commandBuffer.append('\"');
            } else {
                commandBuffer.append(command[i]);
            }
            ++i;
        }
        return commandBuffer.toString();
    }

    public boolean showStartStatus() {
        return this.showStartStatus;
    }

    protected boolean getUseLogPage() {
        return this.useLogPage;
    }

    public void setUseLogPage(boolean useLogPage) {
        this.useLogPage = useLogPage;
    }

    public LogPage getLogPage() {
        return this.getLogPage(true);
    }

    public LogPage getLogPage(boolean create) {
        if (!this.getUseLogPage()) {
            return null;
        }
        if (this.logPage == null) {
            this.logPage = this.makeLogPage(create);
        }
        return this.logPage;
    }

    protected LogPage makeLogPage(boolean create) {
        if (this.logPageOverride != null) {
            return this.logPageOverride;
        }
        return RunLogPage.makePage(this, create);
    }

    protected boolean reuseLogPage(RunLogPage runLogPage) {
        block7: {
            Boolean reuse;
            if (!this.getUseLogPage()) {
                return false;
            }
            if (this.starter != null && (reuse = this.starter.reuseLogPage(runLogPage)) != null) {
                return reuse;
            }
            if (runLogPage.isProcessAlive() || !ModelUtil.areEqual((Object)this.getShortLabel(), (Object)runLogPage.getName()) || this.getWorkspace() != runLogPage.getWorkspace() || this.getProject() != runLogPage.getProject() || this.getIcon() != runLogPage.getTabIcon()) break block7;
            if (ModelUtil.areEqual((Object)this.getToolTipText(), (Object)runLogPage.getToolTipText())) {
                if (ModelUtil.areEqual((Object)this.getShortLabelWithPrefix(), (Object)runLogPage.getTitleName())) {
                    if (this.getHelpInfo() == null || ModelUtil.areEqual((Object)this.getHelpInfo(), (Object)runLogPage.getHelpInfo())) {
                        return true;
                    }
                    Assert.println((String)"RunLogPage not reused because helpinfo is different.");
                } else {
                    Assert.println((String)"RunLogPage not reused because title is different.");
                }
            } else {
                Assert.println((String)"RunLogPage not reused because tooltip is different.");
            }
        }
        return false;
    }

    public boolean inheritLogPage(RunProcess rp) {
        if (this.logPage == null) {
            this.logPage = rp.logPage;
            return true;
        }
        return false;
    }

    public void log(Object msg) {
        LogPage lp = this.getLogPage();
        if (lp == null) {
            return;
        }
        if (lp instanceof RunLogPage) {
            ((RunLogPage)lp).logMessageFromRunner(msg);
        } else {
            lp.log(msg);
        }
    }

    public boolean doUILater() {
        return false;
    }

    protected void doUI(Runnable r) {
        if (this.doUILater()) {
            SwingUtilities.invokeLater(r);
        } else {
            IdeUtil.runNow((Runnable)r);
        }
    }

    public boolean suppressDirectoryDefault() {
        return false;
    }

    public abstract String getProcessLabelPrefix();

    public IdeLayout getProcessLayout() {
        return null;
    }

    public void selected() {
    }

    public void doubleClicked() {
    }

    public void unselected() {
    }

    public boolean canTerminate() {
        if (this.starter != null) {
            if (this.starter.canTerminateGracefully()) {
                return true;
            }
            return this.starter.canTerminate();
        }
        return false;
    }

    public void terminate() {
        if (this.starter != null) {
            if (this.starter.canTerminateGracefully()) {
                this.starter.terminateGracefully();
            } else if (this.starter.canTerminate()) {
                this.starter.terminate();
            }
        }
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public synchronized void finished() {
        Assert.checkAWTThread();
        if (!this.finished) {
            this.finished = true;
            if (this.processNodeAdded) {
                Runner.getRunner().getProcessesFolder().remove((Element)this);
            }
            if (this.terminateMenuAdded) {
                Runner.getRunner().removeTerminateMenu(this);
            }
            this.redirectInput(null);
            LogPage lp = this.getLogPage();
            if (lp != null && lp instanceof RunLogPage) {
                RunLogPage runLogPage = (RunLogPage)lp;
                runLogPage.finished(this);
            }
            if (this.starter != null) {
                Integer exitCode = this.starter.getExitCode();
                if (this.logExit) {
                    if (exitCode != null) {
                        this.log(RunMgrArb.format((int)11, (Object)exitCode.toString()));
                    } else {
                        this.log(RunMgrArb.getString((int)0));
                    }
                }
                int code = exitCode != null ? exitCode : -1;
                this.notifyRunProcessListener(code);
            }
            IdeMainWindow.updateVisibleActions();
        }
    }

    private void notifyRunProcessListener(int code) {
        RunProcessListener listener = this.runProcessListener;
        if (listener != null) {
            listener.processFinished(code);
        }
    }

    private String prepareLabel(boolean usePrefix, boolean useLong) {
        String s = "";
        if (!this.isPreparingLabel) {
            this.isPreparingLabel = true;
            this.determineTargetAndStarter();
            if (usePrefix || this.getIcon() == null) {
                s = this.getProcessLabelPrefix();
            }
            if (this.labelOverride != null) {
                s = s + this.labelOverride;
            } else {
                Project project = this.getProject();
                if (project != null && project != Ide.getDefaultProject()) {
                    s = s + (useLong ? project.getLongLabel() : project.getShortLabel());
                } else {
                    if ((s = s.trim()).endsWith(":") || s.endsWith("-")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    s = s.trim();
                }
            }
            this.isPreparingLabel = false;
        }
        return s;
    }

    public void setLogPageOverride(LogPage logPageOverride) {
        this.logPageOverride = logPageOverride;
    }

    public void setLabelOverride(String labelOverride) {
        this.labelOverride = labelOverride;
    }

    public void setLabelPrefixOverride(String labelPrefixOverride) {
        this.labelPrefixOverride = labelPrefixOverride;
    }

    public void setIconOverride(Icon iconOverride) {
        this.iconOverride = iconOverride;
    }

    public String getShortLabelWithPrefix() {
        return this.prepareLabel(true, false);
    }

    public String getShortLabel() {
        return this.prepareLabel(false, false);
    }

    public String getLongLabel() {
        return this.prepareLabel(true, true);
    }

    public Object getData() {
        return this;
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public HelpInfo getHelpInfo() {
        return null;
    }

    public String toString() {
        return this.getShortLabel();
    }

    public boolean canStopOnException() {
        return false;
    }

    public boolean canStopOnError() {
        return false;
    }

    public boolean canStopOnDebuggerStatement() {
        return false;
    }

    public boolean canTransferErrors() {
        return false;
    }

    public boolean getStopOnException() {
        return false;
    }

    public boolean getStopOnError() {
        return false;
    }

    public boolean getStopOnDebuggerStatement() {
        return false;
    }

    public boolean getTransferErrors() {
        return false;
    }

    public void setStopOnException(boolean b) {
    }

    public void setStopOnError(boolean b) {
    }

    public void setStopOnDebuggerStatement(boolean b) {
    }

    public void setTransferErrors(boolean b) {
    }

    public boolean getStopInChrome() {
        return false;
    }

    public void doGarbageCollection() {
    }

    public void setStopInChrome(boolean b) {
    }

    public boolean canStopInChrome() {
        return false;
    }

    public boolean canGarbageCollect() {
        return false;
    }

    static void wa$processNodeAdded(RunProcess runProcess, boolean bl) {
        runProcess.processNodeAdded = bl;
    }

    static void wa$terminateMenuAdded(RunProcess runProcess, boolean bl) {
        runProcess.terminateMenuAdded = bl;
    }

    final class oracle.ide.runner.RunProcess$1
    extends Thread {
        public void run() {
            if (RunProcess.this.prepareToStart()) {
                SwingUtilities.invokeLater(new 1());
            }
        }

        public oracle.ide.runner.RunProcess$1(String string) {
            super(string);
        }

        final class 1
        implements Runnable {
            public void run() {
                RunProcess.this.startTarget();
            }
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            RunLogPage runLogPage;
            LogPage lp;
            if (RunProcess.this.addToProcessesFolder) {
                Runner.getRunner().getProcessesFolder().add((Element)RunProcess.this);
                RunProcess.wa$processNodeAdded(RunProcess.this, true);
            }
            if (RunProcess.this.addToTerminateMenu && RunProcess.this.canTerminate()) {
                Runner.getRunner().addTerminateMenu(RunProcess.this);
                RunProcess.wa$terminateMenuAdded(RunProcess.this, true);
            }
            if (RunProcess.this.getUseLogPage() && (lp = RunProcess.this.getLogPage()) instanceof RunLogPage && !(runLogPage = (RunLogPage)lp).started(RunProcess.this)) {
                RunProcess.this.terminate();
            }
        }
    }
}

