/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.io.File;
import java.io.PipedInputStream;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.Starter;

public class SimpleProcess
implements Cloneable {
    private SimpleRunProcess simpleRunProcess = new SimpleRunProcess(null);

    public SimpleProcess() {
    }

    public SimpleProcess(SimpleProcess process) {
        this();
        process.copyTo(this);
    }

    protected Object copyTo(Object o) {
        SimpleProcess other = o != null ? (SimpleProcess)o : new SimpleProcess();
        this.simpleRunProcess.copyTo(other.simpleRunProcess);
        return other;
    }

    public SimpleProcess(String[] cmd) {
        this();
        this.setCommand(cmd);
    }

    public RunProcess getRunProcess() {
        return this.simpleRunProcess;
    }

    public void setCommand(String[] cmd) {
        SimpleRunProcess.mav$setCommand(this.simpleRunProcess, cmd);
    }

    public void setEnvironmentParams(String[] environmentParams) {
        SimpleRunProcess.wa$environmentParams(this.simpleRunProcess, environmentParams);
    }

    public void setUseLogPage(boolean useLogPage) {
        this.simpleRunProcess.useLogPage = useLogPage;
    }

    public void setAllowInput(boolean allowInput) {
        this.simpleRunProcess.allowInput = allowInput;
    }

    public void setWorkingDirectory(File dir) {
        SimpleRunProcess.wa$dir(this.simpleRunProcess, dir);
    }

    public void setLabel(String label) {
        SimpleRunProcess.wa$label(this.simpleRunProcess, label);
    }

    public void setIcon(Icon icon) {
        SimpleRunProcess.wa$icon(this.simpleRunProcess, icon);
    }

    public void setLogPage(LogPage logPageOverride) {
        this.simpleRunProcess.logPageOverride = logPageOverride;
    }

    public void setLogStartDirectory(boolean logStartDirectory) {
        this.simpleRunProcess.logStartDirectory = logStartDirectory;
    }

    public void setLogCommandString(boolean logCommandString) {
        this.simpleRunProcess.logCommandString = logCommandString;
    }

    public void setCommandStringForLog(String commandStringForLog) {
        SimpleRunProcess.wa$commandStringForLog(this.simpleRunProcess, commandStringForLog);
    }

    public void setShowStartStatus(boolean showStartStatus) {
        this.simpleRunProcess.showStartStatus = showStartStatus;
    }

    public void setAddToProcessesFolder(boolean addToProcessesFolder) {
        this.simpleRunProcess.addToProcessesFolder = addToProcessesFolder;
    }

    public void setAddToTerminateMenu(boolean addToTerminateMenu) {
        this.simpleRunProcess.addToTerminateMenu = addToTerminateMenu;
    }

    public void setRunProcessListener(RunProcessListener runProcessListener) {
        this.simpleRunProcess.runProcessListener = runProcessListener;
    }

    public void setDoUILater() {
        SimpleRunProcess.wa$doUILater(this.simpleRunProcess, true);
    }

    public void setSuppressDirectoryDefault() {
        SimpleRunProcess.wa$suppressDirectoryDefault(this.simpleRunProcess, true);
    }

    public PipedInputStream duplicateOutputStream() {
        return this.simpleRunProcess.duplicateOutputStream();
    }

    public PipedInputStream duplicateErrorStream() {
        return this.simpleRunProcess.duplicateErrorStream();
    }

    public void exec() {
        this.simpleRunProcess.start();
    }

    public int execAndWait() {
        SimpleRunProcess.wa$execAndWait(this.simpleRunProcess, true);
        if (!SimpleRunProcess.ra$doUILater(this.simpleRunProcess) && SwingUtilities.isEventDispatchThread()) {
            SimpleRunProcess.wa$doUILater(this.simpleRunProcess, true);
        }
        this.simpleRunProcess.start();
        return SimpleRunProcess.mav$getExitCode(this.simpleRunProcess);
    }

    public Object clone() {
        return new SimpleProcess(this);
    }

    public Exception getExecException() {
        return this.simpleRunProcess.starter.getStartException();
    }

    final class SimpleRunProcess
    extends RunProcess {
        private String[] cmd;
        private String[] environmentParams;
        private File dir;
        private String label;
        private Icon icon;
        private String commandStringForLog;
        private boolean execAndWait;
        private boolean doUILater;
        private boolean suppressDirectoryDefault;

        private SimpleRunProcess() {
            super(new Context());
            this.logStartDirectory = true;
            this.logCommandString = true;
            this.showStartStatus = true;
            this.addToProcessesFolder = true;
            this.addToTerminateMenu = true;
        }

        protected Object copyTo(Object o) {
            SimpleRunProcess other = o != null ? (SimpleRunProcess)o : new SimpleRunProcess();
            super.copyTo(other);
            other.cmd = this.cmd;
            other.environmentParams = this.environmentParams;
            other.dir = this.dir;
            other.label = this.label;
            other.icon = this.icon;
            other.commandStringForLog = this.commandStringForLog;
            other.execAndWait = this.execAndWait;
            other.doUILater = this.doUILater;
            other.suppressDirectoryDefault = this.suppressDirectoryDefault;
            return other;
        }

        private void setCommand(String[] cmd) {
            this.cmd = cmd;
            this.label = cmd != null && cmd.length > 0 ? cmd[0] : "";
        }

        public String getProcessLabelPrefix() {
            return this.label;
        }

        public String getShortLabel() {
            return this.label;
        }

        public String getShortLabelWithPrefix() {
            return this.label;
        }

        public String getLongLabel() {
            return this.label;
        }

        public Icon getIcon() {
            return this.icon;
        }

        protected void determineTargetAndStarter(Class starterFactorySubClass) {
            if (this.starter != null) {
                return;
            }
            this.target = null;
            this.starter = this.getStarterForTarget(this.target);
        }

        protected Starter getStarterForTarget(Node target) {
            return new Starter(this);
        }

        public String[] getStartEnvironmentParams() {
            return this.environmentParams;
        }

        public File getStartDirectory() {
            return this.dir;
        }

        public String[] getStartCommand() {
            return this.cmd;
        }

        public String fixCommandStringForLog(String[] command) {
            if (this.commandStringForLog != null) {
                return this.commandStringForLog;
            }
            return super.fixCommandStringForLog(command);
        }

        protected boolean mustPrepareToStart() {
            boolean mustPrepare = super.mustPrepareToStart();
            if (mustPrepare && this.execAndWait) {
                throw new UnsupportedOperationException("SimpleProcess.execAndWait: mustPrepareToStart is true");
            }
            return mustPrepare;
        }

        public boolean doUILater() {
            return this.doUILater;
        }

        public boolean suppressDirectoryDefault() {
            return this.suppressDirectoryDefault;
        }

        private int getExitCode() {
            if (this.starter != null) {
                return this.starter.waitForProcess();
            }
            return -1;
        }

        static void wa$execAndWait(SimpleRunProcess simpleRunProcess, boolean bl) {
            simpleRunProcess.execAndWait = bl;
        }

        static boolean ra$doUILater(SimpleRunProcess simpleRunProcess) {
            return simpleRunProcess.doUILater;
        }

        static void wa$doUILater(SimpleRunProcess simpleRunProcess, boolean bl) {
            simpleRunProcess.doUILater = bl;
        }

        static int mav$getExitCode(SimpleRunProcess simpleRunProcess) {
            return simpleRunProcess.getExitCode();
        }

        static void wa$suppressDirectoryDefault(SimpleRunProcess simpleRunProcess, boolean bl) {
            simpleRunProcess.suppressDirectoryDefault = bl;
        }

        static void wa$commandStringForLog(SimpleRunProcess simpleRunProcess, String string) {
            simpleRunProcess.commandStringForLog = string;
        }

        static void wa$icon(SimpleRunProcess simpleRunProcess, Icon icon) {
            simpleRunProcess.icon = icon;
        }

        static void wa$label(SimpleRunProcess simpleRunProcess, String string) {
            simpleRunProcess.label = string;
        }

        static void wa$dir(SimpleRunProcess simpleRunProcess, File file) {
            simpleRunProcess.dir = file;
        }

        static void wa$environmentParams(SimpleRunProcess simpleRunProcess, String[] stringArray) {
            simpleRunProcess.environmentParams = stringArray;
        }

        static void mav$setCommand(SimpleRunProcess simpleRunProcess, String[] stringArray) {
            simpleRunProcess.setCommand(stringArray);
        }

        SimpleRunProcess(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

