/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.Assert;
import oracle.ide.util.ExecUtil;

public class Starter {
    protected RunProcess runProcess;
    protected Process process;
    protected Exception startException;
    private volatile ShutdownHookThread shutdownHookThread;
    private Thread waitForProcess;
    private volatile Integer exitCode;
    private volatile boolean terminated;

    protected Starter(RunProcess runProcess) {
        this.runProcess = runProcess;
    }

    public String[] getStartEnvironmentParams() {
        return this.runProcess.getStartEnvironmentParams();
    }

    public File getStartDirectory() {
        return this.runProcess.getStartDirectory();
    }

    public String[] getStartCommand() {
        return this.runProcess.getStartCommand();
    }

    public Boolean reuseLogPage(RunLogPage runLogPage) {
        return null;
    }

    public boolean canStart(List errors) {
        Project project = this.runProcess.getProject();
        if (project == null || project == Ide.getDefaultProject()) {
            String error = RunMgrArb.getString((int)10);
            errors.add(error);
            return false;
        }
        File dir = this.getStartDirectory();
        if (!(dir == null || dir.isDirectory() && dir.exists())) {
            String error = RunMgrArb.format((int)12, (Object)dir.toString());
            errors.add(error);
            return false;
        }
        return true;
    }

    public boolean mustPrepareToStart() {
        return false;
    }

    public boolean prepareToStart() {
        return true;
    }

    private File getStartDirectoryOrProjectDirectory() {
        File dir = this.getStartDirectory();
        if (dir == null && !this.runProcess.suppressDirectoryDefault()) {
            try {
                URL parentURL;
                URL projectURL;
                Project project = this.runProcess.getProject();
                if (project != null && (projectURL = project.getURL()) != null && projectURL.getProtocol().equals("file") && (parentURL = URLFileSystem.getParent((URL)projectURL)) != null) {
                    dir = new File(parentURL.getPath());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return dir;
    }

    public boolean start() {
        Assert.check((this.process == null ? 1 : 0) != 0, (String)"Process already started");
        this.startException = null;
        String[] command = this.getStartCommand();
        if (command != null && command.length > 0) {
            command = ExecUtil.cleanUpCommand((String[])command);
            this.runProcess.logStartDirectory();
            this.runProcess.logCommandString(command);
            int i = 0;
            while (i < command.length) {
                command[i] = ExecUtil.adjustArgument((String)command[i]);
                ++i;
            }
            command = ExecUtil.cleanUpCommand((String[])command);
            if (this.runProcess.showStartStatus()) {
                String status = RunMgrArb.format((int)14, (Object)this.runProcess.getShortLabel());
                Ide.getStatusBar().setText(status);
            }
            Runtime runtime = Runtime.getRuntime();
            try {
                try {
                    this.process = runtime.exec(command, this.getStartEnvironmentParams(), this.getStartDirectoryOrProjectDirectory());
                }
                catch (NoSuchMethodError e) {
                    this.process = runtime.exec(command);
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                this.startException = e;
            }
            if (this.process != null) {
                this.shutdownHookThread = new ShutdownHookThread();
                runtime.addShutdownHook(this.shutdownHookThread);
                this.runProcess.redirectOutput(this.process.getInputStream(), this.process.getErrorStream());
                this.runProcess.redirectInput(this.process.getOutputStream());
                this.waitForProcess = new 1("WaitForProcess");
                this.waitForProcess.start();
            }
        }
        return this.process != null;
    }

    public int waitForProcess() {
        if (this.waitForProcess != null) {
            try {
                this.waitForProcess.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.exitCode != null) {
            return this.exitCode;
        }
        return -1;
    }

    public Integer getExitCode() {
        if (!this.terminated) {
            return this.exitCode;
        }
        return null;
    }

    public Process getProcess() {
        return this.process;
    }

    public Exception getStartException() {
        return this.startException;
    }

    public boolean canTerminateGracefully() {
        return false;
    }

    public void terminateGracefully() {
    }

    public boolean canTerminate() {
        return this.process != null;
    }

    public void terminate() {
        if (this.process != null) {
            this.terminated = true;
            this.process.destroy();
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    this.waitForProcess.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void finished() {
    }

    public boolean isStartAndRemoteDebugging() {
        return false;
    }

    public boolean isStartOnly() {
        return false;
    }

    static ShutdownHookThread ra$shutdownHookThread(Starter starter) {
        return starter.shutdownHookThread;
    }

    static void wa$shutdownHookThread(Starter starter, ShutdownHookThread shutdownHookThread) {
        starter.shutdownHookThread = shutdownHookThread;
    }

    static Integer ra$exitCode(Starter starter) {
        return starter.exitCode;
    }

    static void wa$exitCode(Starter starter, Integer n) {
        starter.exitCode = n;
    }

    final class oracle.ide.runner.Starter$1
    extends Thread {
        public void run() {
            try {
                Starter.wa$exitCode(Starter.this, new Integer(Starter.this.process.waitFor()));
                if (Starter.ra$shutdownHookThread(Starter.this) != null) {
                    ShutdownHookThread.mav$clear(Starter.ra$shutdownHookThread(Starter.this));
                }
                Starter.this.runProcess.finishRedirectOutput();
                SwingUtilities.invokeLater(new 1());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public oracle.ide.runner.Starter$1(String string) {
            super(string);
        }

        final class 1
        implements Runnable {
            public void run() {
                Starter.this.runProcess.finished();
                Starter.this.finished();
            }
        }
    }

    private class ShutdownHookThread
    extends Thread {
        ShutdownHookThread() {
            super("RunnerShutdownHook");
        }

        public void run() {
            Process p;
            Starter.wa$shutdownHookThread(Starter.this, null);
            if (Starter.ra$exitCode(Starter.this) == null && (p = Starter.this.process) != null) {
                p.destroy();
            }
        }

        private void clear() {
            try {
                Runtime.getRuntime().removeShutdownHook(Starter.ra$shutdownHookThread(Starter.this));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.start();
        }

        static void mav$clear(ShutdownHookThread shutdownHookThread) {
            shutdownHookThread.clear();
        }
    }
}

