/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.UpdateMessage;

public abstract class BaseRunnerFolder
extends IdeSubject
implements Folder {
    protected List childNodes;

    protected BaseRunnerFolder() {
    }

    public String toString() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return null;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Object getData() {
        return this;
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public synchronized int countChildren() {
        if (this.childNodes == null) {
            return 0;
        }
        return this.childNodes.size();
    }

    public synchronized Iterator getChildren() {
        if (this.childNodes == null) {
            return null;
        }
        return this.childNodes.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Element element) {
        boolean addOk = false;
        BaseRunnerFolder baseRunnerFolder = this;
        synchronized (baseRunnerFolder) {
            if (this.childNodes == null) {
                this.childNodes = new ArrayList();
            }
            addOk = this.childNodes.add(element);
        }
        if (addOk) {
            UpdateMessage change = new UpdateMessage(UpdateMessage.CHILD_ADDED, null);
            change.getAddObjects().add(element);
            this.notifyObservers((Object)this, change);
        }
        return addOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element element) {
        boolean removeOk = false;
        BaseRunnerFolder baseRunnerFolder = this;
        synchronized (baseRunnerFolder) {
            removeOk = this.childNodes.remove(element);
        }
        if (removeOk) {
            UpdateMessage change = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            change.getRemoveObjects().add(element);
            this.notifyObservers((Object)this, change);
        }
        return removeOk;
    }

    public boolean canAdd(Element element) {
        return false;
    }

    public boolean canRemove(Element element) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsChild(Element child) {
        BaseRunnerFolder baseRunnerFolder = this;
        synchronized (baseRunnerFolder) {
            if (this.childNodes != null) {
                boolean bl = this.childNodes.contains(child);
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        BaseRunnerFolder baseRunnerFolder = this;
        synchronized (baseRunnerFolder) {
            if (this.childNodes != null) {
                int n = this.childNodes.size();
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        BaseRunnerFolder baseRunnerFolder = this;
        synchronized (baseRunnerFolder) {
            if (this.childNodes != null) {
                this.childNodes.clear();
            }
        }
    }
}

