/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import oracle.ide.IdeHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DebuggerHook
extends IdeHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "debugger-hook");
    private static final ElementName OBJECT_EXPRESSION = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-expression");
    private static final ElementName OBJECT_EXPANSION = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-expansion");
    private static final ElementName OBJECT_HIDE_FIELD = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-hide-field");
    private static final ElementName OBJECT_HIDE_ALL_FIELDS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-hide-all-fields");
    private static final ElementName OBJECT_ICON = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-icon");
    private List<ObjectPreferencesExpression> _expressions;
    private final ElementVisitor _objectExpressionVisitor;
    private List<ObjectPreferencesExpansion> _expansions;
    private final ElementVisitor _objectExpansionVisitor;
    private List<ObjectPreferencesHideAllFields> _hideAllFields;
    private final ElementVisitor _objectHideAllFieldsVisitor;
    private List<ObjectPreferencesHideField> _hideFields;
    private final ElementVisitor _objectHideFieldVisitor;
    private List<ObjectPreferencesIcon> _icons;
    private final ElementVisitor _objectIconVisitor;

    private void $init$() {
        this._expressions = new ArrayList<ObjectPreferencesExpression>();
        this._objectExpressionVisitor = new ObjectExpressionVisitor(null);
        this._expansions = new ArrayList<ObjectPreferencesExpansion>();
        this._objectExpansionVisitor = new ObjectExpansionVisitor(null);
        this._hideAllFields = new ArrayList<ObjectPreferencesHideAllFields>();
        this._objectHideAllFieldsVisitor = new ObjectHideAllFieldsVisitor(null);
        this._hideFields = new ArrayList<ObjectPreferencesHideField>();
        this._objectHideFieldVisitor = new ObjectHideFieldVisitor(null);
        this._icons = new ArrayList<ObjectPreferencesIcon>();
        this._objectIconVisitor = new ObjectIconVisitor(null);
    }

    public List<ObjectPreferencesExpression> getExpressions() {
        return this._expressions;
    }

    public List<ObjectPreferencesExpansion> getExpansions() {
        return this._expansions;
    }

    public List<ObjectPreferencesHideAllFields> getHideAllFields() {
        return this._hideAllFields;
    }

    public List<ObjectPreferencesHideField> getHideFields() {
        return this._hideFields;
    }

    public List<ObjectPreferencesIcon> getIcons() {
        return this._icons;
    }

    public void dispose() {
        this._expressions = null;
        this._expansions = null;
        this._hideAllFields = null;
        this._hideFields = null;
        this._icons = null;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(OBJECT_EXPRESSION, this._objectExpressionVisitor);
        context.registerChildVisitor(OBJECT_EXPANSION, this._objectExpansionVisitor);
        context.registerChildVisitor(OBJECT_HIDE_ALL_FIELDS, this._objectHideAllFieldsVisitor);
        context.registerChildVisitor(OBJECT_HIDE_FIELD, this._objectHideFieldVisitor);
        context.registerChildVisitor(OBJECT_ICON, this._objectIconVisitor);
    }

    public DebuggerHook() {
        this.$init$();
    }

    static List ra$_expressions(DebuggerHook debuggerHook) {
        return debuggerHook._expressions;
    }

    static List ra$_expansions(DebuggerHook debuggerHook) {
        return debuggerHook._expansions;
    }

    static List ra$_hideAllFields(DebuggerHook debuggerHook) {
        return debuggerHook._hideAllFields;
    }

    static List ra$_hideFields(DebuggerHook debuggerHook) {
        return debuggerHook._hideFields;
    }

    static List ra$_icons(DebuggerHook debuggerHook) {
        return debuggerHook._icons;
    }

    private final class ObjectExpressionVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            String expression = context.getAttributeValue("expression");
            if (expression == null || expression.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'expression'");
            }
            Boolean selected = Boolean.valueOf(context.getAttributeValue("selected"));
            DebuggerHook.ra$_expressions(DebuggerHook.this).add(new ObjectPreferencesExpression(className, expression, selected, null));
        }

        private ObjectExpressionVisitor() {
        }

        ObjectExpressionVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public static final class ObjectPreferencesExpression {
        private final String _className;
        private final String _expression;
        private final boolean _selected;

        private ObjectPreferencesExpression(String className, String expression, boolean selected) {
            this._className = className;
            this._expression = expression;
            this._selected = selected;
        }

        public String getClassName() {
            return this._className;
        }

        public String getExpression() {
            return this._expression;
        }

        public boolean isSelected() {
            return this._selected;
        }

        ObjectPreferencesExpression(String string, String string2, boolean bl, 1 var4_4) {
            this(string, string2, bl);
        }

        public final class 1 {
        }
    }

    private final class ObjectExpansionVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            String expressions = context.getAttributeValue("expressions");
            if (expressions == null || expressions.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'expressions'");
            }
            Boolean selected = Boolean.valueOf(context.getAttributeValue("selected"));
            DebuggerHook.ra$_expansions(DebuggerHook.this).add(new ObjectPreferencesExpansion(className, expressions, selected, null));
        }

        private ObjectExpansionVisitor() {
        }

        ObjectExpansionVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public static final class ObjectPreferencesExpansion {
        private final String _className;
        private final String _expressions;
        private final boolean _selected;

        private ObjectPreferencesExpansion(String className, String expressions, boolean selected) {
            this._className = className;
            this._expressions = expressions;
            this._selected = selected;
        }

        public String getClassName() {
            return this._className;
        }

        public String getExpressions() {
            return this._expressions;
        }

        public boolean isSelected() {
            return this._selected;
        }

        ObjectPreferencesExpansion(String string, String string2, boolean bl, 1 var4_4) {
            this(string, string2, bl);
        }

        public final class 1 {
        }
    }

    private final class ObjectHideAllFieldsVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            DebuggerHook.ra$_hideAllFields(DebuggerHook.this).add(new ObjectPreferencesHideAllFields(className, null));
        }

        private ObjectHideAllFieldsVisitor() {
        }

        ObjectHideAllFieldsVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public static final class ObjectPreferencesHideAllFields {
        private final String _className;

        private ObjectPreferencesHideAllFields(String className) {
            this._className = className;
        }

        public String getClassName() {
            return this._className;
        }

        ObjectPreferencesHideAllFields(String string, 1 var2_2) {
            this(string);
        }

        public final class 1 {
        }
    }

    private final class ObjectHideFieldVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            String fieldName = context.getAttributeValue("field");
            if (fieldName == null || fieldName.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'field'");
            }
            DebuggerHook.ra$_hideFields(DebuggerHook.this).add(new ObjectPreferencesHideField(className, fieldName, null));
        }

        private ObjectHideFieldVisitor() {
        }

        ObjectHideFieldVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public static final class ObjectPreferencesHideField {
        private final String _className;
        private final String _fieldName;

        private ObjectPreferencesHideField(String className, String fieldName) {
            this._className = className;
            this._fieldName = fieldName;
        }

        public String getClassName() {
            return this._className;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        ObjectPreferencesHideField(String string, String string2, 1 var3_3) {
            this(string, string2);
        }

        public final class 1 {
        }
    }

    public static final class ObjectPreferencesIcon {
        private final String _className;
        private final String _iconName;

        private ObjectPreferencesIcon(String className, String iconName) {
            this._className = className;
            this._iconName = iconName;
        }

        public String getClassName() {
            return this._className;
        }

        public String getIconName() {
            return this._iconName;
        }

        ObjectPreferencesIcon(String string, String string2, 1 var3_3) {
            this(string, string2);
        }

        public final class 1 {
        }
    }

    private final class ObjectIconVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            String iconName = context.getAttributeValue("icon");
            if (iconName == null || iconName.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'icon'");
            }
            DebuggerHook.ra$_icons(DebuggerHook.this).add(new ObjectPreferencesIcon(className, iconName, null));
        }

        private ObjectIconVisitor() {
        }

        ObjectIconVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

