/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.Assert;
import oracle.ideimpl.resource.RunMgrArb;
import oracle.ideimpl.runner.BaseRunnerFolder;
import oracle.ideimpl.runner.RunManager;

final class Processes
extends BaseRunnerFolder {
    private RunManager runManager;
    private boolean calledViewRunManager;

    Processes(RunManager runManager) {
        this.runManager = runManager;
        this.calledViewRunManager = false;
    }

    public String getShortLabel() {
        return RunMgrArb.getString((int)1);
    }

    public Icon getIcon() {
        return RunMgrArb.getIcon((int)14);
    }

    public boolean add(Element element) {
        Assert.checkAWTThread();
        boolean addOk = super.add(element);
        if (addOk) {
            if (element instanceof RunProcess) {
                RunManager.runner.selectProcess((RunProcess)element);
            }
            if (!this.calledViewRunManager && this.countChildren() > 2) {
                RunManager.runner.viewRunManager();
                this.calledViewRunManager = true;
            }
        }
        return addOk;
    }

    public boolean remove(Element element) {
        int i;
        List list;
        RunProcess runProcess;
        Assert.checkAWTThread();
        if (element instanceof RunProcess && this.runManager.isActiveRunProcess(runProcess = (RunProcess)element) && (list = this.getRunProcessesList()).size() > 1 && (i = list.indexOf(runProcess)) != -1) {
            i = i == 0 ? 1 : --i;
            RunProcess next = (RunProcess)list.get(i);
            RunManager.runner.selectProcess(next);
        }
        return super.remove(element);
    }

    private List getRunProcessesList() {
        ArrayList list = new ArrayList();
        Iterator i = this.getChildren();
        if (i != null) {
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof RunProcess)) continue;
                list.add(o);
            }
        }
        return list;
    }

    public RunProcess[] getRunProcesses() {
        List list = this.getRunProcessesList();
        return list.toArray(new RunProcess[list.size()]);
    }
}

