/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layouts;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.panels.Navigable;
import oracle.ide.resource.IdeArb;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.runner.StarterFactory;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.resource.RunMgrArb;
import oracle.ideimpl.runner.BaseRunnerFolder;
import oracle.ideimpl.runner.DebuggerHook;
import oracle.ideimpl.runner.Processes;
import oracle.ideimpl.runner.RunManagerDockableFactory;
import oracle.ideimpl.runner.RunManagerWindow;
import oracle.ideimpl.runner.RunnerBundle;
import oracle.ideimpl.runner.StarterFactoryWrapper;
import oracle.ideri.util.Product;
import oracle.javatools.icons.OracleIcons;

public final class RunManager
extends BaseRunnerFolder
implements ActiveViewListener,
Addin,
ShutdownHook,
IdeListener,
MenuListener,
Controller,
ViewSelectionListener {
    private static RunManager instance;
    static Runner runner;
    private static Map registeredStarterFactories;
    private static List runConfigurationLaunchNavigables;
    private static List runConfigurationToolNavigables;
    private static Map currentTerminateActions;
    private static int countTerminateCommands;
    private static RunManagerWindow runManagerWindow;
    private static Processes processes;
    private static RunProcess activeRunProcess;
    private static IdeAction actionViewRunManager;
    private static IdeAction actionStopOnError;
    private static IdeAction actionStopOnException;
    private static IdeAction actionStopOnDebugger;
    private static IdeAction actionTransferErrors;
    private static IdeAction actionStopInChrome;
    private static IdeAction actionGarbageCollect;
    private static JMenu terminateSubMenu;
    private static JMenuItem emptyItem;
    private static final int VIEW_RUN_MANAGER_CMD_ID;
    private static final String RUN_TERMINATE_CMD_PREFIX = "RunTerminateCommand";
    static final int NAVIGATOR_TERMINATE_CMD_ID;
    static final int VIEW_LOG_CMD_ID;
    static final int RUN_STOP_ON_ERROR_CMD_ID;
    static final int RUN_STOP_ON_EXCEPTION_CMD_ID;
    static final int RUN_STOP_ON_DEBUGGER_CMD_ID;
    static final int RUN_TRANSFER_ERRORS_CMD_ID;
    static final int RUN_STOP_IN_CHROME_CMD_ID;
    static final int RUN_GARBAGE_COLLECT_CMD_ID;
    private boolean addedJSMenus;
    private static final boolean testSimpleProcessExec = false;

    private void $init$() {
        this.addedJSMenus = false;
    }

    public RunManager() throws SingletonClassException {
        this.$init$();
        if (instance != null) {
            throw new SingletonClassException("oracle.ide.runner.RunManager");
        }
        instance = this;
    }

    public String getShortLabel() {
        return RunMgrArb.getString((int)7);
    }

    public void initialize() {
        registeredStarterFactories = new HashMap();
        runConfigurationLaunchNavigables = new ArrayList();
        runConfigurationToolNavigables = new ArrayList();
        runner = new RunnerImpl(null);
        Runner.setRunner(runner);
        new RunManagerDockableFactory();
        this.createActions();
        this.createRunMenus();
        Ide.addIdeListener((IdeListener)this);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public void shutdown() {
        runner.terminate(null, true);
    }

    public boolean canShutdown() {
        return !runner.isRunning(null) || runner.terminate(null, false);
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        DebuggerHook hook = (DebuggerHook)ExtensionRegistry.getExtensionRegistry().getHook(DebuggerHook.ELEMENT);
        Debugger debugger = Debugger.getDebugger();
        for (DebuggerHook.ObjectPreferencesExpression expr : hook.getExpressions()) {
            String cls = expr.getClassName();
            boolean selected = expr.isSelected();
            debugger.addObjectPreferencesExpression(cls, expr.getExpression(), selected);
        }
        for (DebuggerHook.ObjectPreferencesExpansion expansion : hook.getExpansions()) {
            String cls = expansion.getClassName();
            boolean selected = expansion.isSelected();
            String expressions = expansion.getExpressions();
            debugger.addObjectPreferencesExpansion(cls, expressions, selected);
        }
        for (DebuggerHook.ObjectPreferencesHideAllFields hideAllFields : hook.getHideAllFields()) {
            String cls = hideAllFields.getClassName();
            debugger.addObjectPreferencesHideAllFields(cls);
        }
        for (DebuggerHook.ObjectPreferencesHideField hideField : hook.getHideFields()) {
            String cls = hideField.getClassName();
            String fieldName = hideField.getFieldName();
            debugger.addObjectPreferencesHideField(cls, fieldName);
        }
        for (DebuggerHook.ObjectPreferencesIcon icon : hook.getIcons()) {
            String cls = icon.getClassName();
            String iconName = icon.getIconName();
            debugger.addObjectPreferencesIcon(cls, iconName);
        }
        hook.dispose();
    }

    public void mainWindowClosing(IdeEvent e) {
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        JMenu viewMenu;
        Object source = e.getSource();
        if (source == (viewMenu = MenuManager.getJMenu((String)"View"))) {
            viewMenu.removeMenuListener(this);
            Menubar menubar = Ide.getMenubar();
            JMenuItem menuitemViewRunManager = menubar.createMenuItem((ToggleAction)actionViewRunManager, MenuConstants.WEIGHT_VIEW_RUN_MANAGER);
            menubar.add((Component)menuitemViewRunManager, viewMenu, MenuConstants.SECTION_VIEW_DEBUG_RUN);
        }
    }

    public void activeViewChanged(ActiveViewEvent e) {
        RunProcess runProcess;
        View activeView = Ide.getMainWindow().getLastActiveView();
        if (activeView instanceof RunLogPage && (runProcess = ((RunLogPage)activeView).getRunProcess()) != null) {
            runner.selectProcess(runProcess);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        RunProcess runProcess;
        int cmdId = action.getCommandId();
        if (cmdId == VIEW_RUN_MANAGER_CMD_ID) {
            runner.viewRunManager();
            return true;
        }
        if (cmdId == NAVIGATOR_TERMINATE_CMD_ID) {
            Element[] selection = context.getSelection();
            if (selection != null) {
                int length = selection.length;
                int i = 0;
                while (i < length) {
                    Element element = selection[i];
                    if (element instanceof RunProcess) {
                        RunProcess runProcess2 = (RunProcess)element;
                        runProcess2.terminate();
                    }
                    ++i;
                }
            }
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            Element element;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (element = selection[0]) instanceof RunProcess) {
                this.viewLogPage((RunProcess)element, true);
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_ERROR_CMD_ID) {
            Element elem;
            boolean canStopOnError = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess3 = (RunProcess)elem;
                if (runProcess3.canStopOnError()) {
                    canStopOnError = true;
                }
                action.setEnabled(canStopOnError);
                if (canStopOnError) {
                    runProcess3.setStopOnError(runProcess3.getStopOnError() ^ true);
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_EXCEPTION_CMD_ID) {
            Element elem;
            boolean canStopOnException = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess4 = (RunProcess)elem;
                if (runProcess4.canStopOnException()) {
                    canStopOnException = true;
                }
                action.setEnabled(canStopOnException);
                if (canStopOnException) {
                    runProcess4.setStopOnException(runProcess4.getStopOnException() ^ true);
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_DEBUGGER_CMD_ID) {
            Element elem;
            boolean canStopOnDebugger = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess5 = (RunProcess)elem;
                if (runProcess5.canStopOnDebuggerStatement()) {
                    canStopOnDebugger = true;
                }
                action.setEnabled(canStopOnDebugger);
                if (canStopOnDebugger) {
                    runProcess5.setStopOnDebuggerStatement(runProcess5.getStopOnDebuggerStatement() ^ true);
                }
            }
            return true;
        }
        if (cmdId == RUN_TRANSFER_ERRORS_CMD_ID) {
            Element elem;
            boolean canTransferErrors = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess6 = (RunProcess)elem;
                if (runProcess6.canTransferErrors()) {
                    canTransferErrors = true;
                }
                action.setEnabled(canTransferErrors);
                if (canTransferErrors) {
                    runProcess6.setTransferErrors(runProcess6.getTransferErrors() ^ true);
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_IN_CHROME_CMD_ID) {
            Element elem;
            boolean canStopInChrome = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess7 = (RunProcess)elem;
                if (runProcess7.canStopInChrome()) {
                    canStopInChrome = true;
                }
                action.setEnabled(canStopInChrome);
                if (canStopInChrome) {
                    runProcess7.setStopInChrome(runProcess7.getStopInChrome() ^ true);
                }
            }
            return true;
        }
        if (cmdId == RUN_GARBAGE_COLLECT_CMD_ID) {
            Element elem;
            boolean canGarbageCollect = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess8 = (RunProcess)elem;
                if (runProcess8.canGarbageCollect()) {
                    canGarbageCollect = true;
                }
                action.setEnabled(canGarbageCollect);
                if (canGarbageCollect) {
                    runProcess8.doGarbageCollection();
                }
            }
            return true;
        }
        if (currentTerminateActions != null && (runProcess = (RunProcess)currentTerminateActions.get(action)) != null) {
            runProcess.terminate();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        RunProcess runProcess;
        int cmdId = action.getCommandId();
        if (cmdId == VIEW_RUN_MANAGER_CMD_ID) {
            return true;
        }
        if (cmdId == NAVIGATOR_TERMINATE_CMD_ID) {
            int length;
            boolean canTerminate = false;
            Element[] selection = context.getSelection();
            if (selection != null && (length = selection.length) > 0) {
                int countCanTerminate = 0;
                int i = 0;
                while (i < length) {
                    RunProcess runProcess2;
                    Element element = selection[i];
                    if (element instanceof RunProcess && (runProcess2 = (RunProcess)element).canTerminate()) {
                        ++countCanTerminate;
                    }
                    ++i;
                }
                if (countCanTerminate == length) {
                    canTerminate = true;
                }
            }
            action.setEnabled(canTerminate);
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            boolean canView = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1) {
                canView = selection[0] instanceof RunProcess;
            }
            action.setEnabled(canView);
            return true;
        }
        if (cmdId == RUN_STOP_ON_ERROR_CMD_ID) {
            Element elem;
            boolean canStopOnError = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess3 = (RunProcess)elem;
                if (runProcess3.canStopOnError()) {
                    canStopOnError = true;
                }
                action.setEnabled(canStopOnError);
                if (canStopOnError) {
                    if (runProcess3.getStopOnError()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_EXCEPTION_CMD_ID) {
            Element elem;
            boolean canStopOnException = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess4 = (RunProcess)elem;
                if (runProcess4.canStopOnException()) {
                    canStopOnException = true;
                }
                action.setEnabled(canStopOnException);
                if (canStopOnException) {
                    if (runProcess4.getStopOnException()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_DEBUGGER_CMD_ID) {
            Element elem;
            boolean canStopOnDebugger = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess5 = (RunProcess)elem;
                if (runProcess5.canStopOnDebuggerStatement()) {
                    canStopOnDebugger = true;
                }
                action.setEnabled(canStopOnDebugger);
                if (canStopOnDebugger) {
                    if (runProcess5.getStopOnDebuggerStatement()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_TRANSFER_ERRORS_CMD_ID) {
            Element elem;
            boolean canTransferErrors = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess6 = (RunProcess)elem;
                if (runProcess6.canTransferErrors()) {
                    canTransferErrors = true;
                }
                action.setEnabled(canTransferErrors);
                if (canTransferErrors) {
                    if (runProcess6.getTransferErrors()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_IN_CHROME_CMD_ID) {
            Element elem;
            boolean canStopInChrome = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess7 = (RunProcess)elem;
                if (runProcess7.canStopInChrome()) {
                    canStopInChrome = true;
                }
                action.setEnabled(canStopInChrome);
                if (canStopInChrome) {
                    if (runProcess7.getStopInChrome()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_GARBAGE_COLLECT_CMD_ID) {
            Element elem;
            boolean canGarbageCollect = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess8 = (RunProcess)elem;
                if (runProcess8.canGarbageCollect()) {
                    canGarbageCollect = true;
                }
                action.setEnabled(canGarbageCollect);
            }
            return true;
        }
        if (currentTerminateActions != null && (runProcess = (RunProcess)currentTerminateActions.get(action)) != null) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        Element element;
        Element[] sel;
        RunProcess newActiveRunProcess = null;
        Context context = runner.getRunManagerWindow().getContext();
        if (context != null && (sel = context.getSelection()) != null && sel.length > 0 && (element = sel[sel.length - 1]) instanceof RunProcess) {
            newActiveRunProcess = (RunProcess)element;
        }
        RunProcess prevActiveRunProcess = activeRunProcess;
        if (activeRunProcess != null) {
            activeRunProcess.unselected();
            activeRunProcess = null;
        }
        if (newActiveRunProcess != null) {
            if (prevActiveRunProcess == null || !prevActiveRunProcess.hasFinished()) {
                this.viewLogPage(newActiveRunProcess, false);
            }
            activeRunProcess = newActiveRunProcess;
            activeRunProcess.selected();
        }
        View activeView = Ide.getMainWindow().getLastActiveView();
        Dockable activeDockable = null;
        View view = activeView;
        while (view != null) {
            if (view instanceof Dockable) {
                activeDockable = (Dockable)view;
                break;
            }
            view = view.owner();
        }
        Layouts layouts = Layouts.getLayouts();
        IdeLayout layout = null;
        if (activeRunProcess != null) {
            layout = activeRunProcess.getProcessLayout();
            if (layout == null) {
                layout = layouts.getDesignLayout();
            }
        } else if (processes.countChildren() == 0) {
            layout = layouts.getDesignLayout();
        }
        if (layout != null && !layout.equals((Object)layouts.getActiveLayout())) {
            layouts.activateLayout(layout);
        }
        if ((activeView instanceof RunManagerWindow || activeView instanceof LogPage) && !activeView.isVisible() && activeDockable != null) {
            DockStation.getDockStation().setDockableVisible(activeDockable, true);
        }
    }

    public void addJSMenus() {
        if (this.addedJSMenus) {
            return;
        }
        this.addedJSMenus = true;
        actionStopOnError = IdeAction.get((int)RUN_STOP_ON_ERROR_CMD_ID, null, (String)IdeArb.getString((int)272), null, (Integer)IdeArb.getInteger((int)287), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionStopOnError.putValue("Check", (Object)true);
        actionStopOnError.addController((Controller)this);
        actionStopOnException = IdeAction.get((int)RUN_STOP_ON_EXCEPTION_CMD_ID, null, (String)IdeArb.getString((int)366), null, (Integer)IdeArb.getInteger((int)384), (ResourceBundle)IdeArb.getInstance(), (String)"", null, (boolean)true);
        actionStopOnException.putValue("Check", (Object)true);
        actionStopOnException.addController((Controller)this);
        actionStopOnDebugger = IdeAction.get((int)RUN_STOP_ON_DEBUGGER_CMD_ID, null, (String)IdeArb.getString((int)267), null, (Integer)IdeArb.getInteger((int)346), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionStopOnDebugger.putValue("Check", (Object)true);
        actionStopOnDebugger.addController((Controller)this);
        actionTransferErrors = IdeAction.get((int)RUN_TRANSFER_ERRORS_CMD_ID, null, (String)IdeArb.getString((int)379), null, (Integer)IdeArb.getInteger((int)212), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionTransferErrors.putValue("Check", (Object)true);
        actionTransferErrors.addController((Controller)this);
        actionStopInChrome = IdeAction.get((int)RUN_STOP_IN_CHROME_CMD_ID, null, (String)IdeArb.getString((int)484), null, (Integer)IdeArb.getInteger((int)460), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionStopInChrome.putValue("Check", (Object)true);
        actionStopInChrome.addController((Controller)this);
        actionGarbageCollect = IdeAction.get((int)RUN_GARBAGE_COLLECT_CMD_ID, null, (String)IdeArb.getString((int)470), null, (Integer)IdeArb.getInteger((int)358), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionGarbageCollect.addController((Controller)this);
    }

    private void createActions() {
        String ACTION_CATEGORY_VIEW = IdeMainWindow.ACTION_CATEGORY_VIEW;
        actionViewRunManager = IdeAction.get((int)VIEW_RUN_MANAGER_CMD_ID, null, (String)RunMgrArb.getString((int)12), (String)ACTION_CATEGORY_VIEW, (Integer)RunMgrArb.getInteger((int)2), (ArrayResourceBundle)RunMgrArb.getInstance(), (int)6, null, (boolean)true);
        actionViewRunManager.addController((Controller)this);
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        viewMenu.addMenuListener(this);
        IdeAction actionNavigatorTerminate = IdeAction.get((int)NAVIGATOR_TERMINATE_CMD_ID, null, (String)IdeArb.getString((int)92), null, (Integer)IdeArb.getInteger((int)424), (ArrayResourceBundle)IdeArb.getInstance(), (int)343, null, (boolean)true);
        actionNavigatorTerminate.addController((Controller)this);
        IdeAction actionViewLog = IdeAction.get((int)VIEW_LOG_CMD_ID, null, (String)RunMgrArb.getString((int)8), (String)ACTION_CATEGORY_VIEW, (Integer)RunMgrArb.getInteger((int)9), (Icon)OracleIcons.getIcon((String)"log.png"), null, (boolean)false);
        actionViewLog.addController((Controller)this);
        this.addJSMenus();
    }

    private void createRunMenus() {
        Menubar menuMgr = Ide.getMenubar();
        JMenu runMenu = MenuManager.getJMenu((String)"Run");
        if (runMenu == null) {
            String runMenuLabel = RunnerBundle.get("RUN_MENU");
            runMenu = menuMgr.createMenu(StringUtils.stripMnemonic((String)runMenuLabel), new Integer(StringUtils.getMnemonicKeyCode((String)runMenuLabel)), MenuConstants.WEIGHT_RUN_MENU, MenuConstants.SECTION_RUN_ADDINS);
            menuMgr.add((Component)runMenu);
            MenuManager.putJMenu((String)"Run", (JMenu)runMenu);
        }
        menuMgr.add((Component)runMenu);
        terminateSubMenu = menuMgr.createSubMenu(IdeArb.getString((int)92), IdeArb.getInteger((int)424), MenuConstants.WEIGHT_RUN_TERMINATE);
        emptyItem = new JMenuItem(IdeArb.getString((int)368));
        emptyItem.setEnabled(false);
        terminateSubMenu.add(emptyItem);
        terminateSubMenu.setEnabled(false);
        if (!Product.isRaptor()) {
            menuMgr.add((Component)terminateSubMenu, runMenu, MenuConstants.SECTION_RUN_TERMINATE);
        }
    }

    boolean isActiveRunProcess(RunProcess runProcess) {
        return runProcess.equals(activeRunProcess);
    }

    private void viewLogPage(RunProcess runProcess, boolean raise) {
        LogPage lp = runProcess.getLogPage();
        if (lp instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            if (raise) {
                runLogPage.show();
            } else {
                runLogPage.showPage();
            }
        }
    }

    static {
        VIEW_RUN_MANAGER_CMD_ID = Ide.findOrCreateCmdID((String)"ViewRunManager");
        NAVIGATOR_TERMINATE_CMD_ID = Ide.findOrCreateCmdID((String)"TerminateCommand");
        VIEW_LOG_CMD_ID = Ide.findOrCreateCmdID((String)"RunManagerViewLogCommand");
        RUN_STOP_ON_ERROR_CMD_ID = Ide.findOrCreateCmdID((String)"JSStopOnError");
        RUN_STOP_ON_EXCEPTION_CMD_ID = Ide.findOrCreateCmdID((String)"JSStopOnException");
        RUN_STOP_ON_DEBUGGER_CMD_ID = Ide.findOrCreateCmdID((String)"JSStopOnDebuggerStatement");
        RUN_TRANSFER_ERRORS_CMD_ID = Ide.findOrCreateCmdID((String)"JSTransferErrors");
        RUN_STOP_IN_CHROME_CMD_ID = Ide.findOrCreateCmdID((String)"JSStopInChrome");
        RUN_GARBAGE_COLLECT_CMD_ID = Ide.findOrCreateCmdID((String)"JSGarbageCollect");
    }

    static List ra$runConfigurationToolNavigables() {
        return runConfigurationToolNavigables;
    }

    static List ra$runConfigurationLaunchNavigables() {
        return runConfigurationLaunchNavigables;
    }

    static Map ra$registeredStarterFactories() {
        return registeredStarterFactories;
    }

    static Map ra$currentTerminateActions() {
        return currentTerminateActions;
    }

    static JMenu ra$terminateSubMenu() {
        return terminateSubMenu;
    }

    static JMenuItem ra$emptyItem() {
        return emptyItem;
    }

    static void wa$currentTerminateActions(Map map) {
        currentTerminateActions = map;
    }

    static int ra$countTerminateCommands() {
        return countTerminateCommands;
    }

    static void wa$countTerminateCommands(int n) {
        countTerminateCommands = n;
    }

    static IdeAction ra$actionViewRunManager() {
        return actionViewRunManager;
    }

    static RunManagerWindow ra$runManagerWindow() {
        return runManagerWindow;
    }

    static Processes ra$processes() {
        return processes;
    }

    static void wa$processes(Processes processes) {
        RunManager.processes = processes;
    }

    static void wa$runManagerWindow(RunManagerWindow runManagerWindow) {
        RunManager.runManagerWindow = runManagerWindow;
    }

    private class RunnerImpl
    extends Runner {
        public boolean isRunning(Project project) {
            if (RunManager.ra$processes() != null) {
                RunProcess[] runProcesses = RunManager.ra$processes().getRunProcesses();
                int length = runProcesses.length;
                int i = 0;
                while (i < length) {
                    RunProcess runProcess = runProcesses[i];
                    if (project == null || project == runProcess.getProject()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public boolean terminate(Project project, boolean force) {
            if (RunManager.ra$processes() != null) {
                ArrayList<RunProcess> temp = new ArrayList<RunProcess>();
                RunProcess[] runProcesses = RunManager.ra$processes().getRunProcesses();
                int length = runProcesses.length;
                int i = 0;
                while (i < length) {
                    RunProcess runProcess = runProcesses[i];
                    if (project == null || project == runProcess.getProject()) {
                        temp.add(runProcess);
                    }
                    ++i;
                }
                length = temp.size();
                if (length > 0) {
                    boolean kill;
                    if (force) {
                        kill = true;
                    } else {
                        String title;
                        Object[] messages = new Object[1 + length];
                        int im = 0;
                        if (length == 1) {
                            messages[im++] = RunMgrArb.getString((int)11);
                            title = RunMgrArb.getString((int)4);
                        } else {
                            messages[im++] = RunMgrArb.getString((int)10);
                            title = RunMgrArb.getString((int)3);
                        }
                        for (RunProcess runProcess : temp) {
                            JLabel label = new JLabel(runProcess.getShortLabel(), runProcess.getIcon(), 2);
                            messages[im++] = label;
                        }
                        int answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), messages, title, 0, 3);
                        boolean bl = kill = answer == 0;
                    }
                    if (kill) {
                        for (RunProcess runProcess : temp) {
                            runProcess.terminate();
                        }
                        Layouts layouts = Layouts.getLayouts();
                        layouts.activateLayout(layouts.getDesignLayout());
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }

        public JMenu getRunMenu() {
            return MenuManager.getJMenu((String)"Run");
        }

        public synchronized NavigatorWindow getRunManagerWindow() {
            if (RunManager.ra$runManagerWindow() == null) {
                Context context = Context.newIdeContext((Element)RunManager.this);
                context.setProject(null);
                context.setWorkspace(null);
                RunManager.wa$runManagerWindow(new RunManagerWindow(context, RunManager.this));
                RunManager.ra$runManagerWindow().setToolbarVisible(true);
                RunManager.ra$runManagerWindow().addViewSelectionListener(RunManager.this);
                this.getProcessesFolder();
            }
            return RunManager.ra$runManagerWindow();
        }

        public Folder getRunManagerFolder() {
            this.getRunManagerWindow();
            return RunManager.this;
        }

        public synchronized Folder getProcessesFolder() {
            if (RunManager.ra$processes() == null) {
                try {
                    RunManager.wa$processes(new Processes(RunManager.this));
                    this.getRunManagerFolder().add((Element)RunManager.ra$processes());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return RunManager.ra$processes();
        }

        public void viewRunManager() {
            DockUtil.showDockableWindow((DockableView)this.getRunManagerWindow());
        }

        public boolean isRunManagerVisible() {
            if (RunManager.ra$runManagerWindow() == null) {
                return false;
            }
            return RunManager.ra$runManagerWindow().isVisible();
        }

        public IdeAction getViewRunManagerAction() {
            return RunManager.ra$actionViewRunManager();
        }

        public boolean selectProcess(RunProcess runProcess) {
            return ((RunManagerWindow)this.getRunManagerWindow()).selectProcess(runProcess);
        }

        public void addTerminateMenu(RunProcess runProcess) {
            if (RunManager.ra$currentTerminateActions() == null) {
                RunManager.wa$currentTerminateActions(new HashMap(10));
            }
            RunManager.wa$countTerminateCommands(RunManager.ra$countTerminateCommands() + 1);
            int cmdId = Ide.findOrCreateCmdID((String)(RunManager.RUN_TERMINATE_CMD_PREFIX + RunManager.ra$countTerminateCommands()));
            IdeAction terminateAction = IdeAction.get((int)cmdId, null, (String)runProcess.getShortLabel(), (String)null, null, (Icon)runProcess.getIcon(), null, (boolean)true);
            terminateAction.addController((Controller)RunManager.this);
            RunManager.ra$currentTerminateActions().put(terminateAction, runProcess);
            if (RunManager.ra$terminateSubMenu().getItem(0) == RunManager.ra$emptyItem()) {
                RunManager.ra$terminateSubMenu().remove(0);
            }
            RunManager.ra$terminateSubMenu().setEnabled(true);
            JMenuItem menuItem = Ide.getMenubar().createMenuItem((ToggleAction)terminateAction);
            RunManager.ra$terminateSubMenu().add(menuItem);
            terminateAction.putValue("UserData", (Object)menuItem);
        }

        public void removeTerminateMenu(RunProcess runProcess) {
            Assert.check((RunManager.ra$currentTerminateActions() != null ? 1 : 0) != 0);
            for (IdeAction terminateAction : RunManager.ra$currentTerminateActions().keySet()) {
                if (!RunManager.ra$currentTerminateActions().get(terminateAction).equals(runProcess)) continue;
                RunManager.ra$currentTerminateActions().remove(terminateAction);
                JMenuItem menuItem = (JMenuItem)terminateAction.getValue("UserData");
                RunManager.ra$terminateSubMenu().remove(menuItem);
                menuItem.setAction(null);
                terminateAction.putValue("UserData", null);
                terminateAction.removeController((Controller)RunManager.this);
                IdeAction.remove((int)terminateAction.getCommandId());
                if (RunManager.ra$terminateSubMenu().getItemCount() != 0) break;
                RunManager.ra$terminateSubMenu().add(RunManager.ra$emptyItem());
                RunManager.ra$terminateSubMenu().setEnabled(false);
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerStarterFactory(Class targetClass, StarterFactory starterFactory) {
            if (!(starterFactory instanceof AbstractStarterFactory)) {
                starterFactory = new StarterFactoryWrapper(starterFactory);
            }
            if (((AbstractStarterFactory)starterFactory).canBeRegistered()) {
                Map map = RunManager.ra$registeredStarterFactories();
                synchronized (map) {
                    ArrayList<StarterFactory> factories = (ArrayList<StarterFactory>)RunManager.ra$registeredStarterFactories().get(targetClass);
                    if (factories == null) {
                        factories = new ArrayList<StarterFactory>();
                        RunManager.ra$registeredStarterFactories().put(targetClass, factories);
                    }
                    factories.add(0, starterFactory);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterStarterFactory(Class targetClass, StarterFactory starterFactory) {
            Map map = RunManager.ra$registeredStarterFactories();
            synchronized (map) {
                List factories = (List)RunManager.ra$registeredStarterFactories().get(targetClass);
                if (factories != null) {
                    if (!factories.remove(starterFactory)) {
                        for (Object o : factories) {
                            if (!(o instanceof StarterFactoryWrapper) || !((StarterFactoryWrapper)o).getStarterFactory().equals(starterFactory)) continue;
                            factories.remove(o);
                            break;
                        }
                    }
                    if (factories.isEmpty()) {
                        RunManager.ra$registeredStarterFactories().remove(targetClass);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class[] getClassesWithRegisteredStarterFactory() {
            Map map = RunManager.ra$registeredStarterFactories();
            synchronized (map) {
                Class[] classArray = RunManager.ra$registeredStarterFactories().keySet().toArray(new Class[RunManager.ra$registeredStarterFactories().size()]);
                return classArray;
            }
        }

        public AbstractStarterFactory[] getRegisteredStarterFactories(Class targetClass) {
            return this.getRegisteredStarterFactories(targetClass, null);
        }

        private boolean checkStarterFactorySubClass(Class starterFactorySubClass, Object starterFactory) {
            if (starterFactorySubClass == null) {
                return true;
            }
            if (starterFactorySubClass.isAssignableFrom(starterFactory.getClass())) {
                return true;
            }
            if (starterFactory instanceof StarterFactoryWrapper) {
                return this.checkStarterFactorySubClass(starterFactorySubClass, ((StarterFactoryWrapper)starterFactory).getStarterFactory());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractStarterFactory[] getRegisteredStarterFactories(Class targetClass, Class starterFactorySubClass) {
            Map map = RunManager.ra$registeredStarterFactories();
            synchronized (map) {
                ArrayList list = new ArrayList();
                List factories = (List)RunManager.ra$registeredStarterFactories().get(targetClass);
                for (Object starterFactory : factories) {
                    if (!this.checkStarterFactorySubClass(starterFactorySubClass, starterFactory)) continue;
                    list.add(starterFactory);
                }
                AbstractStarterFactory[] abstractStarterFactoryArray = list.toArray(new AbstractStarterFactory[list.size()]);
                return abstractStarterFactoryArray;
            }
        }

        public AbstractStarterFactory[] getStarterFactoriesForTarget(Class targetClass) {
            return this.getStarterFactoriesForTarget(targetClass, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractStarterFactory[] getStarterFactoriesForTarget(Class targetClass, Class starterFactorySubClass) {
            Map map = RunManager.ra$registeredStarterFactories();
            synchronized (map) {
                ArrayList list = new ArrayList();
                for (Class registeredClass : RunManager.ra$registeredStarterFactories().keySet()) {
                    if (!registeredClass.isAssignableFrom(targetClass)) continue;
                    List factories = (List)RunManager.ra$registeredStarterFactories().get(registeredClass);
                    for (Object starterFactory : factories) {
                        if (!this.checkStarterFactorySubClass(starterFactorySubClass, starterFactory)) continue;
                        list.add(starterFactory);
                    }
                }
                AbstractStarterFactory[] abstractStarterFactoryArray = list.toArray(new AbstractStarterFactory[list.size()]);
                return abstractStarterFactoryArray;
            }
        }

        public boolean couldNodeBeRunnable(Node node) {
            return this.couldNodeBeRunnable(node, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean couldNodeBeRunnable(Node node, Class starterFactorySubClass) {
            if (node != null) {
                Class targetClass = node.getClass();
                Map map = RunManager.ra$registeredStarterFactories();
                synchronized (map) {
                    for (Class registeredClass : RunManager.ra$registeredStarterFactories().keySet()) {
                        if (!registeredClass.isAssignableFrom(targetClass)) continue;
                        List factories = (List)RunManager.ra$registeredStarterFactories().get(registeredClass);
                        for (Object starterFactory : factories) {
                            if (!this.checkStarterFactorySubClass(starterFactorySubClass, starterFactory)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean enableRunDebugActions(Context context, Class starterFactorySubClass) {
            Node node = RunProcess.getContextNodeForRun(context);
            if (node != null) {
                if (node instanceof Project && node == context.getProject()) {
                    return true;
                }
                Class targetClass = node.getClass();
                Map map = RunManager.ra$registeredStarterFactories();
                synchronized (map) {
                    for (Class registeredClass : RunManager.ra$registeredStarterFactories().keySet()) {
                        if (!registeredClass.isAssignableFrom(targetClass)) continue;
                        List factories = (List)RunManager.ra$registeredStarterFactories().get(registeredClass);
                        for (Object starterFactory : factories) {
                            AbstractStarterFactory abstractStarterFactory;
                            if (!this.checkStarterFactorySubClass(starterFactorySubClass, starterFactory) || !(abstractStarterFactory = (AbstractStarterFactory)starterFactory).enableRunDebugActions(context)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            return false;
        }

        public Navigable getProjectSettingsRunnerNavigable() {
            return null;
        }

        public void setProjectSettingsRunnerNavigable(Navigable navigable) {
        }

        public void addRunConfigurationLaunchNavigable(Navigable navigable) {
            RunManager.ra$runConfigurationLaunchNavigables().add(navigable);
        }

        public Navigable[] getRunConfigurationLaunchNavigables() {
            return RunManager.ra$runConfigurationLaunchNavigables().toArray(new Navigable[RunManager.ra$runConfigurationLaunchNavigables().size()]);
        }

        public void addRunConfigurationToolNavigable(Navigable navigable) {
            RunManager.ra$runConfigurationToolNavigables().add(navigable);
        }

        public Navigable[] getRunConfigurationToolNavigables() {
            return RunManager.ra$runConfigurationToolNavigables().toArray(new Navigable[RunManager.ra$runConfigurationToolNavigables().size()]);
        }

        private RunnerImpl() {
        }

        RunnerImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

