/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.awt.Component;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorConstants;
import oracle.ide.runner.RunProcess;
import oracle.ideimpl.runner.RunManager;
import oracle.ideimpl.runner.RunManagerWindow;

final class RunnerContextMenuListener
implements ContextMenuListener {
    private RunManager getRunManager() {
        return (RunManager)AddinManager.getAddinManager().getAddin(RunManager.class);
    }

    private IdeAction getTerminateAction() {
        return IdeAction.find((int)RunManager.NAVIGATOR_TERMINATE_CMD_ID);
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        RunManager runManager = this.getRunManager();
        if (context != null && context.getView() instanceof RunManagerWindow) {
            NavigatorConstants.removeNewMenuItem((ContextMenu)popup);
        }
        runManager.update(this.getTerminateAction(), context);
        if (this.getTerminateAction().isEnabled()) {
            popup.add((Component)popup.createMenuItem((ToggleAction)this.getTerminateAction()));
        }
        if (context != null && context.getView().getId().equals("RunManagerWindow")) {
            IdeAction garbageCollect;
            IdeAction stopInChrome;
            IdeAction transferErrors;
            IdeAction stopOnDebugger;
            IdeAction stopOnException;
            IdeAction stopOnError;
            IdeAction viewLog = IdeAction.find((int)RunManager.VIEW_LOG_CMD_ID);
            if (viewLog != null) {
                runManager.update(viewLog, context);
                if (viewLog.isEnabled()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)viewLog));
                }
            }
            if ((stopOnError = IdeAction.find((int)RunManager.RUN_STOP_ON_ERROR_CMD_ID)) != null) {
                runManager.update(stopOnError, context);
                if (stopOnError.isEnabled()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)stopOnError));
                }
            }
            if ((stopOnException = IdeAction.find((int)RunManager.RUN_STOP_ON_EXCEPTION_CMD_ID)) != null) {
                runManager.update(stopOnException, context);
                if (stopOnException.isEnabled()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)stopOnException));
                }
            }
            if ((stopOnDebugger = IdeAction.find((int)RunManager.RUN_STOP_ON_DEBUGGER_CMD_ID)) != null) {
                runManager.update(stopOnDebugger, context);
                if (stopOnDebugger.isEnabled()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)stopOnDebugger));
                }
            }
            if ((transferErrors = IdeAction.find((int)RunManager.RUN_TRANSFER_ERRORS_CMD_ID)) != null) {
                runManager.update(transferErrors, context);
                if (transferErrors.isEnabled()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)transferErrors));
                }
            }
            if ((stopInChrome = IdeAction.find((int)RunManager.RUN_STOP_IN_CHROME_CMD_ID)) != null) {
                runManager.update(stopInChrome, context);
                if (stopInChrome.isEnabled()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)stopInChrome));
                }
            }
            if ((garbageCollect = IdeAction.find((int)RunManager.RUN_GARBAGE_COLLECT_CMD_ID)) != null) {
                runManager.update(garbageCollect, context);
                if (garbageCollect.isEnabled()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)garbageCollect));
                }
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        Element element;
        Element[] sel;
        if (context != null && (sel = context.getSelection()) != null && sel.length > 0 && (element = sel[sel.length - 1]) instanceof RunProcess) {
            RunProcess runProcess = (RunProcess)element;
            runProcess.doubleClicked();
            return true;
        }
        return false;
    }

    RunnerContextMenuListener() {
    }
}

