/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.awt.Component;
import java.util.EventObject;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ideimpl.db.explorer.DBExplorerArb;

public abstract class BaseCMExplorer
extends Explorer
implements Observer,
Runnable {
    private static final String TIMING_KEY = "BaseCMExplorer.TIMING_KEY";
    private JTree _tree;
    private JScrollPane _scrollPane;
    private boolean _observing;
    private Node _node;
    private static ThreadPoolExecutor s_pool;

    protected BaseCMExplorer() {
    }

    public Component getGUI() {
        if (this._tree == null) {
            this.createTree();
            this._scrollPane = new JScrollPane(this._tree);
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._scrollPane;
    }

    public void updateTree() {
        if (this._tree != null) {
            BaseCMExplorer.queue(this);
        }
    }

    public void run() {
        String msg = this.getTitle();
        msg = msg == null ? "BaseCMExplorer.run()" : msg;
        Assert.startTiming((String)TIMING_KEY, (String)msg, (boolean)false);
        if (this._tree != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
            try {
                DefaultMutableTreeNode newRoot = this.buildTree();
                SwingUtilities.invokeLater(new 1(this, treeModel, newRoot));
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            Assert.endTiming((String)TIMING_KEY, (String)msg, (String)"END ", (boolean)false);
        }
    }

    public Context getContext(EventObject event) {
        Context ctx = null;
        ctx = this._node != null ? Context.newIdeContext((Node)this._node) : Context.newIdeContext();
        ctx.setView((View)this);
        return ctx;
    }

    public void setContext(Context context) {
        Node node = context.getNode();
        if (node != null && this.isValidNode(node)) {
            this._node = node;
            this._tree = null;
        }
    }

    public void stateChanged(int state) {
        switch (state) {
            case 0: {
                if (this._node == null) break;
                this.updateTree();
                this.startObserving();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.stopObserving();
                break;
            }
        }
    }

    private boolean isObserving() {
        return this._observing;
    }

    private void startObserving() {
        if (!this._observing && this._node != null) {
            this._node.attach((Observer)this);
            this._observing = true;
        }
    }

    private void stopObserving() {
        if (this._observing && this._node != null) {
            this._node.detach((Observer)this);
            this._observing = false;
        }
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID;
        if (this.isObserving() && this._node != null && observed == this._node && (messageID = change.getMessageID()) != UpdateMessage.CHILD_REMOVED && messageID != UpdateMessage.CHILD_ADDED && messageID != UpdateMessage.PROPERTY_SET && messageID != UpdateMessage.OBJECT_RENAMED && messageID != UpdateMessage.CHILD_RENAMED && messageID != UpdateMessage.OBJECT_OPENED && messageID != UpdateMessage.OBJECT_CLOSED && messageID != UpdateMessage.ATTRIBUTE_CHANGED && messageID != UpdateMessage.OBJECT_CLOSING) {
            this.updateTree();
        }
    }

    protected final Node getNode() {
        return this._node;
    }

    protected abstract boolean isValidNode(Node var1);

    protected abstract DefaultMutableTreeNode buildTree();

    protected String getAccessibleName() {
        return null;
    }

    protected TreeCellRenderer getCellRenderer() {
        return null;
    }

    private void createTree() {
        String accessibleName;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultMutableTreeNode loading = new DefaultMutableTreeNode(DBExplorerArb.getString(17));
        root.add(loading);
        this._tree = new JTree(root);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        TreeCellRenderer renderer = this.getCellRenderer();
        if (renderer != null) {
            this._tree.setCellRenderer(renderer);
        }
        if ((accessibleName = this.getAccessibleName()) != null) {
            AccessibleUtils.updateAccessibleName((Accessible)this._tree, (String)accessibleName, (boolean)true);
        }
    }

    private static final void queue(Runnable r) {
        if (s_pool == null) {
            s_pool = new ThreadPoolExecutor(2, 2, 10, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        if (!s_pool.getQueue().contains(r)) {
            s_pool.execute(r);
        }
    }

    static JTree ra$_tree(BaseCMExplorer baseCMExplorer) {
        return baseCMExplorer._tree;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ DefaultTreeModel v$treeModel;
        private final /* synthetic */ DefaultMutableTreeNode v$newRoot;
        final /* synthetic */ BaseCMExplorer this$0;

        public void run() {
            if (BaseCMExplorer.ra$_tree(this.this$0) != null) {
                this.v$treeModel.setRoot(this.v$newRoot);
                this.v$treeModel.reload();
                int numRows = BaseCMExplorer.ra$_tree(this.this$0).getRowCount();
                int i = numRows - 1;
                while (i >= 0) {
                    BaseCMExplorer.ra$_tree(this.this$0).expandRow(i);
                    --i;
                }
            }
        }

        public 1(BaseCMExplorer baseCMExplorer, DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode) {
            this.v$newRoot = defaultMutableTreeNode;
            this.v$treeModel = defaultTreeModel;
            this.this$0 = baseCMExplorer;
        }
    }
}

