/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ideimpl.db.explorer.FolderElement;
import oracle.ideimpl.db.explorer.MarkAndSweeper;
import oracle.ideimpl.db.explorer.Markable;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;

public class BaseElement
implements Element,
Subject,
Markable {
    private MarkAndSweeper markOwner;
    private int mark;
    private ArrayList observers;
    protected String label;
    protected String tooltip;
    protected Context context;
    protected Icon icon;
    protected int startOffset;
    protected int endOffset;
    protected DBObject object;
    private FolderElement parent;
    private DBObjectID m_refID;

    public final boolean handleDoubleClick() {
        block10: {
            if (this.object == null) {
                NavigationManager mgr = NavigationManager.getNavigationManager();
                OffsetNavigationPoint point = new OffsetNavigationPoint(this.context, this.startOffset, this.startOffset != -1 ? this.endOffset - this.startOffset : 0);
                point.setPreferredEditorType(null);
                try {
                    if (mgr != null) {
                        mgr.navigateTo((NavigationPoint)point);
                        break block10;
                    }
                    point.navigate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                boolean edit = false;
                DBObject thisObj = this.object;
                if (thisObj instanceof SchemaObject) {
                    edit = true;
                }
                while (!edit && thisObj.getParent() != null) {
                    if (!((thisObj = thisObj.getParent()) instanceof SchemaObject)) continue;
                    edit = true;
                }
                if (edit) {
                    DBObjectProvider provider;
                    DBEditorFactory factory;
                    Node node;
                    if (thisObj instanceof Index && thisObj.getParent() != null & thisObj.getParent() instanceof SchemaObject) {
                        thisObj = thisObj.getParent();
                    }
                    if ((node = this.context.getNode()) instanceof DBObjectNode && thisObj instanceof SchemaObject && (factory = DBEditorFactoryRegistry.getEditFactory((SchemaObject)((SchemaObject)thisObj), (DBObjectProvider)(provider = ((DBObjectNode)node).getProvider()))) != null && factory.canEditDBObject((DBObject)((SchemaObject)thisObj), provider)) {
                        boolean edited = factory.editDBObject((DBObject)((SchemaObject)thisObj), provider, this.object);
                    }
                }
            }
        }
        return true;
    }

    public final Context getContext() {
        return this.context;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    public final void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public final DBObject getObject() {
        return this.object;
    }

    public final void setObject(DBObject object) {
        this.object = object;
    }

    public final FolderElement getParent() {
        return this.parent;
    }

    protected final void setParent(FolderElement parent) {
        this.parent = parent;
    }

    public final void setLabel(String label) {
        this.label = label;
        this.fireChangeUpdate(this);
    }

    public final void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public final void fireChangeUpdate(Object origin) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.PROPERTY_SET, origin);
        this.notifyObservers(this, updateMessage);
    }

    private void $init$() {
        this.markOwner = null;
        this.mark = -1;
        this.observers = new ArrayList();
        this.label = "N/A";
        this.tooltip = "N/A";
        this.context = null;
        this.icon = null;
        this.startOffset = -1;
        this.endOffset = -1;
        this.object = null;
        this.parent = null;
        this.m_refID = null;
    }

    private BaseElement(String label, String tooltipPrefix, Icon icon, Context context, int startOffset, int endOffset, DBObject object) {
        this.$init$();
        this.setLabel(label);
        this.tooltip = tooltipPrefix + label;
        this.icon = icon;
        this.context = context;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.object = object;
    }

    public BaseElement(String label, String tooltipPrefix, Icon icon, Context context, int startOffset, int endOffset) {
        this(label, tooltipPrefix, icon, context, startOffset, endOffset, null);
    }

    public BaseElement(String label, Icon icon, Context context, int startOffset, int endOffset) {
        this(label, "", icon, context, startOffset, endOffset, null);
    }

    public BaseElement(String label, Icon icon, Context context, DBObject object) {
        this(label, "", icon, context, -1, -1, object);
    }

    public final int compareTo(Object o) {
        if (o instanceof BaseElement) {
            return this.mark - ((BaseElement)o).mark;
        }
        return -1;
    }

    public final void setOwner(MarkAndSweeper markAndSweeper) {
        this.markOwner = markAndSweeper;
    }

    public final void unsetOwner() {
        this.markOwner = null;
    }

    public final void clearMark() {
        this.mark(-1);
    }

    public final void mark(int mark) {
        this.mark = mark;
        if (this.markOwner != null) {
            this.markOwner.markChanged();
        }
    }

    public final int getMark() {
        return this.mark;
    }

    public final Object getKey() {
        return this.label;
    }

    public Object getData() {
        return this;
    }

    public final String getShortLabel() {
        return this.label;
    }

    public final String getLongLabel() {
        return this.label;
    }

    public final Icon getIcon() {
        return this.icon;
    }

    void setIcon(Icon icon) {
        this.icon = icon;
    }

    public final String getToolTipText() {
        return this.tooltip;
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public final Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attach(Observer observer) {
        ArrayList arrayList = this.observers;
        synchronized (arrayList) {
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void detach(Observer observer) {
        ArrayList arrayList = this.observers;
        synchronized (arrayList) {
            int indexOf = this.observers.indexOf(observer);
            if (indexOf != -1) {
                this.observers.remove(indexOf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyObservers(Object subject, UpdateMessage change) {
        ArrayList arrayList = this.observers;
        synchronized (arrayList) {
            Object origin = change != null ? change.getOrigin() : null;
            ArrayList obs = (ArrayList)this.observers.clone();
            for (Observer observer : obs) {
                if (observer == origin) continue;
                try {
                    observer.update(subject, change);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        return this.getShortLabel();
    }

    public void setRefID(DBObjectID refID) {
        this.m_refID = refID;
    }

    public DBObjectID getRefID() {
        return this.m_refID;
    }
}

