/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.accessibility.Accessible;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.view.View;
import oracle.ideimpl.db.explorer.AbstractStructureBuilder;
import oracle.ideimpl.db.explorer.BaseElement;
import oracle.ideimpl.db.explorer.DBExplorerArb;
import oracle.ideimpl.db.explorer.DBObjectStructureBuilder;
import oracle.ideimpl.db.explorer.ExpansionTracker;
import oracle.ideimpl.db.explorer.FolderElement;
import oracle.ideimpl.db.explorer.PlSqlStructureBuilder;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Trigger;
import oracle.javatools.editor.WeakPropertyChangeSupport;

public class DBObjectExplorer
extends BaseTreeExplorer
implements ContextMenuListener,
Controller,
Observer,
PropertyChangeListener,
Runnable {
    private static IdeAction gotoSourceAction;
    private static JMenuItem gotoSourceMenuItem;
    private static IdeAction editAction;
    private static JMenuItem editMenuItem;
    private static IdeAction propertiesAction;
    private static JMenuItem propertiesMenuItem;
    private Object m_expansionState;
    protected Element m_rootElement;
    protected Node m_node;
    protected TextBuffer m_textBuffer;
    protected boolean m_isObserving;
    protected ExpansionTracker m_tracker;
    private AbstractStructureBuilder m_builder;
    private boolean rebuildScheduled;
    private static ThreadPoolExecutor s_pool;
    private static WeakPropertyChangeSupport changeSupport;

    public DBObjectExplorer() {
        this.$init$();
        this.m_rootElement = this.getEmptyRootElement();
        this.m_node = null;
        DBObjectExplorer.addPropertyChangeListener(this);
    }

    private void $init$() {
        this.m_isObserving = false;
        this.m_builder = null;
        this.rebuildScheduled = false;
    }

    protected FolderElement getEmptyRootElement() {
        return new FolderElement("", null, null);
    }

    public void setContext(Context context) {
        if (context != null && context.getNode() != null) {
            super.setContext(context);
            Node node = context.getNode();
            String nodeName = node.getShortLabel();
            String title = this.getAccessibleTitle(nodeName);
            if (this.tree != null) {
                AccessibleUtils.updateAccessibleName((Accessible)this.tree, (String)title, (boolean)true);
            }
        }
    }

    protected String getAccessibleTitle(String nodeName) {
        return nodeName;
    }

    public synchronized Element annotate(Context context) {
        if (context == null || context.getNode() == null) {
            this.m_rootElement = this.getEmptyRootElement();
            this.m_node = null;
        }
        if (context.getNode() == this.m_node) {
            return this.m_rootElement;
        }
        this.stopObserving();
        this.m_node = context.getNode();
        if (this.m_tracker != null) {
            this.m_tracker.clearExpansionState();
        }
        this.m_rootElement = this.getEmptyRootElement();
        this.scheduleRebuild();
        return this.m_rootElement;
    }

    public void stateChanged(int state) {
        View owner = this.owner();
        ContextMenu menu = owner != null ? owner.getContextMenu() : null;
        switch (state) {
            case 0: {
                if (!this.isObserving()) {
                    this.startObserving();
                }
                this.scheduleRebuild();
                if (menu == null) break;
                menu.addContextMenuListener((ContextMenuListener)this);
                break;
            }
            case 2: {
                DBObjectExplorer.removePropertyChangeListener(this);
            }
            case 1: {
                if (menu != null) {
                    menu.removeContextMenuListener((ContextMenuListener)this);
                }
                this.stopObserving();
                break;
            }
        }
    }

    private boolean isObserving() {
        return this.m_isObserving;
    }

    private void startObserving() {
        if (!this.m_isObserving && this.m_node != null) {
            this.m_node.attach((Observer)this);
            this.m_isObserving = true;
        }
    }

    private void stopObserving() {
        if (this.m_isObserving && this.m_node != null) {
            this.m_node.detach((Observer)this);
            this.m_isObserving = false;
            if (this.m_node instanceof TextNode) {
                ((TextNode)this.m_node).releaseTextBuffer();
                this.m_textBuffer = null;
            }
        }
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID;
        if (this.isObserving() && this.m_node != null && observed == this.m_node && (messageID = change.getMessageID()) != UpdateMessage.CHILD_REMOVED && messageID != UpdateMessage.CHILD_ADDED && messageID != UpdateMessage.PROPERTY_SET && messageID != UpdateMessage.OBJECT_RENAMED && messageID != UpdateMessage.CHILD_RENAMED && messageID != UpdateMessage.OBJECT_OPENED && messageID != UpdateMessage.OBJECT_CLOSED && messageID != UpdateMessage.OBJECT_CLOSING && messageID != UpdateMessage.ATTRIBUTE_CHANGED) {
            this.scheduleRebuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleRebuild() {
        DBObjectExplorer dBObjectExplorer = this;
        synchronized (dBObjectExplorer) {
            if (this.rebuildScheduled) {
                return;
            }
            this.rebuildScheduled = true;
        }
        DBObjectExplorer.queue(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.buildElementTree(this.m_node);
        }
        catch (Throwable throwable) {
            DBObjectExplorer dBObjectExplorer = this;
            synchronized (dBObjectExplorer) {
                this.rebuildScheduled = false;
            }
            throw throwable;
        }
        DBObjectExplorer dBObjectExplorer = this;
        synchronized (dBObjectExplorer) {
            this.rebuildScheduled = false;
        }
    }

    static final void queue(Runnable r) {
        if (s_pool == null) {
            s_pool = new ThreadPoolExecutor(2, 2, 10, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        if (!s_pool.getQueue().contains(r)) {
            s_pool.execute(r);
        }
    }

    protected void buildElementTree(Node node) {
        if (this.m_tracker == null) {
            this.m_tracker = new ExpansionTracker((JTree)this.tree);
        }
        this.m_tracker.stopTracking();
        this.m_expansionState = this.m_tracker.getExpansionState();
        this.m_tracker.clearExpansionState();
        TreePath[] selPaths = this.tree.getSelectionPaths();
        int[] selRows = this.tree.getSelectionRows();
        if (this.m_builder == null) {
            Context context = new Context();
            context.setNode(node);
            this.m_builder = ((DBObjectNode)node).getDBObject() instanceof PlSql && !(((DBObjectNode)node).getDBObject() instanceof Trigger) ? PlSqlStructureBuilder.createInstance(context) : DBObjectStructureBuilder.createInstance(context);
        }
        this.m_builder.updateTree();
        1 runner = new 1();
        SwingUtilities.invokeLater(runner);
    }

    protected void updateUI() {
    }

    protected void populateNodes(TNode node) {
        boolean expand = false;
        if (node.getParent() == null) {
            expand = true;
        } else if (node.getData() instanceof FolderElement) {
            expand = ((FolderElement)node.getData()).getExpandedDefault();
        }
        if (!expand) {
            ArrayList<String> path = new ArrayList<String>();
            TNode n = node;
            while (n.getParent() != null) {
                path.add(0, n.getData().getShortLabel());
                n = (TNode)n.getParent();
            }
            if (this.m_expansionState instanceof List[]) {
                List[] expansionLists = (List[])this.m_expansionState;
                List toExpandList = expansionLists[1];
                int size = toExpandList != null ? toExpandList.size() : 0;
                int i = 0;
                while (i < size && !expand) {
                    String[] ourPath = (String[])toExpandList.get(i);
                    if (ourPath.length == path.size()) {
                        expand = true;
                        int j = 0;
                        while (j < ourPath.length) {
                            if (!((String)path.get(j)).equals(ourPath[j])) {
                                expand = false;
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        if (expand) {
            this.addChildren(node);
            int count = node.getChildCount();
            int i = 0;
            while (i < count) {
                TNode child = (TNode)node.getChildAt(i);
                if (!child.isLeaf()) {
                    this.populateNodes(child);
                }
                ++i;
            }
        }
    }

    private TreePath locateMatchingPath(String[] savedPath) {
        TNode currentNode = (TNode)this.tree.getModel().getRoot();
        int size = savedPath.length;
        int i = 0;
        while (i < size) {
            TNode childNode;
            block3: {
                String savedLabel = savedPath[i];
                int childCount = currentNode.getChildCount();
                int j = 0;
                while (j < childCount) {
                    childNode = (TNode)currentNode.getChildAt(j);
                    BaseElement childElement = (BaseElement)childNode.getData();
                    if (!childElement.getShortLabel().equals(savedLabel)) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return null;
            }
            currentNode = childNode;
            ++i;
        }
        return new TreePath(currentNode.getPath());
    }

    private static synchronized void initActions() {
        String gotoSourceName = DBExplorerArb.getString(42);
        gotoSourceAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.ideimpl.db.explorer.GotoSource"), null, (String)gotoSourceName, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, null, (ResourceBundle)DBExplorerArb.getInstance(), null, null, (boolean)false);
        gotoSourceMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)gotoSourceAction);
        String editName = DBExplorerArb.getString(35);
        editAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.ideimpl.db.explorer.Edit"), null, (String)editName, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, null, (ResourceBundle)DBExplorerArb.getInstance(), null, null, (boolean)false);
        editMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)editAction);
        String propertiesName = DBExplorerArb.getString(24);
        propertiesAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"oracle.ideimpl.db.explorer.Properties"), null, (String)propertiesName, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, null, (ResourceBundle)DBExplorerArb.getInstance(), null, null, (boolean)false);
        propertiesMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)propertiesAction);
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (context == null) {
            return;
        }
        Element[] selection = context.getSelection();
        if (selection == null || selection.length != 1) {
            return;
        }
        Element element = selection[0];
        if (element instanceof BaseElement) {
            BaseElement codeElement = (BaseElement)element;
            if (gotoSourceAction == null) {
                DBObjectExplorer.initActions();
            }
            if (codeElement.getObject() == null && codeElement.getStartOffset() != -1) {
                gotoSourceAction.addController((Controller)this);
                gotoSourceAction.setEnabled(true);
                contextMenu.add((Component)gotoSourceMenuItem);
            } else if (codeElement.getObject() != null) {
                boolean edit = false;
                DBObject thisObj = codeElement.getObject();
                if (thisObj instanceof SchemaObject) {
                    edit = true;
                }
                while (!edit && thisObj.getParent() != null) {
                    if (!((thisObj = thisObj.getParent()) instanceof SchemaObject)) continue;
                    edit = true;
                }
                if (edit) {
                    Node node = context.getNode();
                    DBObjectProvider provider = ((DBObjectNode)node).getProvider();
                    if (provider instanceof Database) {
                        editAction.addController((Controller)this);
                        editAction.setEnabled(true);
                        contextMenu.add((Component)editMenuItem);
                    } else {
                        propertiesAction.addController((Controller)this);
                        propertiesAction.setEnabled(true);
                        contextMenu.add((Component)propertiesMenuItem);
                    }
                }
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        Element element;
        if (context != null && context.getView() == this.owner() && (element = context.getElement()) instanceof BaseElement) {
            return ((BaseElement)element).handleDoubleClick();
        }
        return false;
    }

    public Controller getController() {
        return this;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action == gotoSourceAction || action == editAction || action == propertiesAction) {
            Element element = context.getElement();
            if (element instanceof BaseElement) {
                BaseElement codeElement = (BaseElement)element;
                codeElement.handleDoubleClick();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return action == gotoSourceAction;
    }

    protected static void addPropertyChangeListener(PropertyChangeListener listener) {
        changeSupport.addPropertyChangeListener(listener);
    }

    protected static void removePropertyChangeListener(PropertyChangeListener listener) {
        changeSupport.removePropertyChangeListener(listener);
    }

    public static void firePropertyChange(String propertyName) {
        changeSupport.firePropertyChange(propertyName, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.propertyChange(event.getPropertyName());
    }

    protected void propertyChange(String propertyName) {
    }

    public Node getNode() {
        return this.m_node;
    }

    static {
        changeSupport = new WeakPropertyChangeSupport(DBObjectExplorer.class);
    }

    static AbstractStructureBuilder ra$m_builder(DBObjectExplorer dBObjectExplorer) {
        return dBObjectExplorer.m_builder;
    }

    static void mav$setRoot(DBObjectExplorer dBObjectExplorer, Element element) {
        dBObjectExplorer.setRoot(element);
    }

    static Object ra$m_expansionState(DBObjectExplorer dBObjectExplorer) {
        return dBObjectExplorer.m_expansionState;
    }

    final class 1
    implements Runnable {
        public void run() {
            DBObjectExplorer.this.m_rootElement = DBObjectExplorer.ra$m_builder(DBObjectExplorer.this).getRootElement();
            DBObjectExplorer.mav$setRoot(DBObjectExplorer.this, DBObjectExplorer.this.m_rootElement);
            TNode rootNode = DBObjectExplorer.this.getRoot();
            DBObjectExplorer.this.populateNodes(rootNode);
            DBObjectExplorer.this.m_tracker.expandDefaultExpansion();
            DBObjectExplorer.this.m_tracker.startTracking();
            DBObjectExplorer.this.m_tracker.restoreExpansion(DBObjectExplorer.ra$m_expansionState(DBObjectExplorer.this));
        }
    }
}

