/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.icons.IdeIcons;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.db.explorer.AbstractStructureBuilder;
import oracle.ideimpl.db.explorer.BaseElement;
import oracle.ideimpl.db.explorer.DBExplorerArb;
import oracle.ideimpl.db.explorer.FolderElement;
import oracle.ideimpl.db.explorer.PlSqlRootElement;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.ColumnConstraintReferenceID;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBReferenceID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.NameBasedRefID;
import oracle.javatools.db.plsql.PlSqlDeclaratorFactory;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.util.ModelUtil;

public class DBObjectStructureBuilder
implements AbstractStructureBuilder {
    private Context m_context;
    private FolderElement m_rootElement;
    private boolean m_online;
    private static String[] m_propsToIgnore = new String[]{"ID", "name", "properties", "SQLQuery", "domainIndextypeOpStatus", "code", "source", "referenceNames"};
    private static String[] m_propsToShowEvenWhenNull = new String[]{"cache", "cacheFlag", "cacheSize", "cycleFlag", "incrementBy", "lastNumber", "maxValue", "minValue", "orderFlag", "startWith"};

    private void $init$() {
        this.m_online = false;
    }

    public static DBObjectStructureBuilder createInstance(Context context) {
        DBObjectStructureBuilder builder = new DBObjectStructureBuilder(context);
        return builder;
    }

    private DBObjectStructureBuilder(Context context) {
        DBObjectProvider pro;
        this.$init$();
        this.m_context = context;
        Node node = context.getNode();
        if (node instanceof DBObjectNode && (pro = ((DBObjectNode)node).getProvider()) instanceof Database) {
            this.m_online = true;
        }
        this.createRootElement();
    }

    private void createRootElement() {
        Node node = this.m_context.getNode();
        String filename = URLFileSystem.getFileName((URL)node.getURL());
        this.m_rootElement = new PlSqlRootElement(filename, this.m_context);
    }

    public Element getRootElement() {
        return this.m_rootElement;
    }

    public void updateTree() {
        boolean nodeDirty;
        DBObjectNode node = (DBObjectNode)this.m_context.getNode();
        this.m_rootElement.removeAllChildren();
        DBObject obj = node.getDBObject();
        boolean bl = nodeDirty = node instanceof Dirtyable && ((Dirtyable)node).isDirty();
        if (obj != null) {
            if (obj instanceof Trigger && nodeDirty) {
                TextBuffer textBuffer = ((DBObjectPlSqlNode)node).acquireTextBuffer();
                String source = new String(textBuffer.getChars(0, textBuffer.getLength()));
                Trigger trig = new Trigger();
                trig.setSchema(((Trigger)obj).getSchema());
                trig.setEnabled(((Trigger)obj).isEnabled());
                trig.setSource(source);
                DBObjectProvider provider = node.getProvider();
                PlSqlDeclaratorFactory.loadDeclarativeInfo((PlSql)trig, (DBObjectProvider)provider);
                obj = trig;
            }
            this.buildTree(obj, this.m_rootElement);
        }
    }

    private void buildTree(DBObject obj, FolderElement currentFolder) {
        int pos = 0;
        if ("TABLE".equals(obj.getType())) {
            Object tableType = obj.getProperty("TableType", (Object)Table.TableType.NORMAL);
            String strTableType = this.getStringValue("TableType", tableType, false);
            this.addToTree(currentFolder, pos++, "TableType", tableType, strTableType, true);
        }
        Iterator pi = PropertyIterator.getPropertyIterator(obj.getClass());
        while (pi.hasNext()) {
            PropertyInfo propInf = (PropertyInfo)pi.next();
            Class propClass = propInf.getPropertyClass();
            String propName = propInf.getPropertyName();
            Object propValue = null;
            if (propClass.isArray()) {
                if (this.ignoreProperty(propName, obj)) continue;
                String folderName = PropertyDisplayRegistry.getDisplayName((String)propName);
                if (this.m_online) {
                    FolderElement subFolder = new FolderElement(folderName, OracleIcons.getIcon((String)"folder.png"), this.m_context, obj, this, obj, propName);
                    currentFolder.addChild(pos++, subFolder);
                    continue;
                }
                FolderElement subFolder = new FolderElement(folderName, OracleIcons.getIcon((String)"folder.png"), this.m_context, obj);
                currentFolder.addChild(pos++, subFolder);
                this.loadArrayProp(obj, propName, subFolder);
                continue;
            }
            if (this.ignoreProperty(propName, obj)) continue;
            propValue = propInf.getPropertyValue((Object)obj);
            String strPropValue = null;
            boolean showParent = false;
            if (this.ignorePropertyValue(propName, propValue)) continue;
            showParent = false;
            if ("referenceID".equals(propName)) {
                showParent = true;
            }
            strPropValue = this.getStringValue(propName, propValue, showParent);
            this.addToTree(currentFolder, pos++, propName, propValue, strPropValue, true);
        }
        if (obj instanceof Trigger) {
            Icon folderIcon = OracleIcons.getIcon((String)"folder.png");
            PlSqlInterrogator plsqlInt = ((Trigger)obj).getSourceInterrogator();
            PlSqlFragment code = this.getTriggerCodeFrag(plsqlInt.getRoot());
            if (plsqlInt.getPlSqlErrors().length > 0) {
                FolderElement errorFolder = new FolderElement(DBExplorerArb.getString(3), folderIcon, this.m_context);
                currentFolder.addChild(pos++, errorFolder);
                PlsqlError[] errors = plsqlInt.getPlSqlErrors();
                if (errors.length != 0) {
                    int i = 0;
                    while (i < errors.length) {
                        PlsqlError error = errors[i];
                        if (error != null) {
                            errorFolder.addChild(i, this.createLeafElement((PlsqlNode)error, error.getErrorMessage(), "", OracleIcons.getIcon((String)"error.png")));
                        }
                        ++i;
                    }
                }
            }
            if (code.getSubFragments().size() == 1) {
                code = (PlSqlFragment)code.getSubFragments().get(0);
            }
            FolderElement childFolder = new FolderElement(code.getDescriptionString(), folderIcon, this.m_context);
            currentFolder.addChild(pos, childFolder);
            this.buildTreeForFragment(code, childFolder);
        }
    }

    private PlSqlFragment getTriggerCodeFrag(PlSqlFragment frag) {
        if (frag.getFramentType() == PlSqlFragment.Type.PLSQL_BLOCK) {
            return frag;
        }
        PlSqlFragment retval = null;
        for (Object sub : frag.getSubFragments()) {
            PlSqlFragment childFrag = (PlSqlFragment)sub;
            retval = this.getTriggerCodeFrag(childFrag);
            if (retval == null) continue;
            return retval;
        }
        return retval;
    }

    private boolean ignoreProperty(String propName, DBObject obj) {
        if ("INDEX".equals(obj.getType()) && "columns".equals(propName)) {
            return true;
        }
        int i = 0;
        while (i < m_propsToIgnore.length) {
            if (m_propsToIgnore[i].equals(propName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean ignorePropertyValue(String propName, Object propValue) {
        if (propValue == null) {
            int j = 0;
            while (j < m_propsToShowEvenWhenNull.length) {
                if (m_propsToShowEvenWhenNull[j].equals(propName)) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    private void sortConstraintsArray(Object propValue) {
        if (propValue != null && propValue instanceof Constraint[]) {
            Constraint[] constraints = (Constraint[])propValue;
            ArrayList<Object> pks = new ArrayList<Object>();
            ArrayList<Constraint> uks = new ArrayList<Constraint>();
            ArrayList<Constraint> fks = new ArrayList<Constraint>();
            ArrayList<Constraint> ccs = new ArrayList<Constraint>();
            Constraint[] constraintArray = constraints;
            int n = 0;
            while (n < constraintArray.length) {
                Constraint c = constraintArray[n];
                if (c.getConstraintType().equals("PKConstraint")) {
                    pks.add(c);
                } else if (c.getConstraintType().equals("UniqueConstraint")) {
                    uks.add(c);
                } else if (c.getConstraintType().equals("FKConstraint")) {
                    fks.add(c);
                } else if (c.getConstraintType().equals("CheckConstraint")) {
                    ccs.add(c);
                }
                ++n;
            }
            pks.addAll(uks);
            pks.addAll(fks);
            pks.addAll(ccs);
            int i = 0;
            while (i < constraints.length) {
                constraints[i] = (Constraint)pks.get(i);
                ++i;
            }
        }
    }

    private String getStringValue(String propName, Object propValue, boolean showParent) {
        StringBuilder sb = new StringBuilder("");
        if (propValue != null) {
            if (showParent) {
                if (propValue instanceof DBObjectID) {
                    DBObjectID parentID = ((DBObjectID)propValue).getParent();
                    if (parentID != null) {
                        if (parentID instanceof DBReferenceID) {
                            sb.append(((DBReferenceID)parentID).getName()).append(".");
                        } else {
                            sb.append(DBUtil.getDBObjectName((DBObjectID)parentID)).append(".");
                        }
                    }
                } else if (propValue instanceof DBObject) {
                    sb.append(((DBObject)propValue).getParent().getName());
                    sb.append(".");
                }
            }
            if (propValue instanceof DataTypeUsage && "dataTypeUsage".equals(propName)) {
                DataType dt = null;
                try {
                    dt = DataTypeHelper.getDataType((DataTypeUsage)((DataTypeUsage)propValue));
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (dt != null) {
                    sb.append(dt.getDDL((DataTypeUsage)propValue));
                }
            } else if (propValue instanceof DBReferenceID) {
                sb.append(((DBReferenceID)propValue).getName());
            } else if (propValue instanceof DBObjectID) {
                sb.append(DBUtil.getDBObjectName((DBObjectID)((DBObjectID)propValue)));
            } else if (propValue instanceof ViewColumn) {
                ViewColumn col = (ViewColumn)propValue;
                String colName = col.getName();
                if (!ModelUtil.hasLength((String)colName)) {
                    DBObjectID oid = col.getSelectObjectID();
                    SelectObject so = null;
                    try {
                        so = (SelectObject)oid.resolveID();
                    }
                    catch (DBException e) {
                        so = null;
                    }
                    if (so != null) {
                        colName = so.toString();
                    }
                }
                sb.append(colName);
            } else {
                sb.append(PropertyDisplayRegistry.getPropValueDisplay((String)propName, (String)propValue.toString()));
            }
        }
        return sb.toString();
    }

    private void addToTree(FolderElement folder, int pos, String propName, Object propValue, String strPropValue, boolean showPropertyLabel) {
        BaseElement childElement;
        DBObject ctxObject;
        Icon icon;
        boolean drillDown = propValue instanceof DBObject && !"dataTypeUsage".equals(propName) && !"columnExpressions".equals(propName) && !"schema".equals(propName) && !"tableOwner".equals(propName);
        StringBuilder strBld = new StringBuilder();
        if (propName != null && showPropertyLabel) {
            strBld.append(PropertyDisplayRegistry.getDisplayName((String)propName));
            strBld.append(": ");
        }
        strBld.append(strPropValue);
        Object objectToBaseIconOn = propValue;
        if (objectToBaseIconOn instanceof DataTypeUsage) {
            objectToBaseIconOn = ((DataTypeUsage)objectToBaseIconOn).getDataTypeID();
        }
        if ((icon = this.getIcon(objectToBaseIconOn, folder)) == null) {
            icon = IdeIcons.getIcon((int)5);
        }
        DBObject dBObject = ctxObject = propValue instanceof DBObject ? (DBObject)propValue : null;
        if (propValue instanceof DBObject && drillDown) {
            childElement = new FolderElement(strBld.toString(), icon, this.m_context, ctxObject);
            folder.addChild(pos, childElement);
            this.buildTree((DBObject)propValue, (FolderElement)childElement);
        } else {
            if (objectToBaseIconOn instanceof ColumnConstraintReferenceID) {
                strBld.append(" (");
                strBld.append(DBExplorerArb.getString(25));
                strBld.append(")");
            }
            childElement = new BaseElement(strBld.toString(), icon, this.m_context, ctxObject);
            folder.addChild(pos, childElement);
        }
        if (propValue instanceof BaseObjectID) {
            childElement.setRefID((DBObjectID)((BaseObjectID)propValue));
        }
    }

    private Icon getIcon(Object obj, FolderElement folder) {
        Icon icon;
        block15: {
            icon = null;
            String type = null;
            DBObject dbobj = null;
            boolean unresolved = false;
            if (obj instanceof DBReferenceID || obj instanceof NameBasedRefID) {
                type = ((DBObjectID)obj).getType();
                if ("CONSTRAINT".equals(type)) {
                    type = ((DBReferenceID)obj).getSubType();
                }
            } else if (obj instanceof DBObjectID) {
                type = ((DBObjectID)obj).getType();
                try {
                    dbobj = ((DBObjectID)obj).resolveID();
                }
                catch (DBException e) {
                    dbobj = null;
                }
                if (dbobj == null) {
                    unresolved = true;
                }
                if ("CONSTRAINT".equals(type) && !unresolved) {
                    Constraint constr = (Constraint)dbobj;
                    type = constr.getConstraintType();
                } else if ("CONSTRAINT".equals(type) && unresolved) {
                    type = "PKConstraint";
                }
            } else if (obj instanceof Constraint) {
                type = ((Constraint)obj).getConstraintType();
            } else if (obj instanceof DBObject) {
                type = ((DBObject)obj).getType();
            }
            icon = "FKConstraint".equals(type) ? OracleIcons.getIcon((String)"foreignkey.png") : ("PKConstraint".equals(type) || "UniqueConstraint".equals(type) ? OracleIcons.getIcon((String)"key.png") : ("CheckConstraint".equals(type) ? OracleIcons.getIcon((String)"constraint.png") : DBTypeDisplayRegistry.getNodeIcon((String)type)));
            if (!unresolved) break block15;
            icon = new OverlayIcon(icon, OracleIcons.getIcon((String)"overlay/invalid.png"));
            FolderElement parFolder = folder;
            do {
                Icon parIcon = parFolder.getIcon();
                parIcon = new OverlayIcon(parIcon, OracleIcons.getIcon((String)"overlay/invalid.png"));
                parFolder.setIcon(parIcon);
            } while ((parFolder = parFolder.getParent()) != null);
        }
        return icon;
    }

    private BaseElement createLeafElement(PlsqlNode symbol, String label, String tooltipPrefix, Icon icon) {
        return new BaseElement(label, tooltipPrefix, icon, this.m_context, symbol.getStartOffset(), -1);
    }

    private void buildTreeForFragment(PlSqlFragment frag, FolderElement folder) {
        folder.clearAllMarks();
        int pos = 0;
        FolderElement folderToAddto = folder;
        folder.setTooltip(frag.getSourceSnippet(100));
        folder.setStartOffset(frag.getFirstToken().getStart());
        int i = 0;
        while (i < frag.getSubFragments().size()) {
            PlSqlFragment childFrag = (PlSqlFragment)frag.getSubFragments().get(i);
            Icon icon = null;
            folderToAddto = folder;
            if (childFrag.getSubFragments().size() > 0) {
                icon = OracleIcons.getIcon((String)"folder.png");
                FolderElement childFolder = new FolderElement(childFrag.getDescriptionString(), icon, this.m_context);
                folderToAddto.addChild(pos++, childFolder);
                this.buildTreeForFragment(childFrag, childFolder);
            } else {
                icon = OracleIcons.getIcon((String)"method.png");
                BaseElement element = this.createLeafElement((PlsqlNode)childFrag, childFrag.getDescriptionString(), childFrag.getSourceSnippet(100), icon);
                folderToAddto.addChild(pos++, element);
                element.setTooltip(childFrag.getSourceSnippet(100));
            }
            ++i;
        }
        folder.sweep();
    }

    public void lazyLoad(Object propOwner, String propName, FolderElement folder) {
        this.loadArrayProp(propOwner, propName, folder);
    }

    private void loadArrayProp(Object propOwner, String propName, FolderElement folder) {
        Iterator pi = PropertyIterator.getPropertyIterator(propOwner.getClass());
        Object propValue = null;
        while (pi.hasNext()) {
            PropertyInfo propInf = (PropertyInfo)pi.next();
            String name = propInf.getPropertyName();
            if (!name.equals(propName)) continue;
            propValue = propInf.getPropertyValue(propOwner);
            break;
        }
        if (propValue != null) {
            if ("indexes".equals(propName) && propValue instanceof Index[]) {
                Arrays.sort((Index[])propValue, DBUtil.getNameComparator());
            }
            if ("constraints".equals(propName)) {
                this.sortConstraintsArray(propValue);
            }
            boolean quiet = folder.getQuiet();
            folder.setQuiet(true);
            int i = 0;
            while (i < ((Object[])propValue).length) {
                Object listPropValue = ((Object[])propValue)[i];
                String strPropValue = this.getStringValue(propName, listPropValue, false);
                this.addToTree(folder, i, propName, listPropValue, strPropValue, false);
                ++i;
            }
            folder.setQuiet(quiet);
        }
    }
}

