/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Node;
import oracle.ideimpl.db.explorer.BaseCMExplorer;
import oracle.ideimpl.db.explorer.DBExplorerArb;
import oracle.ideimpl.db.explorer.DBObjectExplorerCellRenderer;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.util.ModelUtil;

public class DatabaseLinkExplorer
extends BaseCMExplorer {
    protected DefaultMutableTreeNode buildTree() {
        Node node = this.getNode();
        DatabaseLink dblink = this.isValidNode(node) ? (DatabaseLink)((DBObjectNode)node).getDBObject() : null;
        DefaultMutableTreeNode root = dblink != null ? DatabaseLinkExplorer.buildTree(dblink) : new DefaultMutableTreeNode(node.getShortLabel());
        return root;
    }

    public static DefaultMutableTreeNode buildTree(DatabaseLink obj) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(obj);
        String name = obj.getName();
        DatabaseLinkExplorer.addNode(root, 22, name);
        DatabaseLinkExplorer.addNode(root, 4, obj.getUsername());
        DatabaseLinkExplorer.addNode(root, 2, obj.getPassword());
        DatabaseLinkExplorer.addNode(root, 8, obj.getHost());
        DatabaseLinkExplorer.addNode(root, 47, obj.getCreated());
        return root;
    }

    private static void addNode(DefaultMutableTreeNode root, int prop, String value) {
        if (ModelUtil.hasLength((String)value)) {
            String label = DBExplorerArb.getString(prop) + ": " + value;
            DefaultMutableTreeNode propNode = new DefaultMutableTreeNode(label);
            root.add(propNode);
        }
    }

    protected boolean isValidNode(Node node) {
        if (node instanceof DBObjectNode) {
            return ((DBObjectNode)node).getObjectType().equals("DATABASE LINK");
        }
        return false;
    }

    protected TreeCellRenderer getCellRenderer() {
        return new DBObjectExplorerCellRenderer();
    }
}

