/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.db.explorer.AbstractStructureBuilder;
import oracle.ideimpl.db.explorer.BaseElement;
import oracle.ideimpl.db.explorer.DBExplorerArb;
import oracle.ideimpl.db.explorer.MarkAndSweeper;
import oracle.ideimpl.db.explorer.Markable;
import oracle.javatools.db.DBObject;

public class FolderElement
extends BaseElement {
    private Boolean m_lazyLoadPending;
    private AbstractStructureBuilder m_structureBuilder;
    private String m_propName;
    private Object m_propOwner;
    private boolean m_expandedDefault;
    protected MarkAndSweeper children;
    protected boolean quiet;

    private void $init$() {
        this.m_lazyLoadPending = Boolean.FALSE;
        this.m_structureBuilder = null;
        this.m_propName = null;
        this.m_propOwner = null;
        this.m_expandedDefault = false;
        this.children = new MarkAndSweeper();
        this.quiet = false;
    }

    public final boolean getQuiet() {
        return this.quiet;
    }

    public final void setQuiet(boolean quietly) {
        this.quiet = quietly;
    }

    public final void addChild(int order, BaseElement child) {
        child.mark(order);
        this.children.add(child);
        child.setParent(this);
        if (!this.quiet) {
            this.fireAddUpdate((Object)this, child);
        }
    }

    public final BaseElement findChild(String label) {
        return (BaseElement)this.children.get(label);
    }

    public final void removeChildren(BaseElement child) {
        Markable object = this.children.remove(child.getLongLabel());
        if (object != null && !this.quiet) {
            this.fireRemoveUpdate((Object)this, child);
        }
    }

    public final void removeAllChildren() {
        this.children.removeAll();
        if (!this.quiet) {
            this.fireBigChangeUpdate(this);
        }
    }

    public final void clearAllMarks() {
        this.children.clearMarks();
    }

    public boolean sweep() {
        ArrayList removed = this.children.sweep();
        if (removed != null && !this.quiet) {
            this.fireRemoveUpdate((Object)this, removed);
        }
        return removed != null;
    }

    public final void fireAddUpdate(Object origin, BaseElement element) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_ADDED, origin);
        List added = updateMessage.getAddObjects();
        added.add(element);
        this.notifyObservers(this, updateMessage);
    }

    public final void fireAddUpdate(Object origin, Collection elements) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_ADDED, origin);
        List added = updateMessage.getAddObjects();
        added.addAll(elements);
        this.notifyObservers(this, updateMessage);
    }

    public final void fireRemoveUpdate(Object origin, BaseElement element) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, origin);
        List removed = updateMessage.getRemoveObjects();
        removed.add(element);
        this.notifyObservers(this, updateMessage);
    }

    public final void fireRemoveUpdate(Object origin, Collection elements) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, origin);
        List removed = updateMessage.getRemoveObjects();
        removed.addAll(elements);
        this.notifyObservers(this, updateMessage);
    }

    public final void fireBigChangeUpdate(Object origin) {
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.STRUCTURE_CHANGED, origin);
        this.notifyObservers(this, updateMessage);
    }

    public FolderElement(String label, Icon icon, Context context) {
        super(label, icon, context, -1, -1);
        this.$init$();
    }

    public FolderElement(String label, Icon icon, Context context, DBObject object) {
        super(label, icon, context, object);
        this.$init$();
    }

    public FolderElement(String label, Icon icon, Context context, DBObject object, AbstractStructureBuilder structureBuilder, Object propOwner, String propName) {
        super(label, icon, context, object);
        this.$init$();
        this.m_structureBuilder = structureBuilder;
        this.m_propOwner = propOwner;
        this.m_propName = propName;
        this.m_lazyLoadPending = Boolean.TRUE;
    }

    public boolean getExpandedDefault() {
        return this.m_expandedDefault;
    }

    public void setExpandedDefault(boolean expandedDefault) {
        this.m_expandedDefault = expandedDefault;
    }

    public final boolean mayHaveChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        Boolean bl = this.m_lazyLoadPending;
        synchronized (bl) {
            if (this.m_lazyLoadPending.booleanValue()) {
                this.m_lazyLoadPending = Boolean.FALSE;
                ProgressRunnableFolder prf = new ProgressRunnableFolder(null);
                ProgressRunnableFolder.mav$load(prf, this.m_structureBuilder, this.m_propOwner, this.m_propName, this, this.getShortLabel());
            }
        }
        return this.children.iterator();
    }

    private static class ProgressRunnableFolder
    extends ProgressRunnable {
        private AbstractStructureBuilder m_structureBuilder;
        private Object m_propOwner;
        private String m_propName;
        private FolderElement m_folder;

        protected Object doWork() throws Exception {
            this.m_structureBuilder.lazyLoad(this.m_propOwner, this.m_propName, this.m_folder);
            return null;
        }

        private void load(AbstractStructureBuilder structureBuilder, Object propOwner, String propName, FolderElement folder, String propDisplayName) {
            this.m_structureBuilder = structureBuilder;
            this.m_propOwner = propOwner;
            this.m_propName = propName;
            this.m_folder = folder;
            this.setCancelable(false);
            this.setTitle(DBExplorerArb.getString(51));
            this.setMessage(DBExplorerArb.format(60, propDisplayName));
            try {
                this.start(SwingUtilities.isEventDispatchThread());
            }
            catch (ProgressException e) {
                // empty catch block
            }
        }

        private ProgressRunnableFolder() {
        }

        ProgressRunnableFolder(1 var1_1) {
            this();
        }

        static void mav$load(ProgressRunnableFolder progressRunnableFolder, AbstractStructureBuilder abstractStructureBuilder, Object object, String string, FolderElement folderElement, String string2) {
            progressRunnableFolder.load(abstractStructureBuilder, object, string, folderElement, string2);
        }

        public final class 1 {
        }
    }
}

