/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import oracle.ideimpl.db.explorer.Markable;

public final class MarkAndSweeper {
    private ArrayList sortedList;
    private HashMap hashMap;

    private void $init$() {
        this.sortedList = null;
        this.hashMap = new HashMap();
    }

    public MarkAndSweeper() {
        this.$init$();
    }

    public void markChanged() {
        this.sortedList = null;
    }

    public void add(Markable value) {
        value.setOwner(this);
        this.hashMap.put(value.getKey(), value);
        this.sortedList = null;
    }

    public Markable get(Object key) {
        return (Markable)this.hashMap.get(key);
    }

    public Markable remove(Object key) {
        Markable removed = (Markable)this.hashMap.remove(key);
        if (removed != null) {
            removed.unsetOwner();
            this.sortedList = null;
        }
        return removed;
    }

    public void removeAll() {
        for (Markable object : this.hashMap.values()) {
            object.unsetOwner();
        }
        this.hashMap.clear();
        this.sortedList = null;
    }

    public int size() {
        return this.hashMap.size();
    }

    public void clearMarks() {
        for (Markable object : this.hashMap.values()) {
            object.clearMark();
        }
    }

    public ArrayList sweep() {
        ArrayList<Markable> removed = new ArrayList<Markable>();
        Iterator iterator = this.hashMap.values().iterator();
        while (iterator.hasNext()) {
            Markable object = (Markable)iterator.next();
            if (object.getMark() != -1) continue;
            object.unsetOwner();
            removed.add(object);
            iterator.remove();
        }
        if (removed.size() > 0) {
            this.sortedList = null;
            return removed;
        }
        return null;
    }

    public Iterator iterator() {
        if (this.sortedList == null) {
            this.generateSortedList();
        }
        return this.sortedList.iterator();
    }

    private void generateSortedList() {
        this.sortedList = new ArrayList();
        Iterator iterator = this.hashMap.values().iterator();
        while (iterator.hasNext()) {
            this.sortedList.add(iterator.next());
        }
        Collections.sort(this.sortedList);
    }
}

