/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ideimpl.db.explorer.BaseElement;
import oracle.ideimpl.db.explorer.FolderElement;
import oracle.javatools.icons.OracleIcons;

final class PlSqlRootElement
extends FolderElement {
    private static final int ORDER_PKG_OR_FUNC = 100;
    private FolderElement errorsFolder;

    PlSqlRootElement(String filename, Context context) {
        super(filename, OracleIcons.getIcon((String)"plsql_package.png"), context);
    }

    public boolean sweep() {
        ArrayList removed = this.children.sweep();
        if (removed != null) {
            if (this.errorsFolder != null && removed.contains(this.errorsFolder)) {
                this.errorsFolder = null;
            }
            if (!this.quiet) {
                this.fireRemoveUpdate((Object)this, removed);
            }
        }
        return removed != null;
    }

    FolderElement getFolder(String name, int order) {
        FolderElement folder = null;
        BaseElement clazz = this.findChild(name);
        if (clazz instanceof FolderElement) {
            folder = (FolderElement)clazz;
            folder.mark(order + 100);
            this.fireRemoveUpdate((Object)this, folder);
            this.fireAddUpdate((Object)this, folder);
        } else {
            if (clazz != null) {
                this.children.remove(clazz.getLongLabel());
            }
            folder = new TopLevelFolderElement(name, this.context);
            this.addChild(order + 100, folder);
        }
        return folder;
    }

    static class TopLevelFolderElement
    extends FolderElement {
        TopLevelFolderElement(String label, Context context) {
            super(label, context.getNode() == null ? OracleIcons.getIcon((String)"plsql_package.png") : context.getNode().getIcon(), context);
        }
    }
}

