/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.db.explorer.AbstractStructureBuilder;
import oracle.ideimpl.db.explorer.BaseElement;
import oracle.ideimpl.db.explorer.DBExplorerArb;
import oracle.ideimpl.db.explorer.FolderElement;
import oracle.ideimpl.db.explorer.PlSqlRootElement;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.Database;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;

public class PlSqlStructureBuilder
implements AbstractStructureBuilder {
    private Context context;
    private PlSqlRootElement rootElement;
    private PlSqlInterrogator _privateInterrogator;
    private PlSqlInterrogator _interrogatorInUse;

    public static PlSqlStructureBuilder createInstance(Context context) {
        PlSqlStructureBuilder builder = new PlSqlStructureBuilder(context);
        return builder;
    }

    private PlSqlStructureBuilder(Context context) {
        this.context = context;
        this._interrogatorInUse = this._privateInterrogator = new PlSqlInterrogator();
        this.createRootElement();
    }

    private void createRootElement() {
        Node node = this.context.getNode();
        String filename = URLFileSystem.getFileName((URL)node.getURL());
        this.rootElement = new PlSqlRootElement(filename, this.context);
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public void updateTree() {
        DBObjectNode node = (DBObjectNode)this.context.getNode();
        if (URLFileSystem.exists((URL)node.getURL())) {
            boolean quiet = this.rootElement.getQuiet();
            PlSql obj = (PlSql)node.getDBObject();
            if (node instanceof DBObjectPlSqlNode) {
                DBObjectPlSqlNode plsNode = (DBObjectPlSqlNode)node;
                boolean nodeDirty = plsNode instanceof Dirtyable && ((Dirtyable)plsNode).isDirty();
                boolean online = plsNode.getProvider() instanceof Database;
                this._interrogatorInUse = null;
                if (obj != null && !nodeDirty && !online) {
                    this._interrogatorInUse = plsNode.isBody() ? ((SpecPlSql)obj).getBodySourceInterrogator() : obj.getSourceInterrogator();
                }
                if (this._interrogatorInUse == null) {
                    TextBuffer textBuffer = plsNode.acquireTextBuffer();
                    try {
                        try {
                            String source = new String(textBuffer.getChars(0, textBuffer.getLength()));
                            this._privateInterrogator.updateSource(source);
                        }
                        catch (Exception e) {
                            System.err.println("Exception thrown while building structure");
                            e.printStackTrace();
                        }
                    }
                    finally {
                        if (node != null) {
                            plsNode.releaseTextBuffer();
                        }
                    }
                    this._interrogatorInUse = this._privateInterrogator;
                }
            } else {
                this._interrogatorInUse = obj.getSourceInterrogator();
            }
            this.createRootElement();
            this.rootElement.setQuiet(false);
            PlSqlFragment rootFrag = this._interrogatorInUse.getRoot();
            this.buildTreeForFragment(rootFrag, this.rootElement);
            this.rootElement.setQuiet(quiet);
        }
    }

    private BaseElement createLeafElement(PlsqlNode symbol, String label, String tooltipPrefix, Icon icon) {
        return new BaseElement(label, tooltipPrefix, icon, this.context, symbol.getStartOffset(), -1);
    }

    private void buildTreeForFragment(PlSqlFragment frag, FolderElement folder) {
        int mainCount = 0;
        int pseudoCount = 0;
        int pos = 0;
        folder.clearAllMarks();
        FolderElement errorFolder = null;
        if (frag.getParent() != null && frag.getParent().getFramentType() == PlSqlFragment.Type.ROOT && this._interrogatorInUse.getPlSqlErrors().length > 0) {
            errorFolder = new FolderElement(DBExplorerArb.getString(3), OracleIcons.getIcon((String)"folder.png"), this.context);
            folder.addChild(mainCount++, errorFolder);
            PlsqlError[] errors = this._interrogatorInUse.getPlSqlErrors();
            if (errors.length != 0) {
                int i = 0;
                while (i < errors.length) {
                    PlsqlError error = errors[i];
                    if (error != null) {
                        errorFolder.addChild(i, this.createLeafElement((PlsqlNode)error, error.getErrorMessage(), "", OracleIcons.getIcon((String)"error.png")));
                    }
                    ++i;
                }
            }
        }
        FolderElement folderToAddto = folder;
        FolderElement pseudoPackageDecls = null;
        folder.setTooltip(frag.getSourceSnippet(100));
        folder.setStartOffset(frag.getFirstToken().getStart());
        if (frag.getFramentType() == PlSqlFragment.Type.PACKAGE_BODY) {
            int i = 0;
            if (i < frag.getSubFragments().size()) {
                PlSqlFragment childFrag = (PlSqlFragment)frag.getSubFragments().get(i);
                if (childFrag.getFramentType() == PlSqlFragment.Type.DECLARATION || childFrag.getFramentType() == PlSqlFragment.Type.PROCEDURE_FD || childFrag.getFramentType() == PlSqlFragment.Type.FUNCTION_FD || childFrag.getFramentType() == PlSqlFragment.Type.PRAGMA) {
                    pseudoPackageDecls = new FolderElement(PlSqlFragment.getTypeString((PlSqlFragment.Type)PlSqlFragment.Type.DECLARE), OracleIcons.getIcon((String)"folder.png"), this.context);
                    folder.addChild(mainCount++, pseudoPackageDecls);
                }
            }
        }
        int i = 0;
        while (i < frag.getSubFragments().size()) {
            PlSqlFragment childFrag = (PlSqlFragment)frag.getSubFragments().get(i);
            Icon icon = null;
            folderToAddto = folder;
            pos = mainCount++;
            switch (1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[childFrag.getFramentType().ordinal()]) {
                case 1: 
                case 2: {
                    icon = OracleIcons.getIcon((String)"plsql_package.png");
                    break;
                }
                case 3: {
                    icon = OracleIcons.getIcon((String)"plsql_proc.png");
                    break;
                }
                case 4: {
                    icon = OracleIcons.getIcon((String)"function.png");
                    break;
                }
                case 5: {
                    icon = OracleIcons.getIcon((String)"plsql_proc.png");
                    if (pseudoPackageDecls == null) break;
                    folderToAddto = pseudoPackageDecls;
                    pos = pseudoCount++;
                    --mainCount;
                    break;
                }
                case 6: {
                    icon = OracleIcons.getIcon((String)"function.png");
                    if (pseudoPackageDecls == null) break;
                    folderToAddto = pseudoPackageDecls;
                    pos = pseudoCount++;
                    --mainCount;
                    break;
                }
                case 7: 
                case 8: {
                    icon = OracleIcons.getIcon((String)"domain.png");
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    icon = OracleIcons.getIcon((String)"trigger.png");
                    break;
                }
                case 17: {
                    icon = OracleIcons.getIcon((String)"field.png");
                    break;
                }
                case 18: {
                    icon = OracleIcons.getIcon((String)"field.png");
                    if (pseudoPackageDecls == null) break;
                    folderToAddto = pseudoPackageDecls;
                    pos = pseudoCount++;
                    --mainCount;
                    break;
                }
                case 19: {
                    if (pseudoPackageDecls == null) break;
                    folderToAddto = pseudoPackageDecls;
                    pos = pseudoCount++;
                    --mainCount;
                    break;
                }
                default: {
                    icon = null;
                    break;
                }
            }
            if (childFrag.getSubFragments().size() > 0) {
                if (icon == null) {
                    icon = OracleIcons.getIcon((String)"folder.png");
                }
                FolderElement childFolder = new FolderElement(childFrag.getDescriptionString(), icon, this.context);
                if (folderToAddto == this.rootElement) {
                    childFolder.setExpandedDefault(true);
                }
                folderToAddto.addChild(pos, childFolder);
                this.buildTreeForFragment(childFrag, childFolder);
            } else {
                if (icon == null) {
                    icon = OracleIcons.getIcon((String)"method.png");
                }
                BaseElement element = this.createLeafElement((PlsqlNode)childFrag, childFrag.getDescriptionString(), childFrag.getSourceSnippet(100), icon);
                folderToAddto.addChild(pos, element);
                element.setTooltip(childFrag.getSourceSnippet(100));
            }
            ++i;
        }
        folder.sweep();
    }

    public void lazyLoad(Object propOwner, String propName, FolderElement folder) {
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$plsql$PlSqlFragment$Type;

        static {
            int[] nArray = new int[PlSqlFragment.Type.values().length];
            $sm$oracle$javatools$db$plsql$PlSqlFragment$Type = nArray;
            try {
                nArray[PlSqlFragment.Type.PACKAGE_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.PACKAGE_BODY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.PROCEDURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.FUNCTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.PROCEDURE_FD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.FUNCTION_FD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TYPE_SPEC.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TYPE_BODY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_COLUMNS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_EVENTS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_REFERENCING.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_ROW_LEVEL.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_TABLE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_TIMING.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_WHEN.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.PARAMETER.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.DECLARATION.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.PRAGMA.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

