/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.model.Node;
import oracle.ideimpl.db.explorer.BaseCMExplorer;
import oracle.ideimpl.db.explorer.DBExplorerArb;
import oracle.ideimpl.db.explorer.DBObjectExplorerCellRenderer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.util.ModelUtil;

public class RecycledObjectExplorer
extends BaseCMExplorer {
    protected DefaultMutableTreeNode buildTree() {
        RecycledObject ro;
        Node node = this.getNode();
        RecycledObject recycledObject = ro = this.isValidNode(node) ? (RecycledObject)((DBObjectNode)node).getDBObject() : null;
        if (ro != null) {
            return RecycledObjectExplorer.buildTree(ro);
        }
        return new DefaultMutableTreeNode(node.getShortLabel());
    }

    public static DefaultMutableTreeNode buildTree(RecycledObject obj) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(obj);
        String name = obj.getOriginalName();
        RecycledObjectExplorer.addNode(root, 18, name);
        RecycledObjectExplorer.addNode(root, 57, obj.getOriginalType());
        RecycledObjectExplorer.addNode(root, 1, obj.getCreateTime());
        RecycledObjectExplorer.addNode(root, 44, obj.getOperation().toString());
        RecycledObjectExplorer.addNode(root, 43, obj.getDropTime());
        RecycledObjectExplorer.addNode(root, 13, Boolean.toString(obj.canPurge()));
        RecycledObjectExplorer.addNode(root, 50, Boolean.toString(obj.canUndrop()));
        TreeNodeMaker nodeMaker = new TreeNodeMaker(true, new String[]{"COLUMN"});
        DBObjectID id = obj.getBaseObjectID();
        if (id != null) {
            try {
                DBObject base = id.resolveID();
                if (base != null) {
                    if (ModelUtil.hasLength((String)name)) {
                        base = (DBObject)base.copyTo(null);
                        base.setName(name);
                    }
                    root.add(nodeMaker.createTreeNode(base));
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return root;
    }

    private static void addNode(DefaultMutableTreeNode root, int prop, String value) {
        if (ModelUtil.hasLength((String)value)) {
            String label = DBExplorerArb.getString(prop) + ": " + value;
            DefaultMutableTreeNode propNode = new DefaultMutableTreeNode(label);
            root.add(propNode);
        }
    }

    protected boolean isValidNode(Node node) {
        if (node instanceof DBObjectNode) {
            return ((DBObjectNode)node).getObjectType().equals("RECYCLEBIN");
        }
        return false;
    }

    protected TreeCellRenderer getCellRenderer() {
        return new DBObjectExplorerCellRenderer();
    }
}

