/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import oracle.ide.model.Project;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.JdevPathClassLocator;
import oracle.jdeveloper.java.locator.LibraryClassLocator;
import oracle.jdeveloper.java.locator.ProjectClassLocator;
import oracle.jdeveloper.library.Library;

public class JdevClassLocatorFactory
extends ClassLocatorFactory {
    public static BaseClassLocator getLibraryLocator(Library library) {
        if (library != null) {
            return new LibraryClassLocator(library);
        }
        return null;
    }

    public static BaseClassLocator getLibraryLocator(Library[] libraries) {
        if (libraries != null) {
            int libraryCount = libraries.length;
            if (libraryCount == 0) {
                return BaseClassLocator.EMPTY_LOCATOR;
            }
            BaseClassLocator[] libraryLocators = new BaseClassLocator[libraryCount];
            int i = 0;
            while (i < libraryCount) {
                BaseClassLocator locator = JdevClassLocatorFactory.getLibraryLocator(libraries[i]);
                libraryLocators[i] = locator != null ? locator : BaseClassLocator.EMPTY_LOCATOR;
                ++i;
            }
            return new ArrayClassLocator(libraryLocators);
        }
        return null;
    }

    public static BaseClassLocator getProjectLocator(Project project) {
        if (project != null) {
            return new ProjectClassLocator(project);
        }
        return null;
    }

    public BaseClassLocator getPathLocator(URLPath sourcePath, URLPath classPath) {
        if (sourcePath != null || classPath != null) {
            return new JdevPathClassLocator(sourcePath, classPath);
        }
        return super.getPathLocator(sourcePath, classPath);
    }
}

