/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.library.Library;

public class LibraryClassLocator
extends BaseClassLocator {
    private BaseClassLocator _classLocator;
    private boolean _hasNoClassPath;
    private BaseClassLocator _sourceLocator;

    protected LibraryClassLocator(Library library) {
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        URLPath sourcePath = library.getSourcePath();
        this._sourceLocator = LibraryClassLocator.ensureValid((BaseClassLocator)factory.getSourceLocator(sourcePath));
        URLPath classPath = library.getClassPath();
        this._classLocator = LibraryClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(classPath));
        this._hasNoClassPath = classPath == null || classPath.size() == 0;
    }

    public void buildIndex() {
        this._classLocator.buildIndex();
        if (this._hasNoClassPath) {
            this._sourceLocator.buildIndex();
        }
    }

    protected void getPackages(String packagePrefix, Collection out) {
        this._classLocator.getPackages(packagePrefix, out);
        if (this._hasNoClassPath) {
            this._sourceLocator.getPackages(packagePrefix, out);
        }
    }

    protected void getClassesInPackage(String packagePrefix, Collection out) {
        this._classLocator.getClassesInPackage(packagePrefix, out);
        if (this._hasNoClassPath) {
            this._sourceLocator.getClassesInPackage(packagePrefix, out);
        }
    }

    protected void getAllClasses(Collection out, ClassNameFilter filter) {
        this._classLocator.getAllClasses(out, filter);
        if (this._hasNoClassPath) {
            this._sourceLocator.getAllClasses(out, filter);
        }
    }

    protected void getAllPackages(Collection out, PackageNameFilter filter) {
        this._classLocator.getAllPackages(out, filter);
        if (this._hasNoClassPath) {
            this._sourceLocator.getAllPackages(out, filter);
        }
    }

    public URL getURL(String fqClassName) {
        URL url = this.getClassURL(fqClassName);
        if (this._hasNoClassPath && url == null) {
            url = this.getSourceURL(fqClassName);
        }
        return url;
    }

    public URL getSourceURL(String fqClassName) {
        return this._sourceLocator.getSourceURL(fqClassName);
    }

    public URL getClassURL(String fqClassName) {
        return this._classLocator.getClassURL(fqClassName);
    }

    public URL getResourceURL(String resourceName) {
        return this._classLocator.getResourceURL(resourceName);
    }
}

