/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.locator.JdevClassLocatorFactory;
import oracle.jdeveloper.java.locator.ProjectClassLocator;
import oracle.jdeveloper.java.provider.CachedFileProvider;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.library.ProjectLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFileProvider
extends CachedFileProvider {
    private static final Object KEY = ProjectFileProvider.class;
    private JavaClassLocator _locator;
    private Project _project;
    private int _j2se;
    private Map _cache;
    protected final Observer _projectObserver;

    public static ProjectFileProvider getInstance(Project project) {
        return ProjectFileProvider.getInstance(project, KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectFileProvider getInstance(Project project, Object key) {
        if (project == null) {
            return null;
        }
        Map properties = project.getTransientProperties();
        Object object = key;
        synchronized (object) {
            ProjectFileProvider provider = (ProjectFileProvider)((Object)properties.get(key));
            if (provider == null) {
                ProviderContext e = JavaModelFactory.getInstance().newContext();
                provider = new ProjectFileProvider(e, project);
                properties.put(key, provider);
            }
            ProjectFileProvider projectFileProvider = provider;
            return projectFileProvider;
        }
    }

    private static ProjectFileProvider lookupProvider(Project project, Object key) {
        return (ProjectFileProvider)((Object)project.getTransientProperties().get(key));
    }

    public ProjectFileProvider(ProviderContext e, Project project) {
        super(e, project.getShortLabel());
        this.$init$();
        this._project = project;
        this._project.attach(this._projectObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectFileProvider(ProviderContext e, Project project, Map cache) {
        this(e, project);
        this._cache = cache;
        Map map = cache;
        synchronized (map) {
            cache.put(project, this);
        }
    }

    private void $init$() {
        this._j2se = 3;
        this._cache = null;
        this._projectObserver = new 4();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleProjectClose() {
        if (this._cache != null) {
            Map map = this._cache;
            synchronized (map) {
                this._cache.remove(this._project);
            }
        }
        this._project.detach(this._projectObserver);
        this.clearAllData();
        this.clearClassLoader();
    }

    protected void handleProjectLoad() {
        1 r = new 1();
        this._project.runUnderReadLock((Runnable)r);
    }

    public void handleProjectPathsChange() {
        2 r = new 2();
        this._project.runUnderReadLock((Runnable)r);
    }

    protected void handleProjectContentsChange() {
        3 r = new 3();
        this._project.runUnderReadLock((Runnable)r);
    }

    public JavaClassLocator getClassLocator() {
        JavaClassLocator[] ret = new JavaClassLocator[1];
        Runnable r = new 5(this, ret);
        this._project.runUnderReadLock(r);
        if (ret[0] != null) {
            return ret[0];
        }
        r = new 6(this, ret);
        NodeUtil.runUnderWriteLock(this.getProjectDependencies(this._project), (Runnable)r);
        return ret[0];
    }

    private Collection<Project> getProjectDependencies(Project project) {
        HashSet<Project> projects = new HashSet<Project>();
        projects.add(project);
        DependencyConfiguration dc = DependencyConfiguration.getInstance((Project)project);
        for (Object dep : dc.getAllDependenciesList()) {
            if (!(dep instanceof ProjectLibrary)) continue;
            ProjectLibrary lib = (ProjectLibrary)dep;
            projects.add((Project)lib.getSource());
        }
        return projects;
    }

    public void reloadClassLocator() {
        7 r = new 7();
        this._project.runUnderReadLock((Runnable)r);
        this.getClassLocator();
    }

    public SourceClass getProjectSourceClass(String fqClassName) {
        JavaClassLocator locator = this.getClassLocator();
        if (locator instanceof ProjectClassLocator) {
            ProjectClassLocator projectLocator = (ProjectClassLocator)locator;
            URL projectSourceURL = projectLocator.getProjectSourceURL(fqClassName, true);
            if (projectSourceURL != null) {
                return this.getSourceClass(fqClassName);
            }
            URL nonProjectSourceURL = projectLocator.getNonProjectSourceURL(fqClassName);
            if (nonProjectSourceURL != null) {
                return null;
            }
            SourceClass sourceClass = this.getSourceClass(fqClassName);
            SourceFile sourceFile = sourceClass.getOwningSourceFile();
            URL sourceURL = sourceFile.getURL();
            if (this.isProjectSourceURL(sourceURL)) {
                return sourceClass;
            }
        }
        return null;
    }

    protected boolean isProjectSourceURL(URL sourceURL) {
        ArrayList<Project> processList = new ArrayList<Project>();
        processList.add(this._project);
        ArrayList<Project> doneList = new ArrayList<Project>();
        while (processList.size() > 0) {
            Project checkProject = (Project)processList.remove(0);
            doneList.add(checkProject);
            URLPath path = ProjectClassLocator.getSourcePathFor(checkProject);
            if (ProjectFileProvider.pathContainsURL(path, sourceURL)) {
                return true;
            }
            Collection dependencies = ProjectClassLocator.getDependentsFor(checkProject);
            for (Object dependent : dependencies) {
                Project dependentProject;
                if (dependent == null || !(dependent instanceof ProjectLibrary) || doneList.contains(dependentProject = (Project)((ProjectLibrary)dependent).getSource())) continue;
                processList.add(dependentProject);
            }
        }
        return false;
    }

    protected static boolean pathContainsURL(URLPath path, URL url) {
        URL[] pathURLs = path.getEntries();
        int count = pathURLs != null ? pathURLs.length : 0;
        int i = 0;
        while (i < count) {
            if (URLFileSystem.isBaseURLFor((URL)pathURLs[i], (URL)url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static {
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            8 listener = new 8();
            Compiler.getCompiler().addBuildSystemListener((BuildSystemListener)listener);
        }
    }

    private void fetchTargetJdkVersion() {
        BuildSystemConfiguration buildSysConfig = BuildSystemConfiguration.getInstance((PropertyStorage)this._project);
        int j2se = buildSysConfig.isJDK15OrHigher() ? 3 : 2;
        this._j2se = j2se;
    }

    protected int getTargetJdkVersion() {
        return this._j2se;
    }

    static Project ra$_project(ProjectFileProvider projectFileProvider) {
        return projectFileProvider._project;
    }

    static void mav$fetchTargetJdkVersion(ProjectFileProvider projectFileProvider) {
        projectFileProvider.fetchTargetJdkVersion();
    }

    static Object ra$KEY() {
        return KEY;
    }

    static ProjectFileProvider maS$lookupProvider(Project project, Object object) {
        return ProjectFileProvider.lookupProvider(project, object);
    }

    static void wa$_locator(ProjectFileProvider projectFileProvider, JavaClassLocator javaClassLocator) {
        projectFileProvider._locator = javaClassLocator;
    }

    static JavaClassLocator ra$_locator(ProjectFileProvider projectFileProvider) {
        return projectFileProvider._locator;
    }

    final class 1
    implements Runnable {
        public void run() {
            ProjectFileProvider.this.clearAllData();
            ProjectFileProvider.wa$_locator(ProjectFileProvider.this, null);
            ProjectFileProvider.this.clearClassLoader();
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            ProjectFileProvider.this.flushCache();
            ProjectFileProvider.this.clearCompiledInfo();
            ProjectFileProvider.wa$_locator(ProjectFileProvider.this, null);
            ProjectFileProvider.this.clearClassLoader();
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            ProjectFileProvider.this.flushFoundCache();
        }
    }

    final class 4
    implements Observer {
        public void update(Object observed, UpdateMessage change) {
            if (observed == ProjectFileProvider.ra$_project(ProjectFileProvider.this)) {
                int id = change.getMessageID();
                if (id == UpdateMessage.OBJECT_OPENED || id == UpdateMessage.OBJECT_RELOADED) {
                    ProjectFileProvider.this.handleProjectLoad();
                } else if (id == UpdateMessage.PROPERTY_SET) {
                    if (change.containsProperty("classPath") || change.containsProperty("sourcePath")) {
                        ProjectFileProvider.this.handleProjectPathsChange();
                    }
                } else if (id == UpdateMessage.CHILD_ADDED || id == UpdateMessage.CHILD_REMOVED || id == UpdateMessage.CHILD_RENAMED) {
                    ProjectFileProvider.this.handleProjectContentsChange();
                } else {
                    if (id == UpdateMessage.OBJECT_CLOSED) {
                        ProjectFileProvider.this.handleProjectClose();
                        return;
                    }
                    if (id == UpdateMessage.OBJECT_CLOSING) {
                        return;
                    }
                }
                ProjectFileProvider.mav$fetchTargetJdkVersion(ProjectFileProvider.this);
            }
        }
    }

    final class 5
    implements Runnable {
        private final /* synthetic */ JavaClassLocator[] v$ret;
        final /* synthetic */ ProjectFileProvider this$0;

        public void run() {
            this.v$ret[0] = ProjectFileProvider.ra$_locator(this.this$0);
        }

        public 5(ProjectFileProvider projectFileProvider, JavaClassLocator[] javaClassLocatorArray) {
            this.v$ret = javaClassLocatorArray;
            this.this$0 = projectFileProvider;
        }
    }

    final class 6
    implements Runnable {
        private final /* synthetic */ JavaClassLocator[] v$ret;
        final /* synthetic */ ProjectFileProvider this$0;

        public void run() {
            if (ProjectFileProvider.ra$_locator(this.this$0) == null) {
                ProjectFileProvider.wa$_locator(this.this$0, (JavaClassLocator)JdevClassLocatorFactory.getProjectLocator(ProjectFileProvider.ra$_project(this.this$0)));
            }
            this.v$ret[0] = ProjectFileProvider.ra$_locator(this.this$0);
        }

        public 6(ProjectFileProvider projectFileProvider, JavaClassLocator[] javaClassLocatorArray) {
            this.v$ret = javaClassLocatorArray;
            this.this$0 = projectFileProvider;
        }
    }

    final class 7
    implements Runnable {
        public void run() {
            ProjectFileProvider.wa$_locator(ProjectFileProvider.this, null);
            ProjectFileProvider.this.flushCache();
            ProjectFileProvider.this.clearCompiledInfo();
            ProjectFileProvider.this.clearClassLoader();
        }
    }

    static final class 8
    implements BuildSystemListener {
        private Context _lastContext;

        private void $init$() {
            this._lastContext = null;
        }

        public void buildWillStart(Context context) throws BuildSystemVetoException {
            this._lastContext = context;
        }

        public void buildFinished(int errorCount, int warningCount, int infoCount) throws BuildSystemVetoException {
            if (this._lastContext != null) {
                ProjectFileProvider provider;
                Project project = this._lastContext.getProject();
                if (project != null && (provider = ProjectFileProvider.maS$lookupProvider(project, ProjectFileProvider.ra$KEY())) != null) {
                    provider.handleProjectPathsChange();
                }
                this._lastContext = null;
            }
        }

        public void cleanWillStart(Context context) throws BuildSystemVetoException {
        }

        public void cleanFinished(Context context) throws BuildSystemVetoException {
        }

        public 8() {
            this.$init$();
        }
    }
}

