/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import javax.swing.Icon;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.marshal.AttributeMarker;
import oracle.jdeveloper.library.AbstractLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryDefinition;
import oracle.jdeveloper.resource.LibraryArb;

public final class AddinLibrary
extends AbstractLibrary
implements JLibrary {
    private final String _name;
    private final URLPath _clsPath;
    private final URLPath _srcPath;
    private final URLPath _docPath;
    private final Boolean _deployed;

    public AddinLibrary(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, Boolean deployed) {
        this._name = name;
        this._clsPath = new URLPath(clsPath);
        this._srcPath = new URLPath(srcPath);
        this._docPath = new URLPath(docPath);
        this._deployed = deployed != null ? deployed : Boolean.FALSE;
    }

    public String getName() {
        return this._name;
    }

    public URLPath getClassPath() {
        return new URLPath(this._clsPath);
    }

    public URLPath getSourcePath() {
        return new URLPath(this._srcPath);
    }

    public URLPath getDocPath() {
        return new URLPath(this._docPath);
    }

    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this._deployed;
    }

    public String getShortLabel() {
        return this._name;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(15);
    }

    public JLibraryDefinition getDefaultLibraryDefinition() {
        return this;
    }

    public JLibraryDefinition getLibraryDefinition(VersionNumber jdkVer) {
        return this;
    }

    public void setDeployedByDefault(Boolean deployed) {
        this.immutable();
    }

    public void markDirty(boolean dirty) {
        this.immutable();
    }

    public void setClassPath(URLPath clsPath) {
        this.immutable();
    }

    public void setDefaultClassPath(URLPath clsPath) {
        this.immutable();
    }

    public void setDefaultDocPath(URLPath docPath) {
        this.immutable();
    }

    public void setDefaultSourcePath(URLPath srcPath) {
        this.immutable();
    }

    public void setDocPath(URLPath docPath) {
        this.immutable();
    }

    public void setLocked(boolean isLocked) {
        this.immutable();
    }

    public void setName(String name) {
        this.immutable();
    }

    public void setSourcePath(URLPath srcPath) {
        this.immutable();
    }

    private void immutable() {
        throw new UnsupportedOperationException("AddinLibrary instances are immutable.");
    }
}

