/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.Arrays;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryAdapter;

public final class JDKAdapter
extends LibraryAdapter
implements JDK {
    private transient String[] _vms;

    public JDKAdapter(HashStructure hash) {
        super(hash);
    }

    public boolean equivalent(Library lib) {
        JDK jdk;
        JDK jDK = jdk = lib instanceof JDK ? (JDK)lib : null;
        if (!super.equivalent(jdk)) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jdk.getJavaExecutable(), (Object)this.getJavaExecutable())) {
            return false;
        }
        if (!Arrays.equals(jdk.getInstalledVMs(), this.getInstalledVMs())) {
            return false;
        }
        if (ModelUtil.areDifferent((Object)jdk.getJavaVersion(), (Object)this.getJavaVersion())) {
            return false;
        }
        return !ModelUtil.areDifferent((Object)jdk.getSDKBinDir(), (Object)this.getSDKBinDir());
    }

    public void initFromLibrary(Library lib) {
        if (lib instanceof JDK) {
            super.initFromLibrary(lib);
            JDK jdk = (JDK)lib;
            URL exe = jdk.getJavaExecutable();
            Object[] vms = jdk.getInstalledVMs();
            VersionNumber version = jdk.getJavaVersion();
            URL binDir = jdk.getSDKBinDir();
            if (ModelUtil.areDifferent((Object)exe, (Object)this.getJavaExecutable())) {
                this.setJavaExecutable(exe);
            }
            if (!Arrays.equals(vms, this.getInstalledVMs())) {
                this.setInstalledVMs((String[])vms);
            }
            if (ModelUtil.areDifferent((Object)version, (Object)this.getJavaVersion())) {
                this.setJavaVersion(version);
            }
            if (ModelUtil.areDifferent((Object)binDir, (Object)this.getSDKBinDir())) {
                this.setSDKBinDir(binDir);
            }
        }
    }

    public URL getJavaExecutable() {
        return this._hash.getURL("javaExecutable");
    }

    public void setJavaExecutable(URL url) {
        if (url == null) {
            this._hash.remove("javaExecutable");
        } else {
            this._hash.putURL("javaExecutable", url);
        }
    }

    public synchronized String[] getInstalledVMs() {
        if (this._vms == null && this.getSDKBinDir() != null) {
            this._vms = JDKUtil.getVMChoices(this.getSDKBinDir(), false);
        }
        return this._vms != null ? this._vms : new String[]{};
    }

    public synchronized void setInstalledVMs(String[] installedVMs) {
        this._vms = installedVMs;
    }

    public VersionNumber getJavaVersion() {
        String str = this._hash.getString("version");
        if (str != null) {
            try {
                VersionNumber versionNumber = (VersionNumber)ToStringManager.fromString((String)str, VersionNumber.class);
                return versionNumber;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setJavaVersion(VersionNumber ver) {
        if (ver == null) {
            this._hash.remove("version");
        } else {
            try {
                this._hash.putString("version", ToStringManager.toString((Object)ver, VersionNumber.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public URL getSDKBinDir() {
        return this._hash.getURL("sdkBinDir");
    }

    public void setSDKBinDir(URL url) {
        if (url == null) {
            this._hash.remove("sdkBinDir");
        } else {
            this._hash.putURL("sdkBinDir", url);
        }
    }

    public String getSDKBinJavaExecutableNoConsole() {
        URL url = this.getSDKBinDir();
        if (url != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }

    public String getJavaExecutableNoConsole() {
        URL url = this.getJavaExecutable();
        if (url != null && (url = URLFileSystem.getParent((URL)url)) != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }
}

