/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.net.URL;
import java.util.Arrays;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.VersionNumber;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.LibraryModel;
import oracle.jdeveloper.resource.ControlsArb;

public class JDKModel
extends LibraryModel {
    private URL exeURL;
    private URL sdkURL;
    private String[] vms;
    private VersionNumber version;

    public JDKModel(JDK lib, MutableLibraryList list, Component panel) {
        super(lib, list, panel);
    }

    public void setExecutable(URL exeURL) {
        this.exeURL = exeURL;
    }

    public void setVMs(String[] vms) {
        this.vms = vms;
    }

    public void setSDKDir(URL sdkURL) {
        this.sdkURL = sdkURL;
    }

    public void setJavaVersion(VersionNumber version) {
        this.version = version;
    }

    public Library commit() throws Exception {
        VersionNumber num;
        URL oldDir;
        Object[] oldVMs;
        super.commit();
        JDK jdk = (JDK)this.lib;
        if (this.exeURL == null || !URLFileSystem.isRegularFile((URL)this.exeURL)) {
            this.showError(ControlsArb.format(12, URLFileSystem.getPlatformPathName((URL)this.exeURL)), ControlsArb.getString(14));
            throw new Exception();
        }
        URL oldURL = jdk.getJavaExecutable();
        if (ModelUtil.areDifferent((Object)oldURL, (Object)this.exeURL)) {
            jdk.setJavaExecutable(this.exeURL);
        }
        if (!Arrays.equals(this.vms, oldVMs = jdk.getInstalledVMs())) {
            jdk.setInstalledVMs(this.vms);
        }
        if (ModelUtil.areDifferent((Object)this.sdkURL, (Object)(oldDir = jdk.getSDKBinDir()))) {
            jdk.setSDKBinDir(this.sdkURL);
        }
        if (ModelUtil.areDifferent((Object)(num = jdk.getJavaVersion()), (Object)this.version)) {
            jdk.setJavaVersion(this.version);
        }
        return this.lib;
    }
}

