/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTempFile;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaNode;

public final class JavaClassNode
extends JavaNode {
    public static final String EXT = ".class";

    protected Reader createReader(URL url) {
        String classText = this.getDecompiledClass(url);
        return classText == null ? null : new StringReader(classText);
    }

    protected void saveImpl() {
    }

    public boolean isReadOnly() {
        return true;
    }

    private String getDecompiledClass(URL url) {
        JavaManager javaManager;
        JavaFile javaFile;
        Project project;
        String cmd = System.getProperty("jcncmd");
        if (cmd != null) {
            try {
                URLTempFile tempFile = new URLTempFile(url);
                File file = tempFile.getFile();
                Process process = Runtime.getRuntime().exec(cmd + " " + file.getAbsolutePath());
                BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuffer buf = new StringBuffer();
                1 outputPump = new 1(this, br, buf);
                outputPump.start();
                int exitCode = process.waitFor();
                outputPump.join();
                if (exitCode == 0) {
                    String string = buf.toString();
                    return string;
                }
            }
            catch (Throwable e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "decompiling " + URLFileSystem.getPlatformPathName((URL)url) + " using \"" + cmd + "\"", e);
            }
        }
        if ((project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        if (project != null && (javaFile = (javaManager = JavaManager.getJavaManager(project)).getFile(url)) != null) {
            return JavaClassNode.emitFile(javaFile);
        }
        return null;
    }

    private static String emitFile(JavaFile javaFile) {
        StringBuffer out = new StringBuffer(4096);
        JavaClassNode.emitComment(0, "", out);
        JavaClassNode.emitComment(0, "Oracle JDeveloper Stub Generated Source", out);
        JavaClassNode.emitComment(0, "", out);
        JavaClassNode.emitPackage(javaFile.getPackageName(), out);
        JavaClass javaClass = javaFile.getPrimaryClass();
        JavaClassNode.emitClass(javaClass, out);
        return out.toString();
    }

    private static void emitPackage(String packageName, StringBuffer out) {
        if (packageName != null && packageName.length() > 0) {
            out.append("package ");
            out.append(packageName);
            out.append(";");
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitEOL(out);
        }
    }

    private static void emitClass(JavaClass javaClass, StringBuffer out) {
        Collection methods;
        boolean hasMethods;
        Collection fields;
        boolean hasFields;
        Iterator iterator;
        String superClassName;
        String modifierText = JavaClassNode.getClassModifiers(javaClass);
        if (modifierText.length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpace(out);
        }
        boolean isInterface = false;
        boolean isAnnotation = false;
        if (javaClass.isAnnotation()) {
            out.append("@interface");
            isAnnotation = true;
        } else if (javaClass.isInterface()) {
            out.append("interface");
            isInterface = true;
        } else {
            out.append("class");
        }
        JavaClassNode.emitSpace(out);
        out.append(javaClass.getName());
        JavaClassNode.emitEOL(out);
        JavaType superClass = javaClass.getSuperclass();
        if (!isAnnotation && superClass != null && !"java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
            JavaClassNode.emitIndent(1, out);
            out.append("extends ");
            out.append(superClassName);
            JavaClassNode.emitEOL(out);
        }
        Collection unresolvedInterfaces = javaClass.getUnresolvedInterfaces();
        if (!isAnnotation && !unresolvedInterfaces.isEmpty()) {
            String superTypesIndent;
            JavaClassNode.emitIndent(1, out);
            if (isInterface) {
                out.append("extends ");
                superTypesIndent = "        ";
            } else {
                out.append("implements ");
                superTypesIndent = "           ";
            }
            iterator = unresolvedInterfaces.iterator();
            out.append(((UnresolvedType)iterator.next()).getSimplifiedName());
            String comma = ",\n";
            while (iterator.hasNext()) {
                out.append(comma);
                JavaClassNode.emitIndent(1, out);
                out.append(superTypesIndent);
                out.append(((UnresolvedType)iterator.next()).getSimplifiedName());
            }
            JavaClassNode.emitEOL(out);
        }
        out.append("{");
        JavaClassNode.emitEOL(out);
        Collection constructors = javaClass.getDeclaredConstructors();
        iterator = constructors.iterator();
        boolean hasConstructors = iterator.hasNext();
        if (hasConstructors) {
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Constructors", out);
            JavaClassNode.emitComment(1, "", out);
        }
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                JavaClassNode.emitEOL(out);
            }
            first = false;
            JavaMethod constructor = (JavaMethod)iterator.next();
            JavaClassNode.emitMethod(constructor, out);
        }
        if (hasConstructors) {
            JavaClassNode.emitEOL(out);
        }
        if (hasFields = (iterator = (fields = javaClass.getDeclaredFields()).iterator()).hasNext()) {
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Fields", out);
            JavaClassNode.emitComment(1, "", out);
        }
        first = true;
        while (iterator.hasNext()) {
            if (!first) {
                JavaClassNode.emitEOL(out);
            }
            first = false;
            JavaField field = (JavaField)iterator.next();
            JavaClassNode.emitField(field, out);
        }
        if (hasFields) {
            JavaClassNode.emitEOL(out);
        }
        if (hasMethods = (iterator = (methods = javaClass.getDeclaredMethods()).iterator()).hasNext()) {
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Methods", out);
            JavaClassNode.emitComment(1, "", out);
        }
        first = true;
        while (iterator.hasNext()) {
            if (!first) {
                JavaClassNode.emitEOL(out);
            }
            first = false;
            JavaMethod method = (JavaMethod)iterator.next();
            JavaClassNode.emitMethod(method, out);
        }
        out.append("}");
        JavaClassNode.emitEOL(out);
    }

    private static void emitField(JavaField javaField, StringBuffer out) {
        UnresolvedType type;
        JavaClassNode.emitIndent(1, out);
        String modifierText = JavaClassNode.getFieldModifiers(javaField);
        if (modifierText.length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpace(out);
        }
        out.append((type = javaField.getUnresolvedType()) == null ? "java.lang.Object" : type.toString());
        JavaClassNode.emitSpace(out);
        out.append(javaField.getName());
        out.append(";");
        JavaClassNode.emitEOL(out);
    }

    private static void emitMethod(JavaMethod javaMethod, StringBuffer out) {
        boolean isConstructor;
        String modifierText;
        JavaClassNode.emitIndent(1, out);
        Collection annotations = javaMethod.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            JavaClassNode.emitAnnotations(annotations, out);
        }
        String string = modifierText = (isConstructor = javaMethod.isConstructor()) ? JavaClassNode.getConstructorModifiers(javaMethod) : JavaClassNode.getMethodModifiers(javaMethod);
        if (modifierText.length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpace(out);
        }
        JavaClass javaClass = javaMethod.getOwningClass();
        if (isConstructor) {
            out.append(javaClass.getName());
        } else {
            JavaType returnType = javaMethod.getReturnType();
            if (returnType != null) {
                out.append(returnType.getQualifiedName());
                JavaClassNode.emitSpace(out);
            }
            out.append(javaMethod.getName());
        }
        JavaClassNode.emitMethodParameters(javaMethod, out);
        if (javaClass.isAnnotation()) {
            Object defaultValue = javaMethod.getDefaultValue();
            if (defaultValue != null) {
                JavaClassNode.emitSpace(out);
                out.append("default");
                JavaClassNode.emitSpace(out);
                if ("java.lang.String".equals(javaMethod.getReturnType().getQualifiedName())) {
                    out.append("\"" + defaultValue + "\"");
                } else if ("java.lang.Class".equals(javaMethod.getReturnType().getQualifiedName())) {
                    JavaClass classObject = (JavaClass)defaultValue;
                    out.append(classObject.getName() + EXT);
                } else if (javaMethod.getReturnType().isEnum()) {
                    JavaField fieldObject = (JavaField)defaultValue;
                    out.append(fieldObject.getOwningClass().getName() + "." + fieldObject.getName());
                } else {
                    out.append(defaultValue);
                }
            }
            out.append(";");
        } else {
            JavaClassNode.emitSpace(out);
            out.append("{ }");
        }
        JavaClassNode.emitEOL(out);
    }

    private static void emitMethodParameters(JavaMethod javaMethod, StringBuffer out) {
        out.append("(");
        Collection parameters = javaMethod.getParameters();
        if (parameters != null) {
            String comma = "";
            int index = 1;
            for (JavaVariable parameter : parameters) {
                out.append(comma);
                comma = ", ";
                UnresolvedType type = parameter.getUnresolvedType();
                out.append(type == null ? "java.lang.Object" : type.toString());
                JavaClassNode.emitSpace(out);
                String parameterName = parameter.getName();
                if (parameterName != null && parameterName.length() > 0) {
                    out.append(parameterName);
                    continue;
                }
                out.append("p").append(index++);
            }
        }
        out.append(")");
    }

    private static String getFieldModifiers(JavaField javaField) {
        int modifiers = javaField.getModifiers();
        return Modifier.toString(modifiers);
    }

    private static String getMethodModifiers(JavaMethod javaMethod) {
        JavaClass javaClass = javaMethod.getOwningClass();
        boolean isInterfaceMethod = javaClass.isInterface();
        int modifiers = javaMethod.getModifiers();
        if (isInterfaceMethod) {
            modifiers &= 0xFFFFFBFE;
        }
        return Modifier.toString(modifiers);
    }

    private static String getConstructorModifiers(JavaMethod javaMethod) {
        StringBuffer out = new StringBuffer(30);
        int modifiers = javaMethod.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            out.append("public ");
        }
        if (Modifier.isPrivate(modifiers)) {
            out.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            out.append("protected ");
        }
        if (Modifier.isAbstract(modifiers)) {
            out.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            out.append("final ");
        }
        return out.toString().trim();
    }

    private static String getClassModifiers(JavaClass javaClass) {
        StringBuffer out = new StringBuffer(30);
        int modifiers = javaClass.getModifiers();
        boolean isInterface = javaClass.isInterface();
        if (Modifier.isPublic(modifiers)) {
            out.append("public ");
        }
        if (Modifier.isPrivate(modifiers)) {
            out.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            out.append("protected ");
        }
        if (!isInterface && Modifier.isAbstract(modifiers)) {
            out.append("abstract ");
        }
        if (Modifier.isStatic(modifiers)) {
            out.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            out.append("final ");
        }
        if (Modifier.isNative(modifiers)) {
            out.append("native ");
        }
        return out.toString().trim();
    }

    private static void emitEOL(StringBuffer out) {
        out.append("\n");
    }

    private static void emitSpace(StringBuffer out) {
        out.append(" ");
    }

    private static void emitIndent(int level, StringBuffer out) {
        int i = 0;
        while (i < level) {
            out.append("\t");
            ++i;
        }
    }

    private static void emitComment(int level, String comment, StringBuffer out) {
        JavaClassNode.emitIndent(level, out);
        out.append("// ");
        if (comment != null) {
            out.append(comment);
        }
        JavaClassNode.emitEOL(out);
    }

    private static void emitAnnotations(Collection annotations, StringBuffer out) {
        for (Object element : annotations) {
            if (!(element instanceof JavaAnnotation)) continue;
            JavaAnnotation annotation = (JavaAnnotation)element;
            JavaType annotationType = annotation.getAnnotationType();
            if (annotationType != null) {
                out.append("@" + annotationType.getName());
            } else {
                out.append("@" + annotation.getUnresolvedType().getSimplifiedName());
            }
            JavaClassNode.emitEOL(out);
            Map components = annotation.getComponents();
            if (components != null && components.size() > 0) {
                JavaClassNode.emitIndent(1, out);
                out.append("(");
                JavaClassNode.emitEOL(out);
                Iterator j = components.keySet().iterator();
                while (j.hasNext()) {
                    String key = (String)j.next();
                    Collection declaredMethods = annotation.getAnnotationType().getDeclaredMethods(key);
                    if (declaredMethods == null || declaredMethods.size() != 1) continue;
                    JavaMethod attribute = (JavaMethod)declaredMethods.toArray()[0];
                    JavaClassNode.emitIndent(2, out);
                    out.append(key);
                    JavaClassNode.emitSpace(out);
                    out.append("=");
                    JavaClassNode.emitSpace(out);
                    if ("java.lang.String".equals(attribute.getReturnType().getQualifiedName())) {
                        out.append("\"" + components.get(key) + "\"");
                    } else if ("java.lang.Class".equals(attribute.getReturnType().getQualifiedName())) {
                        JavaClass classObject = (JavaClass)components.get(key);
                        out.append(classObject.getName() + EXT);
                    } else if (attribute.getReturnType().isEnum()) {
                        JavaField fieldObject = (JavaField)components.get(key);
                        out.append(fieldObject.getOwningClass().getName() + "." + fieldObject.getName());
                    } else {
                        out.append(components.get(key));
                    }
                    if (j.hasNext()) {
                        out.append(",");
                    }
                    JavaClassNode.emitEOL(out);
                }
                JavaClassNode.emitIndent(1, out);
                out.append(")");
                JavaClassNode.emitEOL(out);
                JavaClassNode.emitIndent(1, out);
            }
            JavaClassNode.emitIndent(1, out);
        }
    }

    final class 1
    extends Thread {
        private final /* synthetic */ BufferedReader v$br;
        private final /* synthetic */ StringBuffer v$buf;
        final /* synthetic */ JavaClassNode this$0;

        public void run() {
            try {
                String line;
                while ((line = this.v$br.readLine()) != null) {
                    this.v$buf.append(line).append("\n");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public 1(JavaClassNode javaClassNode, BufferedReader bufferedReader, StringBuffer stringBuffer) {
            this.v$buf = stringBuffer;
            this.v$br = bufferedReader;
            this.this$0 = javaClassNode;
        }
    }
}

