/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TraversableContext;
import oracle.jdeveloper.model.JavaProject;

public class OutputDirectoryMigrator
extends NodeMigratorHelper {
    private static final OutputDirectoryMigrator INSTANCE = new OutputDirectoryMigrator();

    public static OutputDirectoryMigrator getInstance() {
        return INSTANCE;
    }

    private OutputDirectoryMigrator() {
    }

    public void migrate(MigrationInfo[] infos, TraversableContext context) {
        MigrationInfo[] migrationInfoArray = infos;
        int n = 0;
        while (n < migrationInfoArray.length) {
            String path;
            Project project;
            JavaProject jp;
            URL output;
            MigrationInfo info = migrationInfoArray[n];
            Node node = info.getNode();
            if (node instanceof Project && (output = (jp = JavaProject.getInstance(project = (Project)node)).getOutputDirectory()) != null && !(path = output.getPath()).endsWith("/")) {
                output = URLFactory.newDirURL((String)path);
                jp.setOutputDirectory(output);
            }
            ++n;
        }
    }
}

