/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.buildtools;

import java.net.URL;
import java.util.Set;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.model.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = "oracle.jdevimpl.buildtools.ModuleConfiguration";
    public static final String EXTENSION_ID_KEY = "module.extension.id";
    public static final String SIMPLE_JAR_KEY = "module.simplejar.path";
    public static final String SOURCE_ZIP_KEY = "module.sourcezip.path";
    public static final String EXTENSION_DIR_KEY = "module.extension.dir";
    public static final String DEPLOY_TYPE_KEY = "module.deploy.type";
    public static final String PRIMARY_CONTACT_KEY = "module.primary.contact";
    public static final String TRANSLATION_LANGUAGES_KEY = "module.translation.languages";
    private final Project _project;

    private ModuleConfiguration(Project project, HashStructure hash) {
        super(hash);
        if (project == null) {
            throw new NullPointerException("project is null");
        }
        this._project = project;
    }

    public static ModuleConfiguration getInstance(Project project) {
        return ModuleConfiguration.getInstance(project, (PropertyStorage)project);
    }

    public static ModuleConfiguration getInstance(Project project, PropertyStorage ps) {
        return new ModuleConfiguration(project, ps.getProperties().getOrCreateHashStructure(DATA_KEY));
    }

    public URL getSimpleJarPath() {
        return this._hash.getURL(SIMPLE_JAR_KEY);
    }

    public void setSimpleJarPath(URL simpleZipPath) {
        this._hash.putURL(SIMPLE_JAR_KEY, simpleZipPath);
    }

    public URL getSourceZipPath() {
        return this._hash.getURL(SOURCE_ZIP_KEY);
    }

    public void setSourceZipPath(URL sourceZipPath) {
        this._hash.putURL(SOURCE_ZIP_KEY, sourceZipPath);
    }

    public String getExtensionID() {
        return this._hash.getString(EXTENSION_ID_KEY);
    }

    public void setExtensionID(String extensionId) {
        this._hash.putString(EXTENSION_ID_KEY, extensionId);
    }

    public Set<String> getPropertyNames() {
        return this._hash.keySet();
    }

    public URL getURL(String propertyName) {
        return this._hash.getURL(propertyName);
    }

    public void setURL(String propertyName, URL url) {
        this._hash.putURL(propertyName, url);
    }

    public URL getExtensionDir() {
        return this._hash.getURL(EXTENSION_DIR_KEY);
    }

    public void setExtensionDir(URL extensionDir) {
        this._hash.putURL(EXTENSION_DIR_KEY, extensionDir);
    }

    public DeployType getDeployType() {
        String deployTypeAsString = this._hash.getString(DEPLOY_TYPE_KEY);
        if (deployTypeAsString != null && deployTypeAsString.length() > 0) {
            return DeployType.valueOf(deployTypeAsString);
        }
        if (this.getExtensionID() != null && this.getExtensionID().length() > 0) {
            return DeployType.EXTENSION_JAR;
        }
        if (this.getSimpleJarPath() != null) {
            return DeployType.SIMPLE_JAR;
        }
        return DeployType.NONE;
    }

    public void setDeployType(DeployType deployType) {
        this._hash.putString(DEPLOY_TYPE_KEY, deployType.toString());
    }

    public URLPath getClassPath() throws TransientMarker {
        URLPath urlPath = new URLPath();
        URL simpleJarPath = this.getSimpleJarPath();
        if (simpleJarPath != null) {
            urlPath.add(URLFactory.newJarURL((URL)simpleJarPath, (String)""));
        } else {
            String extensionId = this.getExtensionID();
            if (extensionId != null) {
                URL extensionsDir = this.getExtensionDir();
                if (extensionsDir == null) {
                    URL outputDir = JavaProject.getInstance(this._project).getOutputDirectory();
                    extensionsDir = URLFactory.newDirURL((URL)outputDir, (String)"../../../jdev/extensions/");
                }
                URL extensionJar = URLFactory.newJarURL((URL)URLFactory.newURL((URL)extensionsDir, (String)(extensionId + ".jar")), (String)"");
                urlPath.add(extensionJar);
            }
        }
        return urlPath;
    }

    public String getPrimaryContact() {
        return this._hash.getString(PRIMARY_CONTACT_KEY);
    }

    public void setPrimaryContact(String contact) {
        this._hash.putString(PRIMARY_CONTACT_KEY, contact);
    }

    public String getTranslationLanguages() {
        return this._hash.getString(TRANSLATION_LANGUAGES_KEY);
    }

    public void setTranslationLanguages(String translationLanguages) {
        this._hash.putString(TRANSLATION_LANGUAGES_KEY, translationLanguages);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeployType
    extends Enum<DeployType> {
        private static final /* synthetic */ DeployType[] $v;
        public static final /* enum */ DeployType NONE;
        public static final /* enum */ DeployType SIMPLE_JAR;
        public static final /* enum */ DeployType EXTENSION_JAR;

        public static DeployType valueOf(String string) {
            return Enum.valueOf(DeployType.class, string);
        }

        public static final DeployType[] values() {
            return (DeployType[])$v.clone();
        }

        static {
            DeployType[] deployTypeArray = new DeployType[3];
            deployTypeArray[2] = EXTENSION_JAR = new DeployType("EXTENSION_JAR", 2);
            deployTypeArray[1] = SIMPLE_JAR = new DeployType("SIMPLE_JAR", 1);
            deployTypeArray[0] = NONE = new DeployType("NONE", 0);
            $v = deployTypeArray;
        }

        private DeployType(String string2, int n2) {
        }
    }
}

