/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;

public final class LibrariesHook
extends ExtensionHook {
    public static final ElementName ELEMENT = LibrariesHook.e("libraries");
    private static String LIBRARY = "Library";
    private static String LIBRARYNAME = "LibraryName";
    private static String LIBRARYDEPLOYED = "LibraryDeployed";
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/1013/jdev-libraries";
    private ElementVisitor _libraryHandler;
    private ElementVisitor _aliasHandler;
    private final List _aliases;
    private final List _libraries;

    private void $init$() {
        this._libraryHandler = new LibraryHandler(null);
        this._aliasHandler = new AliasHandler(null);
        this._aliases = new ArrayList();
        this._libraries = new ArrayList();
    }

    public Collection getAliases() {
        return this._aliases;
    }

    public Collection getLibraries() {
        return this._libraries;
    }

    private static final ElementName e(String name) {
        return new ElementName(NS, name);
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(LibrariesHook.e("library"), this._libraryHandler);
        context.registerChildVisitor(LibrariesHook.e("alias"), this._aliasHandler);
    }

    public LibrariesHook() {
        this.$init$();
    }

    static List ra$_aliases(LibrariesHook librariesHook) {
        return librariesHook._aliases;
    }

    static URI mav$resolvePath(LibrariesHook librariesHook, ElementContext elementContext, String string) {
        return librariesHook.resolvePath(elementContext, string);
    }

    static String ra$LIBRARY() {
        return LIBRARY;
    }

    static String ra$LIBRARYNAME() {
        return LIBRARYNAME;
    }

    static String ra$LIBRARYDEPLOYED() {
        return LIBRARYDEPLOYED;
    }

    static List ra$_libraries(LibrariesHook librariesHook) {
        return librariesHook._libraries;
    }

    static ElementName maS$e(String string) {
        return LibrariesHook.e(string);
    }

    private class AliasHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String from = context.getAttributeValue("from");
            String to = context.getAttributeValue("to");
            LibrariesHook.ra$_aliases(LibrariesHook.this).add(new LibraryAlias(from, to, null));
        }

        private AliasHandler() {
        }

        AliasHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class LibraryHandler
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            context.registerChildVisitor(LibrariesHook.maS$e("classpath"), (ElementVisitor)new ClassPathHandler(null));
            context.registerChildVisitor(LibrariesHook.maS$e("docpath"), (ElementVisitor)new DocPathHandler(null));
            context.registerChildVisitor(LibrariesHook.maS$e("srcpath"), (ElementVisitor)new SrcPathHandler(null));
            context.getScopeData().put(LibrariesHook.ra$LIBRARYNAME(), context.getAttributeValue("name"));
            context.getScopeData().put(LibrariesHook.ra$LIBRARYDEPLOYED(), context.getAttributeValue("deployed"));
            context.getScopeData().put(LibrariesHook.ra$LIBRARY(), new LibraryObject());
        }

        public void end(ElementEndContext context) {
            String name = (String)context.getScopeData().get(LibrariesHook.ra$LIBRARYNAME());
            LibraryObject library = this.getLibrary((ElementContext)context);
            String deployed = (String)context.getScopeData().get(LibrariesHook.ra$LIBRARYDEPLOYED());
            boolean isDeployed = deployed != null && deployed.equalsIgnoreCase("true");
            LibrariesHook.ra$_libraries(LibrariesHook.this).add(new LibraryInfo(name, library._classPath, library._srcPath, library._docPath, isDeployed ? Boolean.TRUE : Boolean.FALSE, null));
        }

        private LibraryObject getLibrary(ElementContext context) {
            return (LibraryObject)context.getScopeData().get(LibrariesHook.ra$LIBRARY());
        }

        private void addURLPath(URLPath path, ElementEndContext context) {
            String text = context.getText();
            if ((text = text.replace('\\', '/')) == null || (text = text.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Element must not be empty");
                return;
            }
            if (text.indexOf(59) >= 0) {
                this.log((ElementContext)context, Level.WARNING, "Use of path separator is no longer supported");
            }
            if (text.startsWith("http") || text.startsWith("https")) {
                path.add(URLFactory.newURL((String)text));
            } else {
                URI uri = LibrariesHook.mav$resolvePath(LibrariesHook.this, (ElementContext)context, text);
                String[] archiveExtensions = new String[]{".jar", ".war", ".ear", ".zip"};
                if (Arrays.asList(archiveExtensions).contains(VirtualFileSystem.getVirtualFileSystem().getSuffix(uri).toLowerCase())) {
                    uri = URIFactory.newJarURI((URI)uri, (String)"");
                } else {
                    String resultString = uri.toString();
                    int bangSlash = resultString.indexOf("!/");
                    if (bangSlash > 0) {
                        String jarUri = resultString.substring(0, bangSlash);
                        String entryUri = resultString.substring(bangSlash + 2);
                        uri = URIFactory.newJarURI((URI)URIFactory.newURI((String)jarUri), (String)entryUri);
                    }
                }
                try {
                    String urlPath;
                    URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                    if (text.length() > 0 && '/' == text.charAt(text.length() - 1) && "file".equals(url.getProtocol()) && (urlPath = url.getPath()).length() > 0 && urlPath.charAt(urlPath.length() - 1) != '/') {
                        url = URLFactory.newDirURL((String)(urlPath + '/'));
                    }
                    path.add(url);
                }
                catch (MalformedURLException mue) {
                    this.log((ElementContext)context, Level.SEVERE, "Malformed URL: " + uri);
                }
            }
        }

        private LibraryHandler() {
        }

        LibraryHandler(1 var2_2) {
            this();
        }

        static LibraryObject mav$getLibrary(LibraryHandler libraryHandler, ElementContext elementContext) {
            return libraryHandler.getLibrary(elementContext);
        }

        static void mav$addURLPath(LibraryHandler libraryHandler, URLPath uRLPath, ElementEndContext elementEndContext) {
            libraryHandler.addURLPath(uRLPath, elementEndContext);
        }

        class LibraryObject {
            URLPath _classPath;
            URLPath _srcPath;
            URLPath _docPath;

            private void $init$() {
                this._classPath = new URLPath();
                this._srcPath = new URLPath();
                this._docPath = new URLPath();
            }

            LibraryObject() {
                this.$init$();
            }
        }

        private final class ClassPathHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                LibraryHandler.mav$addURLPath(LibraryHandler.this, LibraryHandler.mav$getLibrary((LibraryHandler)LibraryHandler.this, (ElementContext)context)._classPath, context);
            }

            private ClassPathHandler() {
            }

            ClassPathHandler(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class DocPathHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                LibraryHandler.mav$addURLPath(LibraryHandler.this, LibraryHandler.mav$getLibrary((LibraryHandler)LibraryHandler.this, (ElementContext)context)._docPath, context);
            }

            private DocPathHandler() {
            }

            DocPathHandler(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class SrcPathHandler
        extends ElementVisitor {
            public void end(ElementEndContext context) {
                LibraryHandler.mav$addURLPath(LibraryHandler.this, LibraryHandler.mav$getLibrary((LibraryHandler)LibraryHandler.this, (ElementContext)context)._srcPath, context);
            }

            private SrcPathHandler() {
            }

            SrcPathHandler(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        public final class 1 {
        }
    }

    public final class LibraryInfo {
        private final String _name;
        private final URLPath _classPath;
        private final URLPath _sourcePath;
        private final URLPath _docPath;
        private final Boolean _deployed;

        private LibraryInfo(String name, URLPath classPath, URLPath sourcePath, URLPath docPath, Boolean isDeployed) {
            this._name = name;
            this._classPath = classPath;
            this._sourcePath = sourcePath;
            this._docPath = docPath;
            this._deployed = isDeployed;
        }

        public String getName() {
            return this._name;
        }

        public URLPath getClassPath() {
            return this._classPath;
        }

        public URLPath getDocPath() {
            return this._docPath;
        }

        public URLPath getSourcePath() {
            return this._sourcePath;
        }

        public Boolean isDeployed() {
            return this._deployed;
        }

        LibraryInfo(String string, URLPath uRLPath, URLPath uRLPath2, URLPath uRLPath3, Boolean bl, 1 var7_7) {
            this(string, uRLPath, uRLPath2, uRLPath3, bl);
        }

        public final class 1 {
        }
    }

    public final class LibraryAlias {
        private final String _from;
        private final String _to;

        private LibraryAlias(String from, String to) {
            this._from = from;
            this._to = to;
        }

        public String getFrom() {
            return this._from;
        }

        public String getTo() {
            return this._to;
        }

        LibraryAlias(String string, String string2, 1 var4_4) {
            this(string, string2);
        }

        public final class 1 {
        }
    }
}

